/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class LdapDebugging {
    public static void main(String[] args) throws ConfigurationException, NamingException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String userName = config.getProperty("userName").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        String adUserName = "CN=EG PB,OU=EG IT,OU=EGIT,DC=embassyindia,DC=com";
        String adUserPassword = "ParaBlu@153";
        String adUrl = "ldap://172.16.0.112:389";
        String adCn = "DC=embassyindia,DC=com";
        Document users = (Document)userDBCollection.find(new Document("userName", userName)).first();
        LdapContext ldapContext = LdapDebugging.getLdapContext(adUserName, adUserPassword, adUrl);
        SearchControls searchControls = LdapDebugging.getSearchControls();
        NamingEnumeration<SearchResult> answer = ldapContext.search(adCn, "sAMAccountName=" + userName, searchControls);
        if (answer.hasMore()) {
            Attributes attrs = answer.next().getAttributes();
            Attribute givenname = attrs.get("givenname");
            System.out.println(String.valueOf((String)givenname.get()) + "==========================");
        }
    }

    private static LdapContext getLdapContext(String adUserName, String adUserPassword, String adUrl) {
        InitialLdapContext ctx = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "Simple");
            env.put("java.naming.security.principal", adUserName);
            env.put("java.naming.security.credentials", adUserPassword);
            env.put("java.naming.provider.url", adUrl);
            env.put("java.naming.referral", "follow");
            ctx = new InitialLdapContext(env, null);
            System.out.println("LDAP Connection: COMPLETE");
        }
        catch (NamingException nex) {
            System.out.println("LDAP Connection: FAILED");
            nex.printStackTrace();
            System.exit(0);
        }
        return ctx;
    }

    private static SearchControls getSearchControls() {
        SearchControls cons = new SearchControls();
        cons.setSearchScope(2);
        String[] attrIDs = new String[]{"distinguishedName", "sn", "givenname", "mail", "displayName", "thumbnailPhoto"};
        cons.setReturningAttributes(attrIDs);
        return cons;
    }
}

