
#!/bin/bash
#                                                                                       #
# SCRIPT: ubuntu_service.sh		                                                #
# DATE:   27-Oct-2016                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems								#
# PURPOSE: Contains all the utility functions for Ubuntu platform                       #
# PLATFORM: Ubuntu                                                                      #

# Adding tomcat and www-data users to parablu group
function add_system_users()
{
	# for tomcat-user
	useradd tomcat
	# for parablu group
	addgroup parablu
	#link parablu to tomcat
	adduser tomcat parablu
	#link www-data to parablu
	adduser www-data parablu
}

# Install openssh-server, bash-completion, zip, ufw, telnet, traceroute, sysstat 
function install_common_packages () 
{
	#system Update/Upgrade
	apt-get -y --allow-unauthenticated update 
	apt-get -y upgrade 

	#common packages for ubunut server
	apt-get -y install openssh-server 
	apt-get -y install bash-completion 
	apt-get -y install zip 
	apt-get -y install ufw 
	apt-get -y install telnet 

	allow_network_firewall 
	apt-get -y install telnet 
	apt-get -y install traceroute 
	apt-get -y install sysstat 
}

#Enable network port
function allow_network_firewall ()
{
	echo 'y' | ufw enable                                             
      	ufw allow ssh
      	ufw allow https
      	ufw allow http  
#      	ufw allow 5984
}

#install jre
function install_jre ()
{
	echo "JRE is installed using deb package"
	#Java
#	apt-get -y install software-properties-common 
#	apt-get -y install python3-software-properties 
#	add-apt-repository -y ppa:openjdk-r/ppa 
#	apt-get -y --allow-unauthenticated update 
#	apt-get -y install openjdk-8-jre 
	cp ../installables/local_policy.jar /usr/lib/jvm/java-1.8.0-openjdk-amd64/jre/lib/security
	cp ../installables/US_export_policy.jar /usr/lib/jvm/java-1.8.0-openjdk-amd64/jre/lib/security
}

function install_rar ()
{
                cur_dir=`pwd`
                cd $DEFAULT_FILE_PATH
                #wget rarlab.com/rar/rarlinux-x64-5.1.1.tar.gz
                tar -xzvf ../installables/rarlinux-x64-5.1.1.tar.gz
                cd rar
                sudo make install
                cd $cur_dir

}
