#!/bin/bash
PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh
source $PARABLU_CONFIG_SCRIPT_PATH


function check_service ()
{
	if [[ "$action" == "restart" ]]; then
		service $service_name $action 2>&1 >> /dev/null
		sleep 10
	  	if (( $(ps -ef | grep -v grep | grep $service_name | wc -l) > 0 ))
		  then
			echo "$service_name Restarted Successfully!!!"
		
		else
			echo "$service_name is not running..Retrying to $action the $service_name..!!"
			n=0
        		until [ $n -ge 3 ]
        		do
	   			service $service_name $action 2>&1 >> /dev/null
		    		if (( $(ps -ef | grep -v grep | grep $service_name | wc -l) > 0 ))
 		    		then 
					echo "$service_name "$action"ed Succesfully"
					break
		    		else 
					echo "$service_name Failed to $action"
			
	    			fi
				n=$[$n+1]
	      			sleep 2
   			done
		fi
	fi

	if [[ "$action" == "start" ]]; then
	  	if (( $(ps -ef | grep -v grep | grep $service_name | wc -l) > 0 ))
		  then
			echo "$service_name is already running!!!"
			sleep 2


		elif (( $(ps -ef | grep -v grep | grep $service_name | wc -l) == 0 ))
			then
 				service $service_name $action 2>&1 >> /dev/null
				sleep 10
				if (( $(ps -ef | grep -v grep | grep $service_name | wc -l) > 0 ))
			    	then
					echo "$service_name Started Successfully!!!"
				fi
		else
			echo "$service_name is not running..Retrying to $action the $service_name..!!"
			n=0
        		until [ $n -ge 3 ]
        		do
	   			service $service_name $action 2>&1 >> /dev/null
		    		if (( $(ps -ef | grep -v grep | grep $service_name | wc -l) > 0 ))
 		    		then 
					echo "$service_name Started Succesfully"
					break
		    		else 
					echo "$service_name Failed to $action"
			
	    			fi
				n=$[$n+1]
	      			sleep 2
   			done
		fi
	fi

	if [[ "$action" == "stop" ]]; then
	  	  service $service_name $action 2>&1 >> /dev/null
		  sleep 10
		  if (( $(ps -ef | grep -v grep | grep $service_name | wc -l) == 0 ))
		  then
			echo "$service_name Stopped Succesfully!!!"
		  fi
	fi


}

function process_tomcat_job ()
{
	service_name="tomcat-job1"
	check_service
}

function process_tomcat_pcb ()
{
	service_name="tomcat-pcb1"
	check_service
}

function process_memcache ()
{
	service_name="memcached"
	check_service
}

function process_apache ()
{
	service_name="apache2"
	check_service
}

function process_activemq ()
{
        service_name="activemq"
	check_service
}

function process_mongo ()
{
	service_name="mongod"
	check_service
}

function paracloud_component_check ()
{
	process_memcache
	process_apache
	process_tomcat_pcb
	process_tomcat_job


}

function blukrypt_component_check ()
{
	process_memcache
	process_apache
	process_activemq
	process_tomcat_pcb
	process_tomcat_job
}


function mongodb_component_check ()
{
	process_mongo
}

function utility_service ()
{
	if [[ -z $action ]]; then
		echo "Script must be run with an argument like start, stop or reset "
		exit 1
	fi

	if [ "$action" != "start" ] && [ "$action" != "restart" ] && [ "$action" != "stop" ] ; then
		echo "Invalid Argument passed...!!! Arguments can only be 'start' 'stop' or 'restart'"
	exit 1
	fi

	tput clear
 	tput cup 8 20
            
       	echo "Do you really want to $action the services? (y/n)"
	read option
	if [[ $option = y ]]; then
		for a in ${SERVER_TYPE[@]};do
        	        case $a in
				0)	mongodb_component_check
					blukrypt_component_check ;;
				1)	paracloud_component_check ;;
				2) 	blukrypt_component_check ;;
				3)	mongodb_component_check ;;
				4)	mongodb_component_check ;;
			esac
		done
	fi
}


action=$1
utility_service

