#!/bin/bash
#                                                                                       #
# SCRIPT: bluvault_service.sh		                                                #
# DATE:   27-Oct-2016                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems								#
# PURPOSE: Contains all the utility functions for bluvault Installation                 #
# PLATFORM: Ubuntu                                                                      #

PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh
PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh
source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_CONFIG_SCRIPT_PATH

function deploy_portal ()
{
	if [[ $FILE_LOCATION == "jenkins" ]]; then
		wget -P $FILE_PATH $JENKINS_URL/$PORTAL_NEW_URL_PATH
	elif [[ $FILE_LOCATION == "dns" ]]; then
		wget --user $DNS_USERNAME --password $DNS_PASS -O $FILE_PATH/$PORTAL_S_NAME $DNS_URL/$PORTAL_S_NAME
	elif [[ $FILE_LOCATION == "local" ]]; then
		echo "Apply Patch from Local"
	else
		echo "Enter the config file and start the script again."
		exit
	fi

	service apache2 stop

	#backing-up old deploy
	if [ -e $UI_PATH/$portal_ui ]; then
		mkdir -p $BACKUP_OLD/portal
		cp -r $UI_PATH/$portat_ui  $BACKUP_OLD
	fi

	if [ -e $UI_PATH/$share_ui ]; then
		mv $UI_PATH/$share_ui $backup_date/portal
	fi

	# download latest UI 
	mkdir -p $UI_PATH/$portat_ui

	if [ -e $FILE_PATH/$portal_zip ] && [ "$EXCLUDE_PORTAL" != "true" ]; then
		unzip -oqq $FILE_PATH/$portal_zip -d $UI_PATH/$portat_ui
	else
		echo "file not found"
	fi
	rm -rf /var/www/html

}

function configure_portal_changes ()
{
	path=/var/www/portal/app/templates/default
	mkdir -p $path/documents
	mkdir -p $path/upload/profile
	mkdir -p $LOG_PATH/portal
	chmod -R 777 $LOG_PATH/portal
	chown -R www-data:www-data $LOG_PATH/portal
	mkdir -p $ARCHIVE_PATH/portal
        chmod -R 777 $ARCHIVE_PATH/portal

	path=/var/www/portal/app/templates/default
	if [ -e $FILE_PATH/$portal_zip ] && [ "$EXCLUDE_PORTAL" != "true" ]; then
	
		echo "--_ Changing New Portal values _--"
		sed -i "s|define('CLOUD_NAME'.*|define('CLOUD_NAME', '$CLOUD_NAME');|" /var/www/portal/app/Core/Config.php
		sed -i "s|define('PARACLOUD_IP'.*|define('PARACLOUD_IP', '$BLUVAULT_IP');|" /var/www/portal/app/Core/Config.php
		sed -i "s|define('BLUKRYPT_IP'.*|define('BLUKRYPT_IP', '$BLUKRYPT_IP');|" /var/www/portal/app/Core/Config.php

		sed -i "s|define('LDAP_ENABLED'.*| define('LDAP_ENABLED', $LDAP);|" /var/www/portal/app/Core/Config.php
		sed -i "s|define('AMAZON_CHECK'.*|define('AMAZON_CHECK', $AMICHECK );|" /var/www/portal/app/Core/Config.php
		sed -i "s|define('BASE_PARACLOUD_PATH'.*|define('BASE_PARACLOUD_PATH', '/parablu/');|" /var/www/portal/app/Core/Config.php
		sed -i "s|define('OVERVIEW_REPORT_PATH'.*|define('OVERVIEW_REPORT_PATH', '/parablu/bkpOverview/');|" /var/www/portal/app/Core/Config.php
		sed -i 's|/var/log/portal|/parablu/log/portal|' /var/www/portal/app/Core/Logger.php

		echo "Storage Type = " $STORAGE_TYPE
		if [ $STORAGE_TYPE -eq 2 ]; then
			sed -i "s|define('STORAGE_TYPE'.*| define('STORAGE_TYPE', 'AZURE');|" /var/www/portal/app/Core/Config.php
        	elif [ $STORAGE_TYPE -eq 4 ]; then
                sed -i "s|define('STORAGE_TYPE'.*| define('STORAGE_TYPE', 'GOOGLE_DRIVE');|" /var/www/portal/app/Core/Config.php
		
			elif [ $STORAGE_TYPE -eq 1 ]; then
                sed -i "s|define('STORAGE_TYPE'.*| define('STORAGE_TYPE', 'LOCAL');|" /var/www/portal/app/Core/Config.php		

			else 
				sed -i "s|define('STORAGE_TYPE'.*| define('STORAGE_TYPE', 'ONE_DRIVE');|" /var/www/portal/app/Core/Config.php
		fi
	fi	


	chmod 775 /var/www/portal/errorlog.html
	
	cp ../installables/index.html $UI_PATH/.
	chmod -R 777 $UI_PATH/$portat_ui/

	mkdir -p $CERT_FILEPATH
	chmod -R 777 $CERT_FILEPATH

#	mkdir -p $LOGROTATEROOTPATH/parablusys
#	mkdir -p $LOGROTATEROOTPATH/parablusys/bin

#	cp $DEFAULT_FILE_PATH/logrotate/rotate_portal.sh  $LOGROTATEROOTPATH/parablusys/bin/
#	cp $DEFAULT_FILE_PATH/logrotate/portal.logrotate $LOGROTATE_D_PATH/portal

#	chown -R root:root $LOGROTATEROOTPATH/parablusys/bin/*
#	chmod -R 777 $LOGROTATEROOTPATH/parablusys/bin/*

	cp ../installables/cert_file.sh $CERT_FILEPATH/
	# start service
	service apache2 start
}

function custom_portal_changes ()
{

	service apache2 stop
	while read -r line;
	do
        	case $line in
       			''|\/*|\**) continue ;;         # skip blank lines and lines starting with \**
   		esac
	        vals=`echo -e "$line\n"`;
		echo "$vals" | grep "define('"
	  	if [ $? -eq 0 ]; then
        	new_val=$(echo "$vals" | sed -e 's/,.*//')
        	sed -i "s|"$new_val".*|$vals |" $PATH_NEW
		fi
	done < $PATH_OLD

	service apache2 start
}

function patch_configure_portal_changes ()
{

	###configuring Portal Config.php file###

	PATH_NEW=/var/www/portal/app/Core/Config.php
	PATH_OLD=$BACKUP_OLD/$portat_ui/app/Core/Config.php
	custom_portal_changes
}
		
function release_portal ()
{
	deploy_portal
        configure_portal_changes

    	if [ "$PATCH_INSTALL" == "true" ] && [ -e $FILE_PATH/$portal_zip ] && [ "$EXCLUDE_PORTAL" != "true" ]; then
            patch_configure_portal_changes
    	fi
}

function rollback_portal ()
{
	rm -rf /var/www/portal
	rm -rf $LOG_PATH/portal
	rm -rf $ARCHIVE_PATH/portal

	rm -rf $LOGROTATEROOTPATH/parablusys
        rm -rf $LOGROTATEROOTPATH/parablusys/bin
}
