#!/bin/bash

# Functions
setVariables () {

	# Username to access the mongo server e.g. dbuser. Unnecessary if authentication is off
	DBUSERNAME="neil"

	# Password to access the mongo server e.g. password. Unnecessary if authentication is off
	DBPASSWORD="parablu"

	# Database for authentication to the mongo server e.g. admin. Unnecessary if authentication is off
	DBAUTHDB="admin"

	# Host name (or IP address) of mongo server e.g localhost
	DBHOST="$1" 

	# Port that mongo is listening on
	DBPORT="27017"

	# Backup directory location e.g /backups
	BACKUPDIR="/parablu/backup/mongodb/"

	#Archive Directory
        ARCHIVEDIR="/parablu/archive/mongodb_backup"

	# Allow DBUSERNAME without DBAUTHDB
	REQUIREDBAUTHDB="no"

	# OPT string for use with mongodump
	OPT=""                                            

	# Use oplog for point-in-time snapshotting.
	OPLOG="no"

	# Do we need to use a username/password?
	if [ "$DBUSERNAME" ]; then
    		OPT="$OPT --username=$DBUSERNAME --password=$DBPASSWORD"
    		if [ "$REQUIREDBAUTHDB" = "yes" ]; then
        		OPT="$OPT --authenticationDatabase=$DBAUTHDB"
    		fi
	fi

	# Do we use oplog for point-in-time snapshotting?
	if [ "$OPLOG" = "yes" ]; then
    		OPT="$OPT --oplog"
	fi
}

# Database dump function
dbdump () {
	setVariables "localhost"
	echo
	echo Backup of Database Server - on $DBHOST 
	echo ======================================================================

	echo Backup Start `date`
	echo ======================================================================

	mkdir -p $BACKUPDIR
	mkdir -p $ARCHIVEDIR
	FOLDER=$BACKUPDIR/`date '+%Y%m%d'`
	rm -rf $FOLDER
    	mongodump --host=$DBHOST:$DBPORT --out=$FOLDER $OPT 
    	if [ ! -e "$FOLDER" ] ; then 
		echo "MongoDump Failed" 
		return 0
	fi
	echo ----------------------------------------------------------------------
	echo Backup End Time `date`
	echo ======================================================================
    	echo "Mongodump successfully completed in : $BACKUPDIR"
    	cd $BACKUPDIR
        echo "Archiving old Backups...."
        for i in `find . -maxdepth 1 -type d -mtime +1`; do
                echo -e "Archiving Backup Folder $i";
                mv $i $ARCHIVEDIR
                tar -cf $ARCHIVEDIR/$i.tar -C $ARCHIVEDIR $i;
                rm -rf $ARCHIVEDIR/$i
        done
        cd $ARCHIVEDIR
        ls -t | find . -mtime +3 | xargs -d '\n' rm
    	return 1
}

dbdump 

exit $STATUS
