#!/bin/bash

PARABLU_CONFIG_SCRIPT_PATH=../../config/parablu_config.sh
PARABLU_COMPONENT_SCRIPT_PATH=../../config/parablu_component_config.sh
PARABLU_HEALTH_CHECK_PARACLOUD=./paracloud_health_check.sh
PARABLU_HEALTH_CHECK_BLUKRYPT=./blukrypt_health_check.sh
PARABLU_HEALTH_CHECK_MONGO=./mongo_health_check.sh
PARABLU_WATCHDOG_CONFIG=./watchdog_config.sh

source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_HEALTH_CHECK_PARACLOUD
source $PARABLU_HEALTH_CHECK_BLUKRYPT
source $PARABLU_HEALTH_CHECK_MONGO
source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_WATCHDOG_CONFIG

export PATH=$PATH:/sbin




function zip_all_logs ()
{

        zip -jr log.zip /parablu/log/portal/portal_`date +%F`.log
        zip -jr log.zip /parablu/log/tomcat-pcb1/ParacloudBuilder.log
        zip -jr log.zip /parablu/log/tomcat-pcb1/ParaMail.log
        zip -jr log.zip /parablu/log/tomcat-pcb1/Support.log
        zip -jr log.zip /parablu/log/tomcat-job1/ParacloudJob.log
        zip -jr log.zip /parablu/log/tomcat-job1/BlukryptJob.log
        zip -jr log.zip /parablu/log/tomcat-pcb1/BlukryptBuilder.log
        zip -jr log.zip /parablu/log/tomcat-pcb1/ParacloudSearch.log
        zip -jr log.zip watchdog.log
        zip -jr log.zip activemq.log
}

function send_watchdog_mail ()
{
	if [ -f $MERGED_LOG ]; then
	sleep 5

		if [ ! -f $COLLECTOR_BACKUPOVERVIEWREPORT ]
		then
			echo "`cat $MERGED_LOG`" | mail -s "Machine Statistics of [$CUSTOMER_NAME] at $DATE" $WATCHDOG_MAIL_ADDRESS -aFrom:$WATCHDOG_FROM_MAIL_ADDRESS
		else
			echo "`cat $MERGED_LOG`" | mail -s "Machine Statistics of [$CUSTOMER_NAME] at $DATE" $WATCHDOG_MAIL_ADDRESS -aFrom:$WATCHDOG_FROM_MAIL_ADDRESS -A $COLLECTOR_BACKUPOVERVIEWREPORT
		fi
	fi
}


function send_single_machine_disk_alert_mail ()
{
	if [  -f $INITIAL_ALERT ]
        then
                echo "`cat $INITIAL_ALERT`" | mail -s "DISK ALERT in [$CUSTOMER_NAME] Machine $HOSTNAME at $DATE" $WATCHDOG_MAIL_ADDRESS -aFrom:$WATCHDOG_FROM_MAIL_ADDRESS
        fi

	if [  -f $FINAL_ALERT ]
        then
                echo "`cat $FINAL_ALERT`" | mail -s "DISK EXCEEDED in [$CUSTOMER_NAME] Machine $HOSTNAME at $DATE" $WATCHDOG_MAIL_ADDRESS -aFrom:$WATCHDOG_FROM_MAIL_ADDRESS
        fi

	if [  -f $RESTART_ALERT ]
        then
                echo "`cat $RESTART_ALERT`" | mail -s "SERVICE RESTARTED in [$CUSTOMER_NAME] Machine $HOSTNAME at $DATE" $WATCHDOG_MAIL_ADDRESS -aFrom:$WATCHDOG_FROM_MAIL_ADDRESS

        fi

	if [  -f $AFTER_FINAL_ALERT ]
        then
                echo "`cat $AFTER_FINAL_ALERT`" | mail -s "SERVICE STOPPED in [$CUSTOMER_NAME] Machine $HOSTNAME at $DATE" $WATCHDOG_MAIL_ADDRESS -aFrom:$WATCHDOG_FROM_MAIL_ADDRESS
        fi

	rm -rf *tmp
}

function send_multi_machine_disk_alert_mail ()
{


			if [  -f ./consolidate/$INITIAL_ALERT ]
		        then
        		        echo "`cat ./consolidate/$INITIAL_ALERT`" | mail -s "`cat ./consolidate/$INITIAL_ALERT_SUBJECT`" $WATCHDOG_MAIL_ADDRESS -aFrom:$WATCHDOG_FROM_MAIL_ADDRESS
		        fi

       			 if [  -f ./consolidate/$FINAL_ALERT ]
		        then
                		echo "`cat ./consolidate/$FINAL_ALERT`" | mail -s "`cat ./consolidate/$FINAL_ALERT_SUBJECT`" $WATCHDOG_MAIL_ADDRESS -aFrom:$WATCHDOG_FROM_MAIL_ADDRESS
		        fi

		        if [  -f ./consolidate/$RESTART_ALERT ]
		        then
                		echo "`cat ./consolidate/$RESTART_ALERT`" | mail -s "`cat ./consolidate/$RESTART_ALERT_SUBJECT`" $WATCHDOG_MAIL_ADDRESS -aFrom:$WATCHDOG_FROM_MAIL_ADDRESS

		        fi

		        if [  -f ./consolidate/$AFTER_FINAL_ALERT ]
		        then
	                echo "`cat ./consolidate/$AFTER_FINAL_ALERT`" | mail -s "`cat ./consolidate/$AFTER_FINAL_ALERT_SUBJECT`" $WATCHDOG_MAIL_ADDRESS -aFrom:$WATCHDOG_FROM_MAIL_ADDRESS
        		fi
		

}

function initiate_watchdog ()
{
	sleep 2
	send_watchdog_mail
	sleep 2
	send_single_machine_disk_alert_mail
}

function release_mail_service ()
{
	if [ "$SERVER_TYPE" != "0" ]
	then
		send_watchdog_mail
		sleep 2s
		send_multi_machine_disk_alert_mail
	else
		send_watchdog_mail
	        sleep 2
	        send_single_machine_disk_alert_mail
	fi
}

release_mail_service
