#!/bin/bash
PARABLU_COMPONENT_SCRIPT_PATH=../../config/parablu_component_config.sh
PARABLU_CONFIG_SCRIPT_PATH=../../config/parablu_config.sh
PARABLU_WATCHDOG_CONFIG=./watchdog_config.sh

source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_WATCHDOG_CONFIG

export PATH=$PATH:/sbin


function ad_connectivity_check ()
{
call_ad=`curl -o /dev/null --silent --get --write-out '%{http_code}\n'  http://$BLUVAULT_IP/paracloud/versions/2.3/clouds/$CLOUD_NAME/checkAdConnection`

                        echo "$call_ad" | grep 200
                        if [ $? -eq 0 ]; then
                                echo "AD CONNECTIVITY STATUS:" >> ./consolidate/merged.log
                                echo "AD is Connected" >> ./consolidate/merged.log
                                echo "" >> ./consolidate/merged.log
        echo "********************************************************************************************************************" >>./consolidate/merged.log
                        fi

                        echo "$call_ad" | grep 404
                        if [ $? -eq 0 ]; then
                                echo "AD CONNECTIVITY STATUS:" >> ./consolidate/merged.log
                                echo "Unable to connect AD" >> ./consolidate/merged.log
                                echo "" >> ./consolidate/merged.log
        echo "********************************************************************************************************************" >>./consolidate/merged.log
                        fi
}


function secondary_mongo_check ()
{
	echo "SECONDARY MONGO($DB2_IP) STATUS:" >> ./consolidate/merged.log
	ssh -p $SSH_PORT $SSH_USERNAME@$DB2_IP "service mongod status" >> ./consolidate/merged.log
	echo "" >> ./consolidate/merged.log
        echo "********************************************************************************************************************" >>./consolidate/merged.log
}

function ping_statistics ()
{
	echo "MACHINE CONNECTIVITY STATUS:" >> ./consolidate/merged.log
	for ping_ip in ${OTHER_WATCHDOG_IP[@]}
                do

			nc -z $ping_ip $SSH_PORT 2> /dev/null
			if [ $? -eq 0 ]; then
				get_host=$(ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "hostname")
				echo "Machine $get_host is reachable" >> ./consolidate/merged.log
			else 	
				echo "Machine $ping_ip is not reachable" >> ./consolidate/merged.log
			fi

		done
		echo "" >> ./consolidate/merged.log
                echo "********************************************************************************************************************" >>./consolidate/merged.log


}

function single_machine_statistics_collector ()
{

	rm -rf ./consolidate/merged.log
	rm -rf ./consolidate/Backup_OverviewStatus*

	ad_connectivity_check
	if [ -f watchdog.log ];then
		cat watchdog.log >> ./consolidate/merged.log
	fi

	rm -rf watchdog.log
	curl -X GET http://$BLUVAULT_IP/paracloud/cloud/$CLOUD_NAME/overview/createExcel/
	sleep 5s

	if [ -f $BACKUPOVERVIEWREPORT ];then
		cp $BACKUPOVERVIEWREPORT ./consolidate
	fi

	#### CALL MAIL FUNCTION in watchdog_service.sh
	bash watchdog_service.sh

	rm -rf ./consolidate/merged.log
	rm -rf ./consolidate/Backup_OverviewStatus*
}

function multi_machine_statistics_collector ()
{


	rm -rf ./consolidate/merged.log
	rm -rf ./consolidate/Backup_OverviewStatus*
	if [ -f watchdog.log ];then
		ping_statistics
		if [ "$DB1_IP" != "$DB2_IP" ];then
			secondary_mongo_check
		fi
		ad_connectivity_check
                cat watchdog.log >> ./consolidate/merged.log
		echo "<<============================= END OF MACHINE STATISTICS =============================>>" >> ./consolidate/merged.log
        	echo "" >> ./consolidate/merged.log
	        echo "" >> ./consolidate/merged.log
        fi

	################################### Copying Log files from other machines ########
	
#	counter=1
	for remote_ip in ${OTHER_WATCHDOG_IP[@]}
		do

			scp -P $SSH_PORT $SSH_USERNAME@$remote_ip:$SCRIPT_PATH/watchdog.log ./consolidate/
			if [ $? -eq 0 ]; then

				cat ./consolidate/watchdog.log >> ./consolidate/merged.log
#				counter=$((counter+1))
				echo "<<============================= END OF MACHINE STATISTICS =============================>>" >> ./consolidate/merged.log
				echo "" >> ./consolidate/merged.log
				echo "" >> ./consolidate/merged.log
				rm -rf ./consolidate/watchdog.log
				ssh -p $SSH_PORT $SSH_USERNAME@$remote_ip "cd $SCRIPT_PATH && rm -rf watchdog.log"
				sleep 2s
			fi

		done
	####################################################################################
	rm -rf watchdog.log
	sleep 1s
	curl -X GET http://$BLUVAULT_IP/paracloud/cloud/$CLOUD_NAME/overview/createExcel/

	if [ "$SERVER_TYPE" == "3" ]
	then
		scp -P $SSH_PORT $SSH_USERNAME@$BLUVAULT_IP:$BACKUPOVERVIEWREPORT ./consolidate/

		bash watchdog_service.sh
  	     	sleep 2s
		sleep 2s
		rm -rf ./consolidate/merged.log
	        rm -rf ./consolidate/Backup_OverviewStatus*
	else
		######Used for certain clients#######
		scp $BACKUPOVERVIEWREPORT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate
		sleep 1s
		scp ./consolidate/merged.log $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate
		sleep 1s
		ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE "cd $SCRIPT_PATH && ./watchdog_service.sh"
		ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE "cd $SCRIPT_PATH/consolidate && rm -rf merged.log"
		rm -rf ./consolidate/merged.log
                rm -rf ./consolidate/Backup_OverviewStatus*

	fi

}


function multi_machine_disk_collector ()
{
if [ "$SERVER_TYPE" == "3" ]
then
	cp $INITIAL_ALERT ./consolidate/
	cp $INITIAL_ALERT_SUBJECT ./consolidate/
	cp $FINAL_ALERT ./consolidate/
	cp $FINAL_ALERT_SUBJECT ./consolidate/
	cp $RESTART_ALERT ./consolidate/
	cp $RESTART_ALERT_SUBJECT ./consolidate/
	cp $AFTER_FINAL_ALERT ./consolidate/
	cp $AFTER_FINAL_ALERT_SUBJECT ./consolidate/
	
	sleep 2s
	bash watchdog_service.sh
	sleep 2s
	rm -rf ./consolidate/*tmp
	rm -rf *tmp

else
	scp $INITIAL_ALERT_SUBJECT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/
	scp $INITIAL_ALERT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/

	scp $FINAL_ALERT_SUBJECT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/
	scp $FINAL_ALERT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/

	scp $RESTART_ALERT_SUBJECT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/
	scp $RESTART_ALERT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/

	scp $AFTER_FINAL_ALERT_SUBJECT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/
	scp $AFTER_FINAL_ALERT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/

	sleep 2s
	ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE "cd $SCRIPT_PATH && ./watchdog_service.sh"
	sleep 2s
	ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE  "cd $SCRIPT_PATH/consolidate/ && rm -rf *tmp"
	ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE  "cd $SCRIPT_PATH/ && rm -rf *tmp"
	rm -rf *tmp

fi

for other_ip in ${OTHER_WATCHDOG_IP[@]}
                do
                       
			##########################################################################################################
			scp -P $SSH_PORT $SSH_USERNAME@$other_ip:$SCRIPT_PATH/$INITIAL_ALERT ./consolidate/
                        scp -P $SSH_PORT $SSH_USERNAME@$other_ip:$SCRIPT_PATH/$INITIAL_ALERT_SUBJECT ./consolidate/

			if [ "$SERVER_TYPE" == "3" ]
			then 

                       		 if [  -f ./consolidate/$INITIAL_ALERT ]
                       		 then
                                	echo "RUN MAIL SCRIPT"
					bash watchdog_service.sh
					sleep 2s
       					rm -rf ./consolidate/*tmp
					ssh -p $SSH_PORT $SSH_USERNAME@$other_ip  "cd $SCRIPT_PATH/ && rm -rf *tmp"
                       		 fi
			else
				scp ./consolidate/$INITIAL_ALERT_SUBJECT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/
				scp ./consolidate/$INITIAL_ALERT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/
				sleep 2s
				ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE test  -f "$SCRIPT_PATH/consolidate/$INITIAL_ALERT_SUBJECT"
			
				if [ $? -eq 0 ]; then
 					ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE "cd $SCRIPT_PATH && ./watchdog_service.sh"
					sleep 2s
					ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE  "cd $SCRIPT_PATH/consolidate/ && rm -rf *tmp"
					ssh -p $SSH_PORT $SSH_USERNAME@$other_ip  "cd $SCRIPT_PATH/ && rm -rf *tmp"
					rm -rf ./consolidate/*tmp
				else
        				echo "file missing"
				fi

			fi
			##########################################################################################################
			scp -P $SSH_PORT $SSH_USERNAME@$other_ip:$SCRIPT_PATH/$FINAL_ALERT ./consolidate/
                        scp -P $SSH_PORT $SSH_USERNAME@$other_ip:$SCRIPT_PATH/$FINAL_ALERT_SUBJECT ./consolidate/

                        if [ "$SERVER_TYPE" == "3" ]
                        then

                                 if [  -f ./consolidate/$FINAL_ALERT ]
                                 then
                                        echo "RUN MAIL SCRIPT"
					bash watchdog_service.sh
					sleep 2s
				        rm -rf ./consolidate/*tmp
					ssh -p $SSH_PORT $SSH_USERNAME@$other_ip  "cd $SCRIPT_PATH/ && rm -rf *tmp"
                                 fi
                        else
                                scp ./consolidate/$FINAL_ALERT_SUBJECT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/
                                scp ./consolidate/$FINAL_ALERT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/
                                sleep 2s
                                ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE test  -f "$SCRIPT_PATH/consolidate/$FINAL_ALERT_SUBJECT"

                                if [ $? -eq 0 ]; then
                                        ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE "cd $SCRIPT_PATH && ./watchdog_service.sh"
					sleep 2s
					ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE "cd $SCRIPT_PATH/consolidate/ && rm -rf *tmp"
					ssh -p $SSH_PORT $SSH_USERNAME@$other_ip  "cd $SCRIPT_PATH/ && rm -rf *tmp"
					rm -rf ./consolidate/*tmp
                                else
                                        echo "file missing"
                                fi

                        fi


			##########################################################################################################
                        scp -P $SSH_PORT $SSH_USERNAME@$other_ip:$SCRIPT_PATH/$RESTART_ALERT ./consolidate/
                        scp -P $SSH_PORT $SSH_USERNAME@$other_ip:$SCRIPT_PATH/$RESTART_ALERT_SUBJECT ./consolidate/

                        if [ "$SERVER_TYPE" == "3" ]
                        then

                                 if [  -f ./consolidate/$RESTART_ALERT ]
                                 then
                                        echo "RUN MAIL SCRIPT"
					bash watchdog_service.sh
					sleep 2s
				        rm -rf ./consolidate/*tmp
					ssh -p $SSH_PORT $SSH_USERNAME@$other_ip  "cd $SCRIPT_PATH/ && rm -rf *tmp"
                                 fi
                        else
                                scp ./consolidate/$RESTART_ALERT_SUBJECT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/
                                scp ./consolidate/$RESTART_ALERT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/
                                sleep 2s
                                ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE test  -f "$SCRIPT_PATH/consolidate/$RESTART_ALERT_SUBJECT"

                                if [ $? -eq 0 ]; then
                                        ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE "cd $SCRIPT_PATH && ./watchdog_service.sh"
					sleep 2s
					ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE "cd $SCRIPT_PATH/consolidate/ && rm -rf *tmp"
					ssh -p $SSH_PORT $SSH_USERNAME@$other_ip  "cd $SCRIPT_PATH/ && rm -rf *tmp"
					rm -rf ./consolidate/*tmp
                                else
                                        echo "file missing"
                                fi

                        fi

			#########################################################################################################
                        scp -P $SSH_PORT $SSH_USERNAME@$other_ip:$SCRIPT_PATH/$AFTER_FINAL_ALERT ./consolidate/
                        scp -P $SSH_PORT $SSH_USERNAME@$other_ip:$SCRIPT_PATH/$AFTER_FINAL_ALERT_SUBJECT ./consolidate/

                        if [ "$SERVER_TYPE" == "3" ]
                        then

                                 if [  -f ./consolidate/$AFTER_FINAL_ALERT ]
                                 then
                                        echo "RUN MAIL SCRIPT"
					bash watchdog_service.sh
					sleep 2s
				        rm -rf ./consolidate/*tmp
					ssh -p $SSH_PORT $SSH_USERNAME@$other_ip  "cd $SCRIPT_PATH/ && rm -rf *tmp"
                                 fi
                        else
                                scp ./consolidate/$AFTER_FINAL_ALERT_SUBJECT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/
                                scp ./consolidate/$AFTER_FINAL_ALERT $SSH_USERNAME@$MAIL_MACHINE:$SCRIPT_PATH/consolidate/
                                sleep 2s
                                ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE test  -f "$SCRIPT_PATH/consolidate/$AFTER_FINAL_ALERT_SUBJECT"

                                if [ $? -eq 0 ]; then
                                        ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE "cd $SCRIPT_PATH && ./watchdog_service.sh"
					sleep 2s
					ssh -p $SSH_PORT $SSH_USERNAME@$MAIL_MACHINE "cd $SCRIPT_PATH/consolidate/ && rm -rf *tmp"
					ssh -p $SSH_PORT $SSH_USERNAME@$other_ip  "cd $SCRIPT_PATH/ && rm -rf *tmp"
					rm -rf ./consolidate/*tmp
                                else
                                        echo "file missing"
                                fi

                        fi
			######################################################################################################


		done
}

function release_statistics_collector ()
{

if [ "$SERVER_TYPE" == "0" ]
then 
	single_machine_statistics_collector
else
	multi_machine_statistics_collector
	multi_machine_disk_collector
fi

}

release_statistics_collector
