#!/bin/bash
#                                                                                       #
# SCRIPT: activemq_service.sh		                                                #
# DATE:   20-Jan-2017                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems								#
# PURPOSE: Contains all the utility functions for Active MQ Installation                #
# PLATFORM: Ubuntu                                                                      #
PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh
source $PARABLU_COMPONENT_SCRIPT_PATH

ACTIVEMQ_INSTALL_PATH=/var/lib/activemq

# Configure all the prerequisite components
function prerequisite_activemq ()
{
	if [ ! -e "$ACTIVEMQ_INSTALL_PATH" ]
	then
		useradd activemq
		apt-get -y install sysv-rc-conf
	fi
}

# install activemq from internet
function install_activemq ()
{
	if [ ! -e "$ACTIVEMQ_INSTALL_PATH" ]
	then
		mkdir -p $LOG_PATH/activemq
		chown activemq:activemq $LOG_PATH/activemq
		chmod 0755 $LOG_PATH/activemq
		mkdir -p $ARCHIVE_PATH/activemq
                chown activemq:activemq $ARCHIVE_PATH/activemq
                chmod 0755 $ARCHIVE_PATH/activemq
		mkdir -p $DATA_PATH/activemq
		chown activemq:activemq $DATA_PATH/activemq
		chmod 0755 $DATA_PATH/activemq

		mkdir -p $LOGROTATEROOTPATH/parablusys
		mkdir -p $LOGROTATEROOTPATH/parablusys/bin

		cp $DEFAULT_FILE_PATH/logrotate/rotate_activemq.sh  $LOGROTATEROOTPATH/parablusys/bin/
		cp $DEFAULT_FILE_PATH/logrotate/activemq.logrotate $LOGROTATE_D_PATH/activemq

		chown -R root:root $LOGROTATEROOTPATH/parablusys/bin/*
		chmod -R 777 $LOGROTATEROOTPATH/parablusys/bin/*
		mkdir -p $ACTIVEMQ_INSTALL_PATH
		chown activemq:activemq $ACTIVEMQ_INSTALL_PATH
		chmod 0755 $ACTIVEMQ_INSTALL_PATH
		cp ../installables/apache-activemq-5.11.1-bin.tar.gz $ACTIVEMQ_INSTALL_PATH/apache-activemq-5.11.1-bin.tar.gz
		#wget -O $ACTIVEMQ_INSTALL_PATH/apache-activemq-5.11.1-bin.tar.gz https://archive.apache.org/dist/activemq/5.11.1/apache-activemq-5.11.1-bin.tar.gz 2> /dev/null

		gunzip $ACTIVEMQ_INSTALL_PATH/apache-activemq-5.11.1-bin.tar.gz

		#unzip the .tar / remove the .tar file
		tar -xf $ACTIVEMQ_INSTALL_PATH/apache-activemq-5.11.1-bin.tar -C $ACTIVEMQ_INSTALL_PATH/
		ln -fs $ACTIVEMQ_INSTALL_PATH/apache-activemq-5.11.1 $ACTIVEMQ_INSTALL_PATH/activemq
		chown activemq:activemq $ACTIVEMQ_INSTALL_PATH/activemq
		chown -R activemq:activemq $ACTIVEMQ_INSTALL_PATH/apache-activemq-5.11.1
		ln -fs $ACTIVEMQ_INSTALL_PATH/activemq/bin/linux-x86-64/activemq /etc/init.d/activemq
#		ufw allow 8161
		sed -i "s|#RUN_AS_USER=|RUN_AS_USER=activemq|" $ACTIVEMQ_INSTALL_PATH/activemq/bin/linux-x86-64/activemq
		sed -i "s|wrapper.logfile=%ACTIVEMQ_DATA%/wrapper.log|wrapper.logfile=$LOG_PATH/activemq/activemq.log|" $ACTIVEMQ_INSTALL_PATH/activemq/bin/linux-x86-64/wrapper.conf
        	sed -i 's|wrapper.java.additional.11=-Dactivemq.data=%ACTIVEMQ_DATA%|wrapper.java.additional.11=-Dactivemq.data=/parablu/data/activemq/|' $ACTIVEMQ_INSTALL_PATH/activemq/bin/linux-x86-64/wrapper.conf
                sed -i 's|log4j.appender.logfile.file=${activemq.base}/data/activemq.log|log4j.appender.logfile.file=/parablu/data/activemq/activemq.log|' $ACTIVEMQ_INSTALL_PATH/activemq/conf/log4j.properties
                sed -i 's|log4j.appender.audit.file=${activemq.base}/data/audit.log|log4j.appender.audit.file=/parablu/data/activemq/audit.log|' $ACTIVEMQ_INSTALL_PATH/activemq/conf/log4j.properties
		sudo update-rc.d activemq defaults 2>&1 >> install.log
                sudo update-rc.d activemq enable 2>&1 >> install.log
	fi
}

# check whether activemq is installed in the system
function verify_activemq ()
{
	if  [ ! -e "$ACTIVEMQ_INSTALL_PATH" ] 
	then 
		echo "ActiveMQ Installation failed. Try again after some time"
		exit 0
	else
		echo "ActiveMQ installed successfully"
	fi
}

# external function which deploys the activemq
function release_activemq ()
{
	prerequisite_activemq
	install_activemq
	verify_activemq
}

function uninstall_activemq ()
{
	userdel activemq
	apt-get -y purge sysv-rc-conf
	rm -rf $LOG_PATH/activemq
	rm -rf $DATA_PATH/activemq
	rm -rf $ARCHIVE_PATH/activemq
	rm -rf $ACTIVEMQ_INSTALL_PATH
	ufw disable 8161
	rm -rf $LOGROTATEROOTPATH/parablusys
        rm -rf $LOGROTATEROOTPATH/parablusys
        rm -rf $LOGROTATEROOTPATH/parablusys/bin
}

