/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.sample;

import com.backblaze.b2.client.B2ClientConfig;
import com.backblaze.b2.client.B2Sdk;
import com.backblaze.b2.client.B2StorageClient;
import com.backblaze.b2.client.contentSources.B2ContentSource;
import com.backblaze.b2.client.contentSources.B2FileContentSource;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.structures.B2Bucket;
import com.backblaze.b2.client.structures.B2FileVersion;
import com.backblaze.b2.client.structures.B2UploadFileRequest;
import com.backblaze.b2.client.structures.B2UploadListener;
import com.backblaze.b2.client.webApiHttpClient.B2StorageHttpClientBuilder;
import com.backblaze.b2.util.B2ExecutorUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.configuration.ConfigurationException;

public class MongoBackup {
    private static final String USER_AGENT = "UploadLargeFileFromUrl";
    static String clientFolderName = "";
    static String mongofile = "";
    static String backBlazeId = "";
    static String backBlazeKey = "";
    static String bucketName = "";

    public static void main(String[] args) throws B2Exception, ConfigurationException {
        if (args.length != 5) {
            System.out.println(" backBlazeId/ backBlazeKey/ bucketName/folderName/mongofile path cannot be empty in config file...Please configure and run again :)");
            System.exit(400);
        }
        backBlazeId = args[0];
        backBlazeKey = args[1];
        bucketName = args[2];
        clientFolderName = args[3];
        mongofile = args[4];
        System.out.println("...." + mongofile + "..." + backBlazeId + "..." + backBlazeKey + "...." + bucketName);
        File file = new File(mongofile);
        String fileNameInB2 = file.getName();
        long contentLen = file.length();
        PrintWriter writer = new PrintWriter(System.out, true);
        ExecutorService executor = Executors.newFixedThreadPool(10, B2ExecutorUtils.createThreadFactory((String)"sample-executor-%02d"));
        B2ClientConfig config = B2ClientConfig.builder((String)backBlazeId, (String)backBlazeKey, (String)USER_AGENT).build();
        try {
            Throwable throwable = null;
            Object var9_9 = null;
            try (B2StorageClient client = B2StorageHttpClientBuilder.builder((B2ClientConfig)config).build();){
                MongoBackup.mainGuts(writer, client, executor, bucketName, fileNameInB2, contentLen, file);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            B2ExecutorUtils.shutdownAndAwaitTermination((ExecutorService)executor, (int)10, (int)10);
        }
    }

    private static void mainGuts(PrintWriter writer, B2StorageClient client, ExecutorService executor, String bucketName, String fileNameInB2, long contentLen, File file) throws B2Exception {
        System.out.println("Running with " + B2Sdk.getName() + " version " + B2Sdk.getVersion());
        B2Bucket bucket = client.getBucketOrNullByName(bucketName);
        if (bucket == null) {
            System.out.println("bucket " + bucketName + " doesn't exist");
            System.exit(402);
        }
        for (B2Bucket scan : client.buckets()) {
            System.out.println(String.valueOf(scan.getBucketId()) + " " + scan.getBucketName());
        }
        B2UploadListener uploadListener = progress -> {
            double percent = 100.0 * ((double)progress.getBytesSoFar() / (double)progress.getLength());
            writer.println(String.format("  progress(%3.2f, %s)", percent, progress.toString()));
        };
        B2FileContentSource source = B2FileContentSource.build((File)file);
        B2UploadFileRequest request = B2UploadFileRequest.builder((String)bucket.getBucketId(), (String)(String.valueOf(clientFolderName) + "/" + file.getName()), (String)"application/octet", (B2ContentSource)source).setCustomField("color", "green").setListener(uploadListener).build();
        B2FileVersion file1 = file.length() > 0x500000L ? client.uploadLargeFile(request, executor) : client.uploadSmallFile(request);
        System.out.println(".....uploaded... successfully  " + file.getName());
        System.exit(0);
    }
}

