/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.domain.Location;

public class BackupBlazeUtil {
    private static boolean createContainerIfNotExists(String containerNameTemp, BlobStore blobStore, Location location) {
        boolean blobExists = false;
        try {
            boolean containerExists = blobStore.containerExists(containerNameTemp);
            if (containerExists) {
                blobExists = true;
            } else {
                boolean isContainerCreated = blobStore.createContainerInLocation(location, containerNameTemp);
                if (isContainerCreated) {
                    blobExists = true;
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            blobExists = false;
        }
        return blobExists;
    }

    public static void main(String[] args) throws InvalidKeyException, URISyntaxException {
        BlobStoreContext context = (BlobStoreContext)ContextBuilder.newBuilder((String)"b2").credentials("14cf87ec3a67", "00066055d8f4b83d31775758b2f06f06f9cfd04baf").buildView(BlobStoreContext.class);
        BlobStore blobStore = context.getBlobStore();
        System.out.println("... before get all blobs....");
        String container = "testmycloud";
        boolean containerExists = BackupBlazeUtil.createContainerIfNotExists(container, blobStore, null);
        System.out.println("...cont exists...." + containerExists);
        blobStore.createDirectory(container, "ik");
        File file = new File("/home/inba/Desktop/Output_sony original sheet.xlsx");
        String fileName = "ik/" + file.getName();
        Blob blob = blobStore.blobBuilder(fileName).payload(file).contentLength(file.length()).build();
        String putBlobStr = "";
        putBlobStr = file.length() > 0x500000L ? blobStore.putBlob(container, blob, PutOptions.Builder.multipart()) : blobStore.putBlob(container, blob);
        System.out.println("... end of uploading blobs...." + putBlobStr);
        ListContainerOptions options = new ListContainerOptions();
        PageSet set = blobStore.list();
        for (StorageMetadata next : set) {
            System.out.println("..... name ... " + next.getName());
        }
        context.close();
    }
}

