#!/bin/bash
#                                                                                       #
# SCRIPT: common_health_check.sh                                                             #
# DATE:   22-May-2017                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems                                                         #
# PURPOSE: Contains all the common functions required for health check                    #
# PLATFORM: Ubuntu 


PARABLU_COMPONENT_SCRIPT_PATH=../../config/parablu_component_config.sh
PARABLU_CONFIG_SCRIPT_PATH=../../config/parablu_config.sh
source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_CONFIG_SCRIPT_PATH

function check_service ()
{
	service=$1
	if (( $(ps -ef | grep -v grep | grep $service | wc -l) > 0 ))
	then
		echo "$service is running!!!"
		procesStatus=Success
	else
		echo "$service is not running..Starting Service $service..!!"
		n=0
        	until [ $n -ge 3 ]
        	do
	   		service $service start 2>&1 >> /dev/null
	    		if (( $(ps -ef | grep -v grep | grep $service | wc -l) > 0 ))
 	    		then 
				echo "$service Started Succesfully"
				procesStatus=Success
				break
	    		else 
				echo "$service Failed to Start"
				procesStatus=Fail
	    		fi
			n=$[$n+1]
      			sleep 2
   		done
	fi

	processInfo=$(ps -aux | grep $service | head -1)
	processId=$(echo $processInfo | awk '{print $2}')
	processCpuPercentage=$(echo $processInfo | awk '{print $3}')
	processMemPercentage=$(echo $processInfo | awk '{print $4}')

	if [ $procesStatus == Fail ]; then
        processId=''
        processCpuPercentage=''
        processMemPercentage=''

	fi
	
	echo -e "$service\t | $procesStatus\t\t | $processId\t | $processCpuPercentage\t\t\t\t | $processMemPercentage\t">>watchdog.log
	echo

	
}

function create_process_json
{
	echo "{
                                \"processName\" : \"$service\",
                                \"processId\" : \"$processId\",   
                                \"processStatus\" : \"$procesStatus\",
                                \"processCPUPercentage\": \"$processCpuPercentage\",
                                \"processMemPercentage\" : \"$processMemPercentage\"   
                          }" 
}

function tomcat_job_check ()
{
	check_service 'tomcat-job1'
	tomcatJobJsonObject=$(create_process_json)
}

function tomcat_pcb_check ()
{
	check_service 'tomcat-pcb1'
	tomcatPcbJsonObject=$(create_process_json)
}

function memcache_check ()
{
	check_service 'memcached'
	memcacheJsonObject=$(create_process_json)
}

function apache_check ()
{
	check_service 'apache2       '
	apacheJsonObject=$(create_process_json)
}

function activemq_check ()
{
        check_service 'activemq'
	activemqJsonObject=$(create_process_json)
#	curl -u "admin:admin" http://$BLUKRYPT_IP:8161/admin/xml/queues.jsp > activemq.log
}

function mongo_check ()
{
	check_service 'mongod     '
	mongoJsonObject=$(create_process_json)
}

function space_check ()
{

	ttlAvailInSlash=$(df -m / | tail -1 | awk '{print $4}')
        echo "AVAILABLE MEMORY in -/:    $ttlAvailInSlash MB "
        ttlAvailInMnt=$(df -m $ROOT_PATH | tail -1 | awk '{print $4}')
        echo "AVAILABLE MEMORY in -$ROOT_PATH: $ttlAvailInMnt MB"
}

function ram_check ()
{
	ttlAvailInRam=$(free -m | awk '{print $2}' | head -2 | sed -n 2p)
        echo "TOTAL MEMORY in RAM:   $ttlAvailInRam MB"
}

function physical_memory_details ()
{
	physicalMemoryInfo=$(df -h $mountMemory | tail -1)
	fileSystems=$(echo $physicalMemoryInfo | awk '{print $1}')
        physicalUsedMemory=$(echo $physicalMemoryInfo | awk '{print $3}')
        physicalAvailableMemory=$(echo $physicalMemoryInfo | awk '{print $4}')
        physicalUsedPercentage=$(echo $physicalMemoryInfo | awk '{print $5}')
}

function create_memory_json ()
{
	echo "{
                                \"fileSystem\" : \"$fileSystems\",
                                \"usedMemory\" : \"$physicalUsedMemory\",
                                \"availableMemory\" : \"$physicalAvailableMemory\",
                                \" usedPercentage\" : \"$physicalUsedPercentage\",
                                \"mountPoint\" : \"$mountMemory\"
                              }"
}

function memory_root ()
{
	mountMemory="/        "
	physical_memory_details
	echo $(create_memory_json)
	echo -e "$mountMemory\t | $physicalAvailableMemory\t\t\t | $physicalUsedMemory\t\t | $physicalUsedPercentage\t" >>watchdog.log

}

function memory_parablu ()
{
	mountMemory="/parablu"
	physical_memory_details
	df -h /parablu | grep "/parablu"
	if [ $? -eq 0 ]; then
        	echo $(create_memory_json)
		echo -e "$mountMemory\t | $physicalAvailableMemory\t\t\t | $physicalUsedMemory\t\t | $physicalUsedPercentage\t" >>watchdog.log
	fi
}

function memory_mdatabase ()
{
        mountMemory="/mdatabase"
        physical_memory_details
        df -h /mdatabase | grep "/mdatabase"
        if [ $? -eq 0 ]; then
                echo $(create_memory_json)
                echo -e "$mountMemory\t | $physicalAvailableMemory\t\t\t | $physicalUsedMemory\t\t | $physicalUsedPercentage\t" >>watchdog.log
        fi
}
function ram_details ()
{
	ramMemoryInfo=$(free -h | grep $memoryTyp | head -2)
	ramTotalMemory=$(echo $ramMemoryInfo | awk '{print $2}')
        ramUsedMemory=$(echo $ramMemoryInfo | awk '{print $3}')
        ramFreeMemory=$(echo $ramMemoryInfo | awk '{print $4}')
        ramBuffer=$(echo $ramMemoryInfo | awk '{print $6}')
	ramCache=$(echo $ramMemoryInfo | awk '{print $7}')
}

function create_ram_json ()
{
	echo "{
                        \"memoryType\" : \"$memoryTyp\",
                        \"totalMemory\" : \"$ramTotalMemory\",
                        \"usedMemory\" : \"$ramUsedMemory\",
                        \"freeMemory\" : \"$ramFreeMemory\",
                        \"buffer\" : \"$ramBuffer\",
                        \"cache\" : \"$ramCache\"
                    }"
}

function ram_mem ()
{
	memoryTyp="Mem"
        ram_details
        echo $(create_ram_json)
	echo -e "$memoryTyp\t\t | $ramTotalMemory\t\t | $ramUsedMemory\t\t | $ramFreeMemory\t\t | $ramBuffer\t\t | $ramCache\t" >>watchdog.log
}

function ram_swap ()
{
	memoryTyp="Swap"
        ram_details
        echo $(create_ram_json)
	echo -e "$memoryTyp\t\t | $ramTotalMemory\t\t | $ramUsedMemory\t\t | $ramFreeMemory\t\t | $ramBuffer\t\t | $ramCache\t" >>watchdog.log
}

