/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility.mongo.config;

import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.parablu.utility.mongo.config.MultipleMongoProperties;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;

@Configuration
@EnableConfigurationProperties(value={MultipleMongoProperties.class})
public class MultipleMongoConfig {
    @Autowired
    private MultipleMongoProperties mongoProperties;

    @Primary
    @Bean(name={"parabluTemplate"})
    public MongoTemplate primaryMongoTemplate() throws Exception {
        return new MongoTemplate(this.primaryFactory(this.mongoProperties.getParablu()));
    }

    @Bean(name={"parablu001MongoTemplate"})
    public MongoTemplate secondaryMongoTemplate() throws Exception {
        return new MongoTemplate(this.secondaryFactory(this.mongoProperties.getParablu001()));
    }

    @Bean
    @Primary
    public MongoDbFactory primaryFactory(MongoProperties mongo) throws Exception {
        ArrayList<ServerAddress> seeds = new ArrayList<ServerAddress>();
        seeds.add(new ServerAddress(mongo.getHost(), mongo.getPort().intValue()));
        MongoCredential credential = MongoCredential.createScramSha1Credential((String)mongo.getUsername(), (String)mongo.getAuthenticationDatabase(), (char[])mongo.getPassword());
        return new SimpleMongoDbFactory(new MongoClient(seeds, Arrays.asList(credential)), mongo.getDatabase());
    }

    @Bean
    public MongoDbFactory secondaryFactory(MongoProperties mongo) throws Exception {
        ArrayList<ServerAddress> seeds = new ArrayList<ServerAddress>();
        seeds.add(new ServerAddress(mongo.getHost(), mongo.getPort().intValue()));
        MongoCredential credential = MongoCredential.createScramSha1Credential((String)mongo.getUsername(), (String)mongo.getAuthenticationDatabase(), (char[])mongo.getPassword());
        return new SimpleMongoDbFactory(new MongoClient(seeds, Arrays.asList(credential)), mongo.getDatabase());
    }
}

