#!/bin/bash
# DEVELOPER: Vaibhav K

PARABLU_CONFIG_SCRIPT_PATH=../../config/parablu_config.sh
PARABLU_COMPONENT_SCRIPT_PATH=../../config/parablu_component_config.sh
PARABLU_HEALTH_CHECK_PARACLOUD=./paracloud_health_check.sh
PARABLU_HEALTH_CHECK_BLUKRYPT=./blukrypt_health_check.sh
PARABLU_HEALTH_CHECK_MONGO=./mongo_health_check.sh
PARABLU_WATCHDOG_CONFIG=./watchdog_config.sh
PARABLU_WATCHDOG_FUNCTIONS=./watchdog_common_functions.sh

source $PARABLU_WATCHDOG_FUNCTIONS
source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_HEALTH_CHECK_PARACLOUD
source $PARABLU_HEALTH_CHECK_BLUKRYPT
source $PARABLU_HEALTH_CHECK_MONGO
source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_WATCHDOG_CONFIG
#source $PARABLU_WATCHDOG_FUNCTIONS


export PATH=$PATH:/sbin

function collect_mail_ids ()
{

        for mail_id in ${WATCHDOG_MAIL_ADDRESS[@]}
                do
                        MAILARRAY+=({\"email\":\"$mail_id\"},)
        done


        tempids=$(echo -e "${MAILARRAY[*]}")
        get_mail_id=$(echo $tempids | sed -e 's/.$//')

}




function zip_all_logs ()
{

        zip -jr log.zip /parablu/log/portal/portal_`date +%F`.log
        zip -jr log.zip /parablu/log/tomcat-pcb1/ParacloudBuilder.log
        zip -jr log.zip /parablu/log/tomcat-pcb1/ParaMail.log
        zip -jr log.zip /parablu/log/tomcat-pcb1/Support.log
        zip -jr log.zip /parablu/log/tomcat-job1/ParacloudJob.log
        zip -jr log.zip /parablu/log/tomcat-job1/BlukryptJob.log
        zip -jr log.zip /parablu/log/tomcat-pcb1/BlukryptBuilder.log
        zip -jr log.zip /parablu/log/tomcat-pcb1/ParacloudSearch.log
        zip -jr log.zip watchdog.log
        zip -jr log.zip activemq.log
}

function send_watchdog_mail ()
{
	if [ -f $MERGED_LOG ]; then
	sleep 5

		if [ ! -f $COLLECTOR_BACKUPOVERVIEWREPORT ]
		then
			echo "CURL API CALL WITHOUT BKP REPORT"
			curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/${MERGED_LOG}"'","subjectFilePath":"'"${SCRIPT_PATH}/${WATCHDOG_SUBJECT}"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/

		else
			echo "CURL API CALL WITH BKP REPORT"
			curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/${MERGED_LOG}"'","subjectFilePath":"'"${SCRIPT_PATH}/${WATCHDOG_SUBJECT}"'","recipents":['"${get_mail_id}"'], "attachmentFilePaths":"'"${SCRIPT_PATH}/${COLLECTOR_BACKUPOVERVIEWREPORT}"'"}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
		fi
	fi
}


function send_single_machine_disk_alert_mail ()
{
	if [  -f $INITIAL_ALERT ]
        then
		echo "CURL API CALL"
		curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/${INITIAL_ALERT}"'","subjectFilePath":"'"${SCRIPT_PATH}/${INITIAL_ALERT_SUBJECT}"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
        fi

	if [  -f $FINAL_ALERT ]
        then
		echo "CURL API CALL"
		curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/${FINAL_ALERT}"'","subjectFilePath":"'"${SCRIPT_PATH}/${FINAL_ALERT_SUBJECT}"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/

        fi

	if [  -f $RESTART_ALERT ]
        then
		echo "CURL API CALL"
		curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/${RESTART_ALERT}"'","subjectFilePath":"'"${SCRIPT_PATH}/${RESTART_ALERT_SUBJECT}"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/

        fi

	if [  -f $AFTER_FINAL_ALERT ]
        then
		echo "CURL API CALL"
		curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/${AFTER_FINAL_ALERT}"'","subjectFilePath":"'"${SCRIPT_PATH}/${AFTER_FINAL_ALERT_SUBJECT}"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
        fi

	rm -rf *tmp
}

function send_multi_machine_disk_alert_mail ()
{


			if [  -f ./consolidate/$INITIAL_ALERT ]
                        then
                                echo "CURL API CALL"
                                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/consolidate/$INITIAL_ALERT"'","subjectFilePath":"'"${SCRIPT_PATH}/consolidate/$INITIAL_ALERT_SUBJECT"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
                        fi

                         if [  -f ./consolidate/$FINAL_ALERT ]
                        then
                                echo "CURL API CALL"
                                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/consolidate/$FINAL_ALERT"'","subjectFilePath":"'"${SCRIPT_PATH}/consolidate/$FINAL_ALERT_SUBJECT"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
                        fi

                        if [  -f ./consolidate/$RESTART_ALERT ]
                        then
                                echo "CURL API CALL"
                                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/consolidate/$RESTART_ALERT"'","subjectFilePath":"'"${SCRIPT_PATH}/consolidate/$RESTART_ALERT_SUBJECT"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/

                        fi

                        if [  -f ./consolidate/$AFTER_FINAL_ALERT ]
                        then
                        echo "CURL API CALL"
                        curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/consolidate/$AFTER_FINAL_ALERT"'","subjectFilePath":"'"${SCRIPT_PATH}/consolidate/$AFTER_FINAL_ALERT_SUBJECT"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
                        fi	

}

function send_single_machine_unmount_alert_mail ()
{
	if [  -f $DISK_UNMOUNT_ALERT ]
        then
                echo "CURL API CALL"
                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/${DISK_UNMOUNT_ALERT}"'","subjectFilePath":"'"${SCRIPT_PATH}/${DISK_UNMOUNT_ALERT_SUBJECT}"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
        fi
	sleep 20
	rm $DISK_UNMOUNT_ALERT
	rm $DISK_UNMOUNT_ALERT_SUBJECT
}


function send_multi_machine_unmount_alert_mail ()
{

	if [  -f ./consolidate/$DISK_UNMOUNT_ALERT ]
                        then
                                echo "CURL API CALL"
                                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/consolidate/$DISK_UNMOUNT_ALERT"'","subjectFilePath":"'"${SCRIPT_PATH}/consolidate/$DISK_UNMOUNT_ALERT_SUBJECT"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
        fi

}

function initiate_watchdog ()
{
	sleep 2
	send_watchdog_mail
	sleep 2
	send_single_machine_disk_alert_mail
}

function release_mail_service ()
{
	if [ "$SERVER_TYPE" != "0" ]
	then
#		collect_mail_ids
		get_supportmail
		get_paracloud_url
		send_watchdog_mail
		sleep 2s
		send_multi_machine_disk_alert_mail
		send_multi_machine_unmount_alert_mail
	else
#		collect_mail_ids
		get_supportmail
		get_paracloud_url
		send_watchdog_mail
	        sleep 2
	        send_single_machine_disk_alert_mail
		send_single_machine_unmount_alert_mail
	fi
}

release_mail_service
