#!/bin/bash
#                                                                                       #
# SCRIPT: mongo_health_check.sh                                                           #
# DATE:   27-Oct-2016                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems                                                         #
# DEVELOPER: Vaibhav K
# PURPOSE: Checks mongo health status                   #
# PLATFORM: Ubuntu

PARABLU_COMPONENT_SCRIPT_PATH=./common_health_check.sh
source $PARABLU_COMPONENT_SCRIPT_PATH


function mongo_component_check ()
{
	echo "CHECKING MONGO COMPONENTS......"
	if [ "$SERVER_TYPE" != "0" ]; then
        	echo "********************************************************************************************************************" >>watchdog.log
	        echo -e "PROCESS_NAME\t | PROCESS_STATUS\t | PID\t\t | PROCESS_CPU_PERCENTAGE\t | PROCESS_MEMORY_PERCENTAGE\t" >>watchdog.log
	fi
	mongo_check
	if [ "$SERVER_TYPE" != "0" ]; then
        	echo "********************************************************************************************************************" >>watchdog.log
	fi
}


function mongo_json_object ()
{
	hostname=`hostname`
	current_ip=$(ifconfig eth0 | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}')
            if grep -q unknown-245 /var/lib/dhcp/dhclient.eth0.leases; then
                current_ip=$(curl ipinfo.io/ip 2>/dev/null)
            fi
	date=`date`

	pmJsonObject="{
    	\"hostName\" : \"$hostname\",
    	\"ipAddress\" : \"$current_ip\",
    	\"updatedTime\" : \"$date\",
    	\"processes\" : [
			    $mongoJsonObject
		        ],
    	\"physicalMemory\": [
			      $jsonObjectMemRoot,$jsonObjectMemParablu,$jsonObjectMemMdatabase
		 	    ],
	\"memory\" : [
		     $jsonObjectRamMem,$jsonObjectRamSwap
	  	  ]
}"

#curl -i -X POST -H "Content-Type:application/json" -d "$pmJsonObject" http://localhost:1119/watchdog/components
}

function monitor_mongo ()
{
if [ "$SERVER_TYPE" != "3 1" ]; then
        mongo_component_check
        if [ "$SERVER_TYPE" != "0" ]; then
                echo "********************************************************************************************************************" >>watchdog.log
                echo "">>watchdog.log
                echo "********************************************************************************************************************" >>watchdog.log
        fi

        if [ "$SERVER_TYPE" != "0" ]; then
                echo -e "DISK\t\t | AVAILABLE_MEMORY\t | USED_MEMORY\t | USED_PERCENTAGE\t" >>watchdog.log
                space_check
                ram_check
#                jsonObjectMemRoot=$(memory_root)
                jsonObjectMemParablu=$(memory_parablu)
#		jsonObjectMemMdatabase=$(memory_mdatabase)
                echo "********************************************************************************************************************" >>watchdog.log
                echo "">>watchdog.log
                echo "********************************************************************************************************************" >>watchdog.log
                echo -e "MEMORY_TYPE\t | TOTAL_MEMORY\t | USED_MEMORY\t | FREE_MEMORY\t | BUFFER\t | CACHE\t" >>watchdog.log
                jsonObjectRamMem=$(ram_mem)
                jsonObjectRamSwap=$(ram_swap)
                echo "********************************************************************************************************************" >>watchdog.log
#                mongo_json_object
        fi
fi
}

