#!/bin/bash
#Developed By: Vaibhav K
# Script: Pull All Logs

PARABLU_CONFIG_SCRIPT_PATH=../../config/parablu_config.sh
PARABLU_COMPONENT_CONFIG_SCRIPT_PATH=../../config/parablu_component_config.sh

source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_COMPONENT_CONFIG_SCRIPT_PATH

export PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:$PATH"
PULLLOGS_CHECK_FILE="get_logs"
dbport=$(grep port: /etc/mongod.conf)
MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')

function get_backblaze_creds ()
{
        echo 'use parablu001

db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_BKID=" +e.backblaze_id)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_APPKEY=" +e.application_key)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_BUCKET=" +e.backblaze_bucket)})' >mongobklpul_properties.js

        cp mongobklpul_properties.js mongobklpul_properties_install.js
        sudo mongo localhost:$DBPORT -u "neil" -p "parablu" --authenticationDatabase "admin" < mongobklpul_properties_install.js > mongobklpul_properties


        BACKBLAZE_ID_VAL=$(grep "P_BKID" mongobklpul_properties | sed -e 's/P_BKID=//')
        APPLICATION_KEY_VAL=$(grep "P_APPKEY" mongobklpul_properties | sed -e 's/P_APPKEY=//')
        BACKBLAZE_BUCKET_VAL=$(grep "P_BUCKET" mongobklpul_properties | sed -e 's/P_BUCKET=//')

        if [ "$BACKBLAZE_ID_VAL" == "undefined" ]; then

                BACKBLAZE_ID="43fee37666d9"

        elif [ ! -z "$BACKBLAZE_ID_VAL" ]; then

                BACKBLAZE_ID=$BACKBLAZE_ID_VAL

        else

                BACKBLAZE_ID="43fee37666d9"

        fi

        if [ "$APPLICATION_KEY_VAL" == "undefined" ]; then

		decrypt_key=$(java -jar EncryptAndDecypt.jar dec MDAwMGZmMmYxMjJjMTUzZmYzYzU2NGVlOGQxZDhmNjA0ZjAzYjQ0NDEy)
                decrypt_key_val=$(echo $decrypt_key | sed -e 's/Result=//')
                APPLICATION_KEY="$decrypt_key_val"

        elif [ ! -z "$APPLICATION_KEY_VAL" ]; then
                decrypt_key=$(java -jar EncryptAndDecypt.jar dec $APPLICATION_KEY_VAL)
                decrypt_key_val=$(echo $decrypt_key | sed -e 's/Result=//')

                APPLICATION_KEY=$decrypt_key_val

        else

                decrypt_key=$(java -jar EncryptAndDecypt.jar dec MDAwMGZmMmYxMjJjMTUzZmYzYzU2NGVlOGQxZDhmNjA0ZjAzYjQ0NDEy)
                decrypt_key_val=$(echo $decrypt_key | sed -e 's/Result=//')
                APPLICATION_KEY="$decrypt_key_val"

        fi


        if [ "$BACKBLAZE_BUCKET_VAL" == "undefined" ]; then

                BACKBLAZE_BUCKET="CUST-Mongodbbackups"

        elif [ ! -z "$BACKBLAZE_BUCKET_VAL" ]; then

                BACKBLAZE_BUCKET=$BACKBLAZE_BUCKET_VAL

        else

                BACKBLAZE_BUCKET="CUST-Mongodbbackups"

        fi



}

function get_cust_name ()
{

	CUSTOMER_NAME=$CLOUD_NAME

}

function get_ip_list ()
{

if [ "$SERVER_TYPE" == "3 1" ]; then

echo 'use parablu001
db.PRIVACY_GATEWAY.distinct("gatewayName");' >ipplist.js
else

echo 'use parablu001
db.PRIVACY_GATEWAY.distinct("gatewayName")

db.BLUVAULT.distinct("bluVaultName");' >ipplist.js

fi

        sudo mongo localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < ipplist.js >ipplist.log

        grep '"' ipplist.log | sed -e 's/\[//' | sed -e 's/\]//' | sed -e 's/"//g' | sed -e 's/,//g'  >sorted_ipplist.log
	sed -i "/Implicit/d" sorted_iplist.log
        final_iplist=`cat sorted_ipplist.log`
        OTHER_WATCHDOG_IP=$(echo "$final_iplist" | xargs -n1 | sort -u | xargs)

}

function getOtherServerLogs ()
{

get_ip_list
for ping_ip in ${OTHER_WATCHDOG_IP[@]}
        do
		ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "zip -r $ping_ip-allLog.zip /parablu/log/"
		sleep 2s
		scp -r -P $SSH_PORT $SSH_USERNAME@$ping_ip:$ping_ip-allLog.zip .
		sleep 2s
		ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "rm -rf $ping_ip-allLog.zip"
	done

}


###backblaze check

function check_getlogs_backblaze ()
{
	get_cust_name
	backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY
	backblaze-b2 ls $BACKBLAZE_BUCKET $CUSTOMER_NAME | grep -oh $PULLLOGS_CHECK_FILE
	if [ $? -eq 0 ]; then
		GET_FILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $CUSTOMER_NAME  | grep $PULLLOGS_CHECK_FILE | awk '{print $1}' | head -1`
		echo "FILE VERSION: $GET_FILE_VERSION"
		sleep 1s

		zip -r `hostname`-allLog.zip /parablu/log/
		if [ "$SERVER_TYPE" == "3" ]; then
			getOtherServerLogs
		fi
		
		sleep 1s
		zip -r allLogs.zip *.zip
		sleep 2s

		backblaze-b2 upload-file  $BACKBLAZE_BUCKET allLogs.zip $CUSTOMER_NAME/allLogs.zip

		backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_FILE_VERSION

		sleep 4s

		rm -rf *.zip

	fi

}
if [ "$KEY_BASED_SSH" == "true" ]; then
        ssh-agent
        eval $(ssh-agent)
        ssh-add $SSH_KEY_FILE
fi
get_backblaze_creds
check_getlogs_backblaze
if [ "$KEY_BASED_SSH" == "true" ]; then
        killall -9 ssh-agent
fi
