#!/bin/bash
#Developed By: Vaibhav K

PARABLU_CONFIG_SCRIPT_PATH=/parablu-scripts/Installable/config/parablu_config.sh
PARABLU_COMPONENT_CONFIG_SCRIPT_PATH=/parablu-scripts/Installable/config/parablu_component_config.sh

source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_COMPONENT_CONFIG_SCRIPT_PATH

defaultjarconfigfile=pull_config.txt
date_time=`date +%F_%T`
jarconfigfile=pull_config-$date_time.txt
cp $defaultjarconfigfile $jarconfigfile

source PullAgentRequest.txt

###### VALUES TO BE MODIFIED #########


if [ ! -z $deviceName ]; then

echo "variable $deviceName present"
sed -i "s|deviceName.*|deviceName="$deviceName"|" $jarconfigfile

fi

if [ ! -z $userName ]; then

        sed -i "s|userName.*|userName="$userName"|" $jarconfigfile

fi

if [ ! -z $pullHistoricalLogs ]; then

        sed -i "s|pullHistoricalLogs.*|pullHistoricalLogs="$pullHistoricalLogs"|" $jarconfigfile

fi

if [ ! -z $pullDataBase ]; then

        sed -i "s|pullDataBase.*|pullDataBase="$pullDataBase"|" $jarconfigfile

fi

if [ ! -z $pullSetUpLogs ]; then

        sed -i "s|pullSetUpLogs.*|pullSetUpLogs="$pullSetUpLogs"|" $jarconfigfile

fi

if [ ! -z $pullLogs ]; then

        sed -i "s|pullLogs.*|pullLogs="$pullLogs"|" $jarconfigfile

fi

#######################################




####### DEFAULT VALUES ################
OUTPUT_FILE="pullrequest.log"
MONGOIP="localhost"
ACTION="pull_request"
ZIPPATH="."

dbport=$(grep port: /etc/mongod.conf)
MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')

#############################################################################

### RUN BELOW JAR


#java -jar AgentLogsUtility.jar "$MONGOIP" "$MONGODB_PORT" "$DEVICE_NAME" "$USER_NAME" "$ACTION" "$ZIPPATH" >$OUTPUT_FILE
java -jar AgentLogsUtilityNew.jar $jarconfigfile >$OUTPUT_FILE
