/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility.parablu001.dashboard;

import com.parablu.utility.model.DashboardStatistics;
import com.parablu.utility.parablu.CloudService;
import com.parablu.utility.parablu001.dashboard.DashboardService;
import com.parablu.utility.parablu001.device.DeviceRepository;
import com.parablu.utility.parablu001.devicebackupoverview.DeviceBackupOverView;
import com.parablu.utility.parablu001.devicebackupoverview.DeviceBackupOverviewRepository;
import com.parablu.utility.parablu001.user.UserRepository;
import java.text.DecimalFormat;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DashboardServiceImpl
implements DashboardService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private DeviceRepository deviceRepository;
    @Autowired
    private CloudService cloudService;
    @Autowired
    private DeviceBackupOverviewRepository deviceBackupOverviewRepository;

    public DashboardStatistics getDashboatdStatistics() {
        List deviceBackupOverViews = this.deviceBackupOverviewRepository.findAll();
        return new DashboardStatistics((long)this.cloudService.getUserCount(), this.userRepository.getAllActiveUserCount(), this.deviceRepository.count(), this.deviceRepository.getAllActiveDeviceCount(), this.getTotalNoOfRestorePerUser(deviceBackupOverViews), this.getCompeletedBackups(deviceBackupOverViews), this.totalStoargeUtilized(deviceBackupOverViews), this.getTotalNoOfRestore(deviceBackupOverViews), this.getAvgStoargeUtilizedPerUser(deviceBackupOverViews), this.cloudService.getValidityPeriod().toString());
    }

    private String getAvgStoargeUtilizedPerUser(List<DeviceBackupOverView> deviceBackupOverViews) {
        return DashboardServiceImpl.formatFileSize((long)(deviceBackupOverViews.stream().mapToLong(DeviceBackupOverView::getStorageUtilized).sum() / this.userRepository.getAllActiveUserCount()));
    }

    private String totalStoargeUtilized(List<DeviceBackupOverView> deviceBackupOverViews) {
        return DashboardServiceImpl.formatFileSize((long)deviceBackupOverViews.stream().mapToLong(DeviceBackupOverView::getStorageUtilized).sum());
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    private long getTotalNoOfRestore(List<DeviceBackupOverView> deviceBackupOverViews) {
        return deviceBackupOverViews.stream().mapToLong(DeviceBackupOverView::getNoOfSuccessfulRestores).sum();
    }

    private double getTotalNoOfRestorePerUser(List<DeviceBackupOverView> deviceBackupOverViews) {
        double restoreCount = deviceBackupOverViews.stream().mapToLong(DeviceBackupOverView::getNoOfSuccessfulRestores).sum();
        double activeUsersCount = this.userRepository.getAllActiveUserCount();
        return restoreCount / activeUsersCount;
    }

    private long getCompeletedBackups(List<DeviceBackupOverView> deviceBackupOverViews) {
        return deviceBackupOverViews.stream().mapToLong(DeviceBackupOverView::getNoOfSuccessfulBackups).sum();
    }
}

