/*
 * Decompiled with CFR 0.152.
 */
package lite;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.operation.OrderBy;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.X509Certificate;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.bson.Document;

public class AgentLogsUtilityNew {
    public static void main(String[] args) throws IOException, ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String deviceName = config.getProperty("deviceName").toString();
        String userName = config.getProperty("userName").toString();
        String action = config.getProperty("action").toString();
        String path = config.getProperty("path").toString();
        boolean pullLogs = config.getBoolean("pullLogs");
        boolean pullHistoricalLogs = config.getBoolean("pullHistoricalLogs");
        boolean pullDataBase = config.getBoolean("pullDataBase");
        boolean pullSetUpLogs = config.getBoolean("pullSetUpLogs");
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoClientURI supportUri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/support");
        MongoClient supportClient = new MongoClient(supportUri);
        MongoDatabase supportDb = supportClient.getDatabase(supportUri.getDatabase());
        MongoCollection<Document> deviceCollection = db.getCollection("DEVICE");
        MongoCollection<Document> eventCollection = db.getCollection("EVENT_HUB");
        MongoCollection<Document> bluvaultCollection = db.getCollection("BLUVAULT_PROPERTIES");
        String reason = "";
        String statusCode = "";
        MongoCollection<Document> supportCollection = supportDb.getCollection("SUPPORT_LOGS");
        System.out.println("userName:" + userName + " deviceName:" + deviceName);
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("userName", userName));
        whereQuery.add(new BasicDBObject("deviceName", deviceName));
        andQuery.put("$and", whereQuery);
        if (action.equalsIgnoreCase("pull_request")) {
            System.out.println("Inside pull_request.......");
            FindIterable<Document> devices = deviceCollection.find(andQuery);
            if (devices == null) {
                System.out.println("No device found....");
                reason = "No device found";
                statusCode = "404";
                System.out.println("Status Code=" + statusCode);
                System.exit(2);
            }
            for (Document device : devices) {
                ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
                BasicDBObject andQuery1 = new BasicDBObject();
                whereQuery1.add(new BasicDBObject("actionToDeviceUUID", device.getString("deviceUUID")));
                whereQuery1.add(new BasicDBObject("action", "PULL_AGENTLOGS"));
                andQuery1.put("$and", whereQuery1);
                Document event = (Document)eventCollection.find(andQuery1).first();
                if (event != null) {
                    System.out.println("event is already exists.....");
                    reason = "event is already exists";
                    statusCode = "202";
                    System.out.println("Status Code=" + statusCode);
                    System.exit(3);
                    continue;
                }
                Document eve = new Document();
                eve.put("actionBy", (Object)"admin");
                eve.put("actionToUserName", (Object)userName);
                eve.put("actionToDeviceUUID", (Object)device.getString("deviceUUID"));
                eve.put("action", (Object)"PULL_AGENTLOGS");
                eve.put("actionStatus", (Object)"CREATED");
                eventCollection.insertOne(eve);
                System.out.println("create events.......");
                statusCode = "200";
                reason = "create events";
            }
        } else if (action.equalsIgnoreCase("get_logs")) {
            System.out.println("Inside get_logs.......");
            BasicDBObject andQuery1 = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
            whereQuery1.add(new BasicDBObject("userName", userName));
            whereQuery1.add(new BasicDBObject("deviceName", deviceName));
            andQuery1.put("$and", whereQuery);
            Document support = (Document)supportCollection.find(andQuery1).sort(new BasicDBObject("timeStamp", (Object)OrderBy.DESC.getIntRepresentation())).first();
            if (support != null) {
                String id = support.getObjectId("_id").toString();
                System.out.println("id:" + id);
                AgentLogsUtilityNew.createSSLFactory();
                Document bluvault = (Document)bluvaultCollection.find().first();
                if (bluvault != null) {
                    Map component = (Map)bluvault.get("componentsProperties");
                    if (component != null) {
                        String string = (String)component.get("paracloudUrl");
                        URL url = new URL(String.valueOf(string) + "/support/versions/2.2/clouds/aa/logs/download/" + id);
                        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                        conn.setDoOutput(true);
                        conn.setRequestMethod("GET");
                        int responseCode = conn.getResponseCode();
                        System.out.println("Url:" + url.toString());
                        if (responseCode == 200) {
                            InputStream inputStream = conn.getInputStream();
                            String saveFilePath = String.valueOf(path) + "/Agentlogs.zip";
                            FileOutputStream outputStream = new FileOutputStream(saveFilePath);
                            int bytesRead = -1;
                            byte[] buffer = new byte[4096];
                            while ((bytesRead = inputStream.read(buffer)) != -1) {
                                outputStream.write(buffer, 0, bytesRead);
                            }
                            outputStream.close();
                            inputStream.close();
                            System.out.println("success......");
                            reason = "success";
                            statusCode = "200";
                        }
                    } else {
                        System.out.println("logs not yet came....");
                        reason = "logs not yet came";
                        statusCode = "205";
                    }
                } else {
                    System.out.println("no paracloud url in bluvault properties.....");
                }
            } else {
                System.out.println("logs not yet came....");
                reason = "logs not yet came";
                statusCode = "205";
            }
        } else {
            System.out.println("Bad action........");
            reason = "Bad action";
            statusCode = "500";
        }
        System.out.println("reason=" + reason);
        System.out.println("Status Code=" + statusCode);
        System.exit(0);
    }

    private static void createSSLFactory() {
        final java.security.cert.X509Certificate[] xs = null;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                return xs;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (sc != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = (hostname, session) -> true;
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
    }

    public static enum EVENTHUB_ACTION {
        PULL_AGENTLOGS,
        PULL_HISTORICAL_LOGS,
        DATABASES,
        SETUP_LOGS;

    }
}

