/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility.parablu001.devicebackupoverview;

import com.parablu.utility.model.DeviceBackupOverviewStatistics;
import com.parablu.utility.parablu001.device.DeviceRepository;
import com.parablu.utility.parablu001.devicebackupoverview.DeviceBackupOverView;
import com.parablu.utility.parablu001.devicebackupoverview.DeviceBackupOverviewRepository;
import com.parablu.utility.parablu001.devicebackupoverview.DeviceBackupOverviewService;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DeviceBackupOverviewServiceImpl
implements DeviceBackupOverviewService {
    @Autowired
    private DeviceBackupOverviewRepository deviceBackupOverviewRepository;
    @Autowired
    private DeviceRepository deviceRepository;

    public DeviceBackupOverviewStatistics getDeviceBackupOverviewStatistics() {
        List deviceBackupOverViews = this.deviceBackupOverviewRepository.findAll();
        Map lastAgentHeardDetails = this.getLastAgentHeardDetails(deviceBackupOverViews);
        Map lastSuccessfullBackupEndTimeDetails = this.getLastSuccessfullBackupEndTimeDetails(deviceBackupOverViews);
        Map FirstBackupCompletedTimeDetails = this.getFirstBackupCompletedTimeDetails(deviceBackupOverViews);
        Map lastAgentHeardDetailsInPercentage = this.getInPercentage(lastAgentHeardDetails);
        Map lastSuccessfullBackupEndTimeDetailsInPercentage = this.getInPercentage(lastSuccessfullBackupEndTimeDetails);
        Map FirstBackupCompletedTimeDetailsInPercentage = this.getInPercentage(FirstBackupCompletedTimeDetails);
        long totalNoOfRestore = this.getTotalNoOfRestore(deviceBackupOverViews);
        return new DeviceBackupOverviewStatistics(this.deviceBackupOverviewRepository.getAllFirstBackupCompletedCount(), this.getTotalSizeInPG(deviceBackupOverViews), lastSuccessfullBackupEndTimeDetails, lastAgentHeardDetails, FirstBackupCompletedTimeDetails, totalNoOfRestore, lastSuccessfullBackupEndTimeDetailsInPercentage, lastAgentHeardDetailsInPercentage, FirstBackupCompletedTimeDetailsInPercentage);
    }

    private Map<Integer, Float> getInPercentage(Map<Integer, Integer> deviceDetails) {
        HashMap<Integer, Float> results = new HashMap<Integer, Float>();
        long totaldevices = this.deviceRepository.getAllActiveDeviceCount();
        int[] i = new int[]{1, 3, 7, 15, 30, 3650};
        Float percentage = null;
        try {
            for (int j : i) {
                if (deviceDetails.get(j) != null) {
                    percentage = Float.valueOf(DeviceBackupOverviewServiceImpl.getPercentage((int)deviceDetails.get(j), (int)((int)totaldevices)));
                }
                results.put(j, percentage);
            }
        }
        catch (Exception e) {
            System.out.println("Execption while parsing");
        }
        return results;
    }

    public static float getPercentage(int n, int total) {
        float proportion = (float)n / (float)total;
        return proportion * 100.0f;
    }

    private String getTotalSizeInPG(List<DeviceBackupOverView> deviceBackupOverViews) {
        return DeviceBackupOverviewServiceImpl.formatFileSize((long)deviceBackupOverViews.stream().mapToLong(DeviceBackupOverView::getStorageUtilized).sum());
    }

    private long getTotalNoOfRestore(List<DeviceBackupOverView> deviceBackupOverViews) {
        return deviceBackupOverViews.stream().mapToLong(DeviceBackupOverView::getNoOfSuccessfulRestores).sum();
    }

    private Map<Integer, Integer> getLastSuccessfullBackupEndTimeDetails(List<DeviceBackupOverView> deviceBackupOverViews) {
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>();
        for (DeviceBackupOverView backupOverView : deviceBackupOverViews) {
            if (backupOverView.getLastSuccessfulBackupEndTime() == 0L || backupOverView.isDeviceBolcked() || backupOverView.isDeviceDeleted()) continue;
            Timestamp timestamp = new Timestamp(backupOverView.getLastSuccessfulBackupEndTime());
            Date date = new Date(timestamp.getTime());
            int daysDiff = this.getDaysDiffByDate(date);
            Integer deviceCount = (Integer)results.get(daysDiff);
            if (deviceCount == null) {
                deviceCount = 1;
            } else {
                Integer n = deviceCount;
                Integer n2 = deviceCount = Integer.valueOf(deviceCount + 1);
            }
            results.put(daysDiff, deviceCount);
        }
        return this.getActuallData(results);
    }

    private Map<Integer, Integer> getFirstBackupCompletedTimeDetails(List<DeviceBackupOverView> deviceBackupOverViews) {
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>();
        for (DeviceBackupOverView backupOverView : deviceBackupOverViews) {
            if (StringUtils.isEmpty((Object)backupOverView.getFirstBkpEndTime()) || backupOverView.isDeviceBolcked() || backupOverView.isDeviceDeleted()) continue;
            int daysDiff = this.getDaysDiffByString(backupOverView.getFirstBkpEndTime());
            Integer deviceCount = (Integer)results.get(daysDiff);
            if (deviceCount == null) {
                deviceCount = 1;
            } else {
                Integer n = deviceCount;
                Integer n2 = deviceCount = Integer.valueOf(deviceCount + 1);
            }
            results.put(daysDiff, deviceCount);
        }
        return this.getActuallData(results);
    }

    private Map<Integer, Integer> getLastAgentHeardDetails(List<DeviceBackupOverView> deviceBackupOverViews) {
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>();
        for (DeviceBackupOverView backupOverView : deviceBackupOverViews) {
            long lastAgentHeard = backupOverView.getLastHeardTime();
            if (backupOverView.getLastSuccessfulBackupEndTime() != 0L && lastAgentHeard < backupOverView.getLastSuccessfulBackupEndTime()) {
                lastAgentHeard = backupOverView.getLastSuccessfulBackupEndTime();
            }
            if (lastAgentHeard == 0L || backupOverView.isDeviceBolcked() || backupOverView.isDeviceDeleted()) continue;
            Timestamp timestamp = new Timestamp(backupOverView.getLastHeardTime());
            Date date = new Date(timestamp.getTime());
            int daysDiff = this.getDaysDiffByDate(date);
            Integer deviceCount = (Integer)results.get(daysDiff);
            if (deviceCount == null) {
                deviceCount = 1;
            } else {
                Integer n = deviceCount;
                Integer n2 = deviceCount = Integer.valueOf(deviceCount + 1);
            }
            results.put(daysDiff, deviceCount);
        }
        return this.getActuallData(results);
    }

    private Map<Integer, Integer> getActuallData(Map<Integer, Integer> results) {
        HashMap<Integer, Integer> resultMap = new HashMap<Integer, Integer>();
        resultMap.put(1, 0);
        resultMap.put(3, 0);
        resultMap.put(7, 0);
        resultMap.put(15, 0);
        resultMap.put(30, 0);
        resultMap.put(3650, 0);
        for (Map.Entry<Integer, Integer> entry : results.entrySet()) {
            for (Map.Entry resultEntry : resultMap.entrySet()) {
                if (entry.getKey() > (Integer)resultEntry.getKey()) continue;
                resultMap.put((Integer)resultEntry.getKey(), entry.getValue() + (Integer)resultEntry.getValue());
            }
        }
        return resultMap;
    }

    private int getDaysDiffByString(String time) {
        int daysDiff = 0;
        try {
            Date date = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").parse(time);
            DateTime dt1 = new DateTime((Object)date);
            DateTime dt2 = new DateTime();
            daysDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
        }
        catch (ParseException e) {
            System.out.println("Execption while parsing");
        }
        return daysDiff;
    }

    private int getDaysDiffByDate(Date date) {
        int daysDiff = 0;
        DateTime dt1 = new DateTime((Object)date);
        DateTime dt2 = new DateTime();
        daysDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
        return daysDiff;
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }
}

