#This script will check the system health before continuing with the remaining script
# DEVELOPER: Vaibhav K

PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh
source $PARABLU_COMPONENT_SCRIPT_PATH

function health_check(){
        mkdir -p /parablu

	OS=("Ubuntu" "Linux")
	HEALTH_STATUS="pass"
	tput clear
	echo "CHECKING HEALTH OF THE SERVER BEFORE PROCEEDING ......."
	sleep 2s
	#####GETTING THE AVAILABLE MEMORY
	TTL_AVAIL_INSLASH=$(df -m / | tail -1 | awk '{print $4}')
	echo "AVAILABLE MEMORY in -/:    $TTL_AVAIL_INSLASH MB "
	TTL_AVAIL_INMNT=$(df -m $ROOT_PATH | tail -1 | awk '{print $4}')
	echo "AVAILABLE MEMORY in -$ROOT_PATH: $TTL_AVAIL_INMNT MB"

	if [ $? -eq 1 ]; then
		echo "-$ROOT_PATH: is not present"
		HEALTH_STATUS="fail"
	fi

	TTL_AVAIL_INRAM=$(free -m | awk '{print $2}' | head -2 | sed -n 2p)
	echo "TOTAL MEMORY in RAM:   $TTL_AVAIL_INRAM MB"
	PLATFORM=$(cat /etc/*release* | sed -n 1p | awk -F= '{print$2}')
	CURR_OS=$(cat /etc/*release* | awk -F= '{print$2}' | sed -n 4p)

	echo ""
	echo "CHECKING AVAILABLE MEMORY....."
	sleep 2s
	if [ "$TTL_AVAIL_INSLASH" -le "$MIN_LIMIT_INSLASH" ]; then
		echo "-->OUT OF MEMORY in "-/  :" directory. REQUIRED MORE THEN: $MIN_LIMIT_INSLASH MB"
		HEALTH_STATUS="fail"
	fi
	if [ "$TTL_AVAIL_INMNT" -le "$MIN_LIMIT_INMNT" ]; then
		echo "-->OUT OF MEMORY in "$ROOT_PATH:" directory. REQUIRED MORE THEN: $MIN_LIMIT_INMNT MB"
		HEALTH_STATUS="fail"
	fi

	if [ "$TTL_AVAIL_INRAM" -le "$MIN_LIMIT_INRAM" ]; then
		echo "-->OUT OF MEMORY in "RAM" directory. REQUIRED MORE THEN: $MIN_LIMIT_INRAM MB"
		HEALTH_STATUS="fail"
	fi

	CHECK_OS=$(echo $OS | grep "$PLATFORM")
	if [ $? -eq 1 ]; then
		echo "$OS : Not Supported" 
		HEALTH_STATUS="fail"
	fi

	if [ "$HEALTH_STATUS" == "fail" ];then
 		echo ""
		echo "********Cannot Proceed,Didn't met minimum requirement. Please check above messages***********"
		exit 1
	else
       	 	echo "HEALTH CHECK PASS.... Proceeding with installation"
	fi

}


