#!/bin/bash
#                                                                                       #
# SCRIPT: php_service.sh		                                                #
# DATE:   27-Oct-2016                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems								#
# DEVELOPER: Vaibhav K
# PURPOSE: Contains all the utility functions for PHP Installation                   #
# PLATFORM: Ubuntu                                                                      #

# Configure all the prerequisite components

APACHE_SERVICE_SCRIPT_PATH=./apache_service.sh
source $APACHE_SERVICE_SCRIPT_PATH

function select_php ()
{
           os=`lsb_release -r`

           echo "$os" | grep 14.04
           if [ $? -eq 0 ]; then
              PHP_VERSION=5 
	      PHP_DIR=php5
           else
              PHP_VERSION=5.6 
	      PHP_DIR=php/5.6
           fi

}

function prerequisite_php ()
{
	if [ ! -e /etc/$PHP_DIR/apache2/php.ini ]
	then
		release_apache
	fi
}

#installing php
function install_php ()
{
	if [ ! -e /etc/$PHP_DIR/apache2/php.ini ]
	then
		if [[ $PHP_VERSION == 5.6 ]]; then
		 LC_ALL=en_US.UTF-8 add-apt-repository -y ppa:ondrej/php
		 sudo apt-get -y update
		fi
		sleep 3
		#PHP
		apt-get -y install php$PHP_VERSION
		apt-get -y install libapache2-mod-php$PHP_VERSION
		apt-get -y install php$PHP_VERSION-curl
		apt-get -y install php$PHP_VERSION-memcache

		#ZMQ
		apt-get -y install php$PHP_VERSION-dev
		apt-get -y install pkg-config
		apt-get -y install libzmq3
		apt-get -y install libzmq3-dev
		apt-get -y install zmq-dbg
		printf "\n" | pecl install zmq-beta
		service apache2 restart
		sleep 5
		#PHP-conf
		#configure_php

		apt-get -y install php-pear
		pear install Mail
		pear install Mail_Mime
		pear install Net_SMTP
		apt-get -y install php$PHP_VERSION-mcrypt
		service apache2 restart
		apt-get -y install php$PHP_VERSION-gd
	fi
	
	configure_php	
	php5enmod mcrypt
        service apache2 restart
}

#Configuring php
function configure_php ()
{
	sed -i 's|memory_limit = 128M|memory_limit = -1M|' /etc/$PHP_DIR/apache2/php.ini
	sed -i 's|;error_log = php_errors.log|error_log = /var/log/php.log|' /etc/$PHP_DIR/apache2/php.ini
	sed -i 's|expose_php = On|expose_php = Off|' /etc/$PHP_DIR/apache2/php.ini
	sed -i 's|upload_max_filesize = 2M|upload_max_filesize = 1536M|' /etc/$PHP_DIR/apache2/php.ini
	sed -i 's|post_max_size = 8M|post_max_size = 1536M|' /etc/$PHP_DIR/apache2/php.ini
	sed -i 's|ServerTokens OS|ServerTokens Prod|' /etc/apache2/conf-enabled/security.conf
	sed -i 's|ServerSignature On|ServerSignature Off|' /etc/apache2/conf-enabled/security.conf
	sed -i 's|#AddDefaultCharset UTF-8|AddDefaultCharset UTF-8|' /etc/apache2/conf-enabled/charset.conf 
	sed -i 's|memory_limit = 128M|memory_limit = -1M|' /etc/$PHP_DIR/apache2/php.ini
	sed -i 's|upload_max_filesize = 2M|upload_max_filesize = 1536M|' /etc/$PHP_DIR/apache2/php.ini
	sed -i 's|post_max_size = 8M|post_max_size = 1536M|' /etc/$PHP_DIR/apache2/php.ini
	sed -i 's|memory_limit = 128M|memory_limit = -1M|' /etc/$PHP_DIR/apache2/cli/php.ini
	sed -i 's|upload_max_filesize = 2M|upload_max_filesize = 1536M|' /etc/$PHP_DIR/apache2/cli/php.ini
	sed -i 's|post_max_size = 8M|post_max_size = 1536M|' /etc/$PHP_DIR/apache2/cli/php.ini
	sed -i 's|memory_limit = 128M|memory_limit = -1M|' /etc/$PHP_DIR/cgi/php.ini
	sed -i 's|upload_max_filesize = 2M|upload_max_filesize = 1536M|' /etc/$PHP_DIR/cgi/php.ini
	sed -i 's|post_max_size = 8M|post_max_size = 1536M|' /etc/$PHP_DIR/cgi/php.ini

	if [ "`grep -o 'zmq.so' /etc/$PHP_DIR/apache2/php.ini | wc -l`" -le 0 ]
	then
		echo "
		extension=zmq.so" >> /etc/$PHP_DIR/apache2/php.ini
	fi

	if [ "`grep -o 'zmq.so' /etc/$PHP_DIR/cli/php.ini | wc -l`" -le 0 ]
	then
		echo "
		extension=zmq.so" >> /etc/$PHP_DIR/cli/php.ini
	fi

}

# check whether php is installed in the system
function verify_php ()
{
	if  [ ! -e "/etc/$PHP_DIR/apache2/php.ini" ] 
	then 
		echo "PHP Installation failed. Try again after some time"
		exit 0
	else
		echo "PHP installed successfully"
	fi
}

# external function which deploys the php
function release_php ()
{
	select_php
	prerequisite_php
	install_php
	verify_php
}

function uninstall_php()
{
	#PHP
	select_php
	apt-get -y purge php$PHP_VERSION
	apt-get -y purge libapache2-mod-php$PHP_VERSION
	apt-get -y purge php$PHP_VERSION-curl
	apt-get -y purge php$PHP_VERSION-memcache

	#ZMQ
	apt-get -y purge php$PHP_VERSION-dev
	apt-get -y purge pkg-config
	apt-get -y purge libzmq3
	apt-get -y purge libzmq3-dev
	apt-get -y purge zmq-dbg
	apt-get -y purge php-pear
	apt-get -y purge php$PHP_VERSION-mcrypt
	apt-get -y purge php$PHP_VERSION-gd 
	apt-get -y purge `dpkg -l | grep php| awk '{print $2}' |tr "\n" " "`
	
	rm -rf /etc/$PHP_DIR
}

