#!/bin/bash
# DEVELOPER: Vaibhav K

PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh
PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh
source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_CONFIG_SCRIPT_PATH

SCRIPT_PATH=`pwd`
date=`date`
hostname=`hostname`
rm mongooutput.txt

function exec_mail_ids ()
{

        for mail_id in ${WATCHDOG_MAIL_ADDRESS[@]}
                do
                        MAILARRAY+=({\"email\":\"$mail_id\"},)
        done


        tempids=$(echo -e "${MAILARRAY[*]}")
        get_mail_id=$(echo $tempids | sed -e 's/.$//')

}

function old_exec_summary ()
{
        sudo mongo localhost:27017 -u "neil" -p "parablu" --authenticationDatabase "admin" < exec_summary.js >mongooutput.txt
}



function new_exec_summary ()
{
        echo -e "" >> mongooutput.txt
        echo -e "*******************************NEW EXECUTIVE SUMMARY**********************" >>mongooutput.txt
        nohup java -jar executivesummary-0.0.1-SNAPSHOT.jar &
        sleep 1m
        #curl -sb -H "Accept: application/json" localhost:8112/overallstatistics >> mongooutput.txt
        curl -sb -H "Accept: application/json" localhost:8112/dashboardstatistics >> mongooutput.txt
        curl -sb -H "Accept: application/json" localhost:8112/userstatistics >> mongooutput.txt
        curl -sb -H "Accept: application/json" localhost:8112/devicestatistics >> mongooutput.txt
        curl -sb -H "Accept: application/json" localhost:8112/deviceoverviewstatistics >> mongooutput.txt
        curl -sb -H "Accept: application/json" localhost:8112/blackListstatistics >> mongooutput.txt
        pkill -f executivesummary-0.0.1-SNAPSHOT.jar
        }


function exec_subj_decider ()
{

Last_bkp_perc=`grep  "Last Successful Backup End Time On 7 days" mongooutput.txt | grep -oh [0-9][0-9].[0-9][0-9]% | sed 's/\..*//'`
Last_agent_heard=`grep  "Last Agent heard On 7 days" mongooutput.txt | grep -oh [0-9][0-9].[0-9][0-9]% | sed 's/\..*//'`
Warn_limit='90'


grep "BlackList Users" mongooutput.txt
if [ $? -eq 0 ]; then
	exec_subject="Executive Summary[$CUSTOMER_NAME] $date- Blacklist Users"
else
		if [[ ${Last_bkp_perc} -gt ${Warn_limit} ]] && [[ ${Last_agent_heard} -gt ${Warn_limit} ]];then

                        exec_subject="Executive Summary[$CUSTOMER_NAME] $date- Backup is Successful and Agent is talking with Server Successfully"

		elif [[ ${Last_bkp_perc} -lt ${Warn_limit} ]]; then
                        exec_subject="Executive Summary[$CUSTOMER_NAME] $date- Backup is less than 90%"

		elif [[ ${Last_agent_heard} -lt ${Warn_limit} ]]; then
                        exec_subject="Executive Summary[$CUSTOMER_NAME] $date- Agent is not talking with Server"
		else
                        exec_subject="Executive Summary [$CUSTOMER_NAME] $date"
		fi
fi

}

function send_exec_summary_mail ()
{
        exec_mail_ids
	exec_subj_decider

        if [ "$SERVER_TYPE" == "3" ]; then

                ssh -p $SSH_PORT $SSH_USERNAME@$PARAMAIL_MACHINE  "cd $SCRIPT_PATH && rm mongooutput.txt"
                scp -P $SSH_PORT mongooutput.txt $SSH_USERNAME@$PARAMAIL_MACHINE:$SCRIPT_PATH
                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/mongooutput.txt"'","subjectData":"'"${exec_subject}"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/

        else
                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyFilePath":"'"${SCRIPT_PATH}/mongooutput.txt"'","subjectData":"'"${exec_subject}"'","recipents":['"${get_mail_id}"']}' https://$PARAMAIL_MACHINE/paramail/send/customMail/

        fi
}

function release_exec_summary ()
{

#        old_exec_summary
	if [ "$PRODUCT_TYPE" == "1 2" ] || [ "$PRODUCT_TYPE" == "2" ]; then
		new_exec_summary
        fi
        send_exec_summary_mail
}

release_exec_summary
