#!/bin/bash
#                                                                                       #
# DATE:   20-Feb-2019                                                                   #
# REV:    2.0                                                                           #
# DEVELOPED BY: Parablu Systems                                                         #
# DEVELOPER: VAIBHAV K                                                                  #
# PLATFORM: Ubuntu

PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh
PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh

source $PARABLU_CONFIG_SCRIPT_PATH 2> /dev/null
source $PARABLU_COMPONENT_SCRIPT_PATH 2> /dev/null

BACKBLAZE_ID="14cf87ec3a67"
APPLICATION_KEY="00066055d8f4b83d31775758b2f06f06f9cfd04baf"
BACKBLAZE_BUCKET="Mongodbbackups"
export PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:$PATH"
date_time="`date '+%Y%m%d'`.zip"
AGENT_INSTALLABLE_ZIP='https://dns.parablu.com/parablu_installables/scripts/parablu_deployment/agentUpgrade/update.zip'
SCRIPT_PATH=`pwd`

function get_cust_name ()
{
        custname=$(grep "CUSTOMER_NAME=" /var/lib/parablusys/bin/scripts/mongo_full_backup.sh)
        CUSTOMER_NAME=$(echo $custname | tr -d ' ' | sed -e 's/CUSTOMER_NAME=//' | sed 's/"//g')

}

function get_ip_list ()
{
echo 'use parablu001
db.PRIVACY_GATEWAY.distinct("gatewayName")

db.BLUVAULT.distinct("bluVaultName");' >iplist.js

	sudo mongo localhost:27017 -u "neil" -p "parablu" --authenticationDatabase "admin" < iplist.js >iplist.log

	grep '"' iplist.log | sed -e 's/\[//' | sed -e 's/\]//' | sed -e 's/"//g' | sed -e 's/,//g'  >sorted_iplist.log
	final_iplist=`cat sorted_iplist.log`
	OTHER_WATCHDOG_IP=$(echo "$final_iplist" | xargs -n1 | sort -u | xargs)

}

function check_patch_backblaze ()
{

	get_cust_name
	b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY

	b2 ls $BACKBLAZE_BUCKET $CUSTOMER_NAME | grep -oh UpgradeAgent-$date_time
	if [ $? -eq 0 ]; then
        	GET_FILE_NAME=`b2 ls $BACKBLAZE_BUCKET $CUSTOMER_NAME | grep -oh UpgradeAgent-$date_time`

	        echo "NEW AGENT UPDATE AVAILABLE : $GET_FILE_NAME"
        	b2 download-file-by-name $BACKBLAZE_BUCKET $CUSTOMER_NAME/UpgradeAgent-$date_time UpgradeAgent-$date_time
	        if [ $? -eq 0 ]; then

			echo "AGENT UPDATE DOWNLOADED SUCCESSFULLY"
		else
			echo "DOWNLOAD FAILED FROM BACKBLAZE"
			exit
	        fi

	else
        	echo "NO NEW AGENT UPDATES AVAILABLE"
		exit
	fi

}

function agent_script_download ()
{

	wget --user="rsuresh" --password="suresh" -N $AGENT_INSTALLABLE_ZIP
	if [ $? -eq 0 ]; then
		echo "AGENT SCRIPT DOWNLOADED SUCCESSFULLY FROM DNS"
	else 
		echo "AGENT SCRIPT FAILED TO DOWNLOAD FROM DNS"
		exit
	fi
}

function patch_distribute ()
{
	get_ip_list
	for each_ip in ${OTHER_WATCHDOG_IP[@]}
        	do
                	scp -P $SSH_PORT UpgradeAgent-$date_time $SSH_USERNAME@$each_ip:$SCRIPT_PATH/BACKBLAZE_AGENT_AUTOMATION
			scp -P $SSH_PORT update.zip $SSH_USERNAME@$each_ip:$SCRIPT_PATH/BACKBLAZE_AGENT_AUTOMATION
                done
	sleep 5s
	rm -rf *
}

function start_agent_upgrade ()
{

	if [ -f UpgradeAgent-$date_time ]; then
		unzip -o UpgradeAgent-$date_time
		unzip -o update.zip
        	sleep 2s
	        bash UpgradeAgent.sh

		sleep 5s
		rm -rf *
	fi
}

## INITIAL FOLDER CREATION
mkdir -p BACKBLAZE_AGENT_AUTOMATION
chmod -R 777 BACKBLAZE_AGENT_AUTOMATION
cd BACKBLAZE_AGENT_AUTOMATION
if [ $? -eq 0 ]; then
	echo "FOLDER BACKBLAZE_AGENT_AUTOMATION CREATED"
else
	echo "FOLDER BACKBLAZE_AGENT_AUTOMATION MISSING"
	exit
fi


#### START AGENT UPGRADE AUTOMATION

if [ "$SERVER_TYPE" == "0" ]; then
	check_patch_backblaze
	agent_script_download
	start_agent_upgrade
elif [ "$SERVER_TYPE" == "3" ]; then
	check_patch_backblaze
	agent_script_download
	patch_distribute
elif [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "1" ]; then
	sleep 2m
	start_agent_upgrade
fi


