#!/bin/bash
#Developed By: Vaibhav K
# Script: Pull All Logs

PARABLU_CONFIG_SCRIPT_PATH=../../config/parablu_config.sh
PARABLU_COMPONENT_CONFIG_SCRIPT_PATH=../../config/parablu_component_config.sh

source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_COMPONENT_CONFIG_SCRIPT_PATH

BACKBLAZE_ID="14cf87ec3a67"
APPLICATION_KEY="00066055d8f4b83d31775758b2f06f06f9cfd04baf"
BACKBLAZE_BUCKET="Mongodbbackups"
export PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:$PATH"
PULLLOGS_CHECK_FILE="get_logs"


function get_cust_name ()
{
        custname=$(grep "CUSTOMER_NAME=" /var/lib/parablusys/bin/scripts/mongo_full_backup.sh)
        CUSTOMER_NAME=$(echo $custname | tr -d ' ' | sed -e 's/CUSTOMER_NAME=//' | sed 's/"//g')

}

function get_ip_list ()
{
echo 'use parablu001
db.PRIVACY_GATEWAY.distinct("gatewayName")

db.BLUVAULT.distinct("bluVaultName");' >ipplist.js

        sudo mongo localhost:27017 -u "neil" -p "parablu" --authenticationDatabase "admin" < ipplist.js >ipplist.log

        grep '"' ipplist.log | sed -e 's/\[//' | sed -e 's/\]//' | sed -e 's/"//g' | sed -e 's/,//g'  >sorted_ipplist.log
        final_iplist=`cat sorted_ipplist.log`
        OTHER_WATCHDOG_IP=$(echo "$final_iplist" | xargs -n1 | sort -u | xargs)

}

function getOtherServerLogs ()
{

get_ip_list
for ping_ip in ${OTHER_WATCHDOG_IP[@]}
        do
		ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "zip -r $ping_ip-allLog.zip /parablu/log/"
		sleep 2s
		scp -r -P $SSH_PORT $SSH_USERNAME@$ping_ip:$ping_ip-allLog.zip .
		sleep 2s
		ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "rm -rf $ping_ip-allLog.zip"
	done

}


###backblaze check

function check_getlogs_backblaze ()
{
	get_cust_name
	b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY
	b2 ls $BACKBLAZE_BUCKET $CUSTOMER_NAME | grep -oh $PULLLOGS_CHECK_FILE
	if [ $? -eq 0 ]; then
		GET_FILE_VERSION=`b2 ls --long $BACKBLAZE_BUCKET $CUSTOMER_NAME  | grep $PULLLOGS_CHECK_FILE | awk '{print $1}' | head -1`
		echo "FILE VERSION: $GET_FILE_VERSION"
		sleep 1s

		zip -r `hostname`-allLog.zip /parablu/log/
		if [ "$SERVER_TYPE" == "3" ]; then
			getOtherServerLogs
		fi
		
		sleep 1s
		zip -r allLogs.zip *.zip
		sleep 2s

		b2 upload-file  $BACKBLAZE_BUCKET allLogs.zip $CUSTOMER_NAME/allLogs.zip

		b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_FILE_VERSION

		sleep 4s

		rm -rf *.zip

	fi

}
check_getlogs_backblaze
