/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility.parablu001.device;

import com.parablu.utility.model.DeviceStatistics;
import com.parablu.utility.parablu001.device.Device;
import com.parablu.utility.parablu001.device.DeviceRepository;
import com.parablu.utility.parablu001.device.DeviceService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DeviceServiceImpl
implements DeviceService {
    @Autowired
    private DeviceRepository deviceRepository;

    public DeviceStatistics getDeviceStatistics() {
        return new DeviceStatistics(this.deviceRepository.count(), this.deviceRepository.getAllActiveDeviceCount(), this.deviceRepository.getAllBlockedDeviceCount(), this.deviceRepository.getAllDeletedDeviceCount(), this.deviceRepository.getAllDecoupledDeviceCount(), this.getDeviceCountForEachVersions());
    }

    private Map<String, Long> getDeviceCountForEachVersions() {
        List deviceList = this.deviceRepository.findAll();
        return deviceList.parallelStream().filter(device -> !device.isBlocked() && !device.isDeleted() && !device.isDecoupled() && !StringUtils.isEmpty((Object)device.getUserName())).collect(Collectors.toList()).parallelStream().collect(Collectors.groupingBy(Device::getClientVersion, Collectors.counting()));
    }
}

