/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility.controller;

import com.parablu.utility.parablu001.blacklistuser.BlackListUserService;
import com.parablu.utility.parablu001.dashboard.DashboardService;
import com.parablu.utility.parablu001.device.DeviceService;
import com.parablu.utility.parablu001.devicebackupoverview.DeviceBackupOverviewService;
import com.parablu.utility.parablu001.user.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CommonController {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    UserService userService;
    @Autowired
    DeviceService deviceService;
    @Autowired
    DeviceBackupOverviewService backupOverviewService;
    @Autowired
    DashboardService dashboardService;
    @Autowired
    BlackListUserService blackListUserService;

    public CommonController(UserService userService, DeviceService deviceService, DeviceBackupOverviewService backupOverviewService, BlackListUserService blackListUserService) {
        this.LOG.info("Before Initializing the Exec summary");
        this.userService = userService;
        this.deviceService = deviceService;
        this.backupOverviewService = backupOverviewService;
        this.blackListUserService = blackListUserService;
    }

    @RequestMapping(value={"/overallstatistics"}, method={RequestMethod.GET})
    public String getOverAllStatistics() {
        this.LOG.info("Calling getOverAllStatistics");
        StringBuilder builder = new StringBuilder();
        builder.append(this.dashboardService.getDashboatdStatistics().toString());
        builder.append(this.backupOverviewService.getDeviceBackupOverviewStatistics().toString());
        builder.append(this.userService.getUserStatistics().toString());
        builder.append(this.deviceService.getDeviceStatistics().toString());
        builder.append(this.blackListUserService.getAllBlackListUsers());
        return builder.toString();
    }

    @RequestMapping(value={"/dashboardstatistics"}, method={RequestMethod.GET})
    public String getDashBoardStatistics() {
        return this.dashboardService.getDashboatdStatistics().toString();
    }

    @RequestMapping(value={"/blackListstatistics"}, method={RequestMethod.GET})
    public String getBlackListStatistics() {
        return this.blackListUserService.getAllBlackListUsers().toString();
    }
}

