
#!/bin/bash
#                                                                                       #
# SCRIPT: ubuntu_service.sh		                                                #
# DATE:   27-Oct-2016                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems								#
# DEVELOPER: Vaibhav K
# PURPOSE: Contains all the utility functions for Ubuntu platform                       #
# PLATFORM: Ubuntu                                                                      #

# Adding tomcat and www-data users to parablu group
PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh
PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh

function add_system_users()
{
	# for tomcat-user
	useradd tomcat
	# for parablu group
	addgroup parablu
	#link parablu to tomcat
	adduser tomcat parablu
	#link www-data to parablu
	adduser www-data parablu
}

# Install openssh-server, bash-completion, zip, ufw, telnet, traceroute, sysstat 
function install_common_packages () 
{
	#system Update/Upgrade
#	apt-get -y --allow-unauthenticated update 
#	apt-get -y upgrade 
#	echo 'Y' | apt-get -f install

	#common packages for ubunut server
	apt-get -y install openssh-server 
	apt-get -y install bash-completion 
	apt-get -y install zip 
	apt-get -y install ufw 
	apt-get -y install telnet 
	apt-get -y install iptables
	apt-get -y install haveged

	allow_network_firewall 
	apt-get -y install telnet 
	apt-get -y install traceroute 
	apt-get -y install sysstat 
}

#Enable network port
function allow_network_firewall ()
{
	echo 'y' | ufw enable                                             
      	ufw allow ssh
      	ufw allow https
#      	ufw allow http  
#      	ufw allow 5984
}

#install jre
function install_jre ()
{
	echo "JRE is installed using deb package"
	#Java
#	apt-get -y install software-properties-common 
#	apt-get -y install python3-software-properties 
#	add-apt-repository -y ppa:openjdk-r/ppa 
#	apt-get -y --allow-unauthenticated update 
#	apt-get -y install openjdk-8-jre 
	cp ../installables/local_policy.jar /usr/lib/jvm/java-1.8.0-openjdk-amd64/jre/lib/security
	cp ../installables/US_export_policy.jar /usr/lib/jvm/java-1.8.0-openjdk-amd64/jre/lib/security
	echo 'Y'| apt-get -f install
	sudo dpkg --purge --force-depends ca-certificates-java
	echo 'Y'| apt-get -f install
	sudo apt-get -y install ca-certificates-java
}

function install_rar ()
{
                cur_dir=`pwd`
                cd $DEFAULT_FILE_PATH
                #wget rarlab.com/rar/rarlinux-x64-5.1.1.tar.gz
                tar -xzvf ../installables/rarlinux-x64-5.1.1.tar.gz
                cd rar
                sudo make install
                cd $cur_dir

}

function create_ssh_user ()
{
        if [ "$SSH_USERNAME" == "root" ];then
                echo "Skipping SSH User Creation"
        else

                tput clear
                echo "                                 =========================CREATING SSH USER $SSH_USERNAME==================== "
                adduser $SSH_USERNAME
                usermod -aG sudo $SSH_USERNAME
                chage -m 0 -M 99999 -I -1 -E -1 $SSH_USERNAME

#                echo $SSH_USERNAME Created
        fi

##Setting Timezone

echo "===============Setting Timezone=============="

read -p "Kindly specify the timezone you want to configure [For ex Asia/Kolkata], to know your timezone run the "tzselect" command on other terminal: " confirmtz
	until [ ! -z "$confirmtz" ]
	do
   		read -p "Kindly specify the timezone you want to configure [For ex Asia/Kolkata], to know your timezone run the "tzselect" command on other terminal: " confirmtz
	done

echo $confirmtz
timedatectl set-timezone $confirmtz
systemctl status systemd-timesyncd
sudo systemctl enable --now systemd-timesyncd
sleep 1s
service cron restart

}

function enable_backblaze ()
{

present_dir=`pwd`

        cd utilities/BACKBLAZE_INSTALLABLE
        bash backblaze_install.sh
        cd $present_dir

}

function enable_msjob ()
{
tput clear

if [[ "$ONE_DRIVE_BACKUP" == "true" ]]; then

        EXCLUDE_MSJOB="false"
        sleep 1s
        sed -i "s|ODBUSER_PLACEHOLDER|$CLOUD_USER_NO|" ../installables/js/msjob_policy.js
        sed -i "/EXCLUDE_MSJOB/d" $PARABLU_COMPONENT_SCRIPT_PATH
        echo "EXCLUDE_MSJOB=\"false\"" >> $PARABLU_COMPONENT_SCRIPT_PATH

else
	if [[ "$EXCHANGE_BACKUP" == "true" ]]; then

        EXCLUDE_MSJOB="false"
        sleep 1s
        sed -i "s|ODBUSER_PLACEHOLDER|$CLOUD_USER_NO|" ../installables/js/msjob_policy.js
        sed -i "/EXCLUDE_MSJOB/d" $PARABLU_COMPONENT_SCRIPT_PATH
        echo "EXCLUDE_MSJOB=\"false\"" >> $PARABLU_COMPONENT_SCRIPT_PATH
        EXCHANGEBACKUP="true"
        touch koti.txt
else


                echo "                                 =========================MSJOB PROJECT==================== "
read -p "Is this system being configured to backup Microsoft OneDrive for Business? [y/n]" confirmmsjob

#### INVALID CHECK

	while [[ "$confirmmsjob" != "N" ]] && [[ "$confirmmsjob" != "y" ]] && [[ "$confirmmsjob" != "Y" ]] && [[ "$confirmmsjob" != "n" ]]; do
        	echo ""
                echo "INVALID INPUT"
                echo ""
                read -p "Is this system being configured to backup Microsoft OneDrive for Business? [y/n]" confirmmsjob
                echo ""
        done


if [[ $confirmmsjob = y ]] || [[ $confirmmsjob = Y ]]; then

	read -p "Enter Number of MICROSOFT ONE DRIVE BACKUP USERS:" msjobusers
	reg='^[0-999]'
	while [[ ! $msjobusers =~ $reg ]]
	do
 	echo 'Enter the correct number'
 	read -p "Enter Number of MICROSOFT ONE DRIVE BACKUP USERS:" msjobusers
	done

	EXCLUDE_MSJOB="false"
	sleep 1s
	sed -i "s|ODBUSER_PLACEHOLDER|$msjobusers|" ../installables/js/msjob_policy.js	
	sed -i "/EXCLUDE_MSJOB/d" $PARABLU_COMPONENT_SCRIPT_PATH
	echo "EXCLUDE_MSJOB=\"false\"" >> $PARABLU_COMPONENT_SCRIPT_PATH

	MS_IP=$BLUKRYPT_IP
	sed -i "s|MS_IP.*| MS_IP='"$BLUKRYPT_IP"' |" $PARABLU_CONFIG_SCRIPT_PATH

	
	####MS EXCHANGE
	read -p "Is this system being configured to backup Microsoft Exchange Online? [y/n]" confirmmsexchange

	#### INVALID CHECK

        while [[ "$confirmmsexchange" != "N" ]] && [[ "$confirmmsexchange" != "y" ]] && [[ "$confirmmsexchange" != "Y" ]] && [[ "$confirmmsexchange" != "n" ]]; do
                echo ""
                echo "INVALID INPUT"
                echo ""
                read -p "Is this system being configured to backup Microsoft Exchange Online? [y/n]" confirmmsexchange
                echo ""
        done

	if [[ $confirmmsexchange = y ]] || [[ $confirmmsexchange = y ]]; then

		EXCHANGEBACKUP="true"
	else

		EXCHANGEBACKUP="false"
	fi

	####MS Sharepoint
	read -p "Is this system being configured to backup Microsoft Sharepoint  Online? [y/n]" confirmmsharepoint

        #### INVALID CHECK

        while [[ "$confirmmsharepoint" != "N" ]] && [[ "$confirmmsharepoint" != "y" ]] && [[ "$confirmmsharepoint" != "Y" ]] && [[ "$confirmmsharepoint" != "n" ]]; do
                echo ""
                echo "INVALID INPUT"
                echo ""
                read -p "Is this system being configured to backup Microsoft Sharepoint Online? [y/n]" confirmmsharepoint
                echo ""
        done

        if [[ $confirmmsharepoint = y ]] || [[ $confirmmsharepoint = y ]]; then

		read -p "Enter Number of Sharepoint sites for backup:" mssharepoint
        	reg='^[0-999]'
        	while [[ ! $mssharepoint =~ $reg ]]
        	do
        		echo 'Enter the correct number'
        		read -p "Enter Number of Sharepoint sites for backup:" mssharepoint
        	done

        		EXCLUDE_MSJOB="false"
        		sleep 1s
        		sed -i "s|SHAREPOINT_PLACEHOLDER|$mssharepoint|" ../installables/js/msjob_policy.js

                SHAREPOINTBACKUP="true"
        else

                SHAREPOINTBACKUP="false"
        fi


fi
if [[ $confirmmsjob = n ]] || [[ $confirmmsjob = N ]]; then
        #EXCLUDE_MSJOB="true"
        #sed -i "/EXCLUDE_MSJOB/d" $PARABLU_COMPONENT_SCRIPT_PATH
        #echo "EXCLUDE_MSJOB=\"true\"" >> $PARABLU_COMPONENT_SCRIPT_PATH

        ####MS EXCHANGE
        read -p "Is this system being configured to backup Microsoft Exchange Online? [y/n]" confirmmsexchange

        #read -p "Enter Number of MICROSOFT ONE DRIVE BACKUP USERS:" msjobusers

        #### INVALID CHECK

        while [[ "$confirmmsexchange" != "N" ]] && [[ "$confirmmsexchange" != "y" ]] && [[ "$confirmmsexchange" != "Y" ]] && [[ "$confirmmsexchange" != "n" ]]; do
                echo ""
                echo "INVALID INPUT"
                echo ""
                read -p "Is this system being configured to backup Microsoft Exchange Online? [y/n]" confirmmsexchange
                echo ""
        done

        if [[ $confirmmsexchange = y ]] || [[ $confirmmsexchange = y ]]; then

            if [[ $confirmmsjob = n ]] && [[ $confirmmsexchange = y ]]; then

                 	read -p "Enter Number of Exchange Backup Users:" msjobusers
			reg='^[0-999]'
			while [[ ! $msjobusers =~ $reg ]]
			do
 			echo 'Enter the correct number'
 			read -p "Enter Number of Exchange Backup Users:" msjobusers
			done

                  	EXCLUDE_MSJOB="false"
        	  	sleep 1s
        		sed -i "s|EXCHANGEUSER_PLACEHOLDER|$msjobusers|" ../installables/js/msjob_policy.js
        		sed -i "/EXCLUDE_MSJOB/d" $PARABLU_COMPONENT_SCRIPT_PATH
        		echo "EXCLUDE_MSJOB=\"false\"" >> $PARABLU_COMPONENT_SCRIPT_PATH
                        echo "EXCHANGE_BACKUP=\"true\"" >> $PARABLU_COMPONENT_SCRIPT_PATH
        		MS_IP=$BLUKRYPT_IP
        		sed -i "s|MS_IP.*| MS_IP='"$BLUKRYPT_IP"' |" $PARABLU_CONFIG_SCRIPT_PATH 

                	EXCHANGEBACKUP="true"

			####MS Sharepoint
        		read -p "Is this system being configured to backup Microsoft Sharepoint  Online? [y/n]" confirmmsharepoint

        		#### INVALID CHECK

        			while [[ "$confirmmsharepoint" != "N" ]] && [[ "$confirmmsharepoint" != "y" ]] && [[ "$confirmmsharepoint" != "Y" ]] && [[ "$confirmmsharepoint" != "n" ]]; do
                			echo ""
                			echo "INVALID INPUT"
                			echo ""
                			read -p "Is this system being configured to backup Microsoft Sharepoint Online? [y/n]" confirmmsharepoint
                			echo ""
        			done

        		if [[ $confirmmsharepoint = y ]] || [[ $confirmmsharepoint = y ]]; then

                		read -p "Enter Number of Sharepoint sites for backup:" mssharepoint
                		reg='^[0-999]'
                		while [[ ! $mssharepoint =~ $reg ]]
                		do
                        		echo 'Enter the correct number'
                        		read -p "Enter Number of Sharepoint sites for backup:" mssharepoint
                		done

                        	EXCLUDE_MSJOB="false"
                        	sleep 1s
                        	sed -i "s|SHAREPOINT_PLACEHOLDER|$mssharepoint|" ../installables/js/msjob_policy.js

                		     SHAREPOINTBACKUP="true"
        		else

                                   SHAREPOINTBACKUP="false"
                       fi

              fi  
        else
                	EXCLUDE_MSJOB="true"
        		sed -i "/EXCLUDE_MSJOB/d" $PARABLU_COMPONENT_SCRIPT_PATH
        		echo "EXCLUDE_MSJOB=\"true\"" >> $PARABLU_COMPONENT_SCRIPT_PATH
                	EXCHANGEBACKUP="false"
        fi
fi
fi
fi
     
                        
}

function enable_modsecurity ()
{
  read -p "Do you want to enable Mod-Security for this setup? [Strictly recommended only for Parablu hosted setup]: [ y/n] :" modsecurity

  while [[ "$modsecurity" != "N" ]] && [[ "$modsecurity" != "y" ]] && [[ "$modsecurity" != "Y" ]] && [[ "$modsecurity" != "n" ]]; do
                echo ""
                echo "INVALID INPUT"
                echo ""
                read -p "Do you want to enable Mod-Security for this setup? [Strictly recommended only for Parablu hosted setup]: [ y/n] :" modsecurity
                echo ""
        done

        if [[ $modsecurity = y ]] || [[ $modsecurity = Y ]]; then

                bash modsecurity.sh

        fi
}
