source ./config.properties 2>&1

###############################Functions to Update the Config File ########################################
function mongoDetails()
{
    base1=$1
    base2=$2
    sed -i "s|DB1_IP.*|DB1_IP='"$base1"' |g" ./config.properties
	sed -i "s|PORT_DB1_IP.*|PORT_DB1_IP='"$base2"' |g" ./config.properties
    sleep 5
    ./getOldVersion.sh
}

function mongoDetailsRevert()
{
    base1=$1
    base2=$2
    sed -i "s|DB1_IP.*|DB1_IP='"$base1"' |g" ./config.properties
    sed -i "s|PORT_DB1_IP.*|PORT_DB1_IP='"$base2"' |g" ./config.properties
    sleep 5   
}

function downloadDetail()
{
    base1=$1
    sed -i "s|DNS_DOWNLOAD.*|DNS_DOWNLOAD='"$base1"' |" ./config.properties
    sleep 5
}

#winUpgrade
function winUpgrade ()
{
    base1=$1
	sed -i "s|EPA_VERSION.*|EPA_VERSION='"$base1"' |" ./config.properties
    sleep 5
    #
    ./backupservice.sh
}

#winRevert
function winRevert ()
{
	base1=$1
    sed -i "s|EPA_OLD_VERSION.*|EPA_OLD_VERSION='"$base1"' |" ./config.properties
    sleep 5
    ./revertWindowsUpgrade.sh
}
###############################Function Closed - Update the Config File ########################################

# Check DNS Download yes or no from Config file
function checkFileLocation ()
{
    if [[ $DNS_DOWNLOAD = "yes" ]]; then

        downloadDNSFile
        
    elif [[ $DNS_DOWNLOAD = "no" ]]; then
        
        movefileToUpdatePath
        
    else
        echo "No Files to download"
        exit

    fi
}

#Downlaod Function from DNS - Agent URL
function downloadDNSFile ()
{
    #echo "inside download function"
    wget --user $DNS_USERNAME --password $DNS_PASS -P $EPA_UPDATE_PATH $CLIENT_URL &> /dev/null

    if [[ "$?" != 0 ]]; then
        echo "Error downloading file"
        echo "Error downloading file" >> update.log
        exit
    else
        echo "Success Downloaded from DNS" 
        echo "Success Downloaded from DNS" >> update.log
        updateWindows
    fi

}

#Local Agent Validation and config file name change
function movefileToUpdatePath()
{
    if [ -f "$LOCAL_PATH/$DEFAULT_FILE_NAME" ] 
    then
        cp $LOCAL_PATH/$DEFAULT_FILE_NAME $EPA_UPDATE_PATH/$DEFAULT_FILE_NAME
        sed -i "s|EPA_FILE_NAME.*|EPA_FILE_NAME='"$DEFAULT_FILE_NAME"' |" ./config.properties
        sleep 5
        ./windowsUpgrade.sh
    else
        echo "Error Local file not present in $LOCAL_PATH/$DEFAULT_FILE_NAME."
        echo "Error Local file not present in $LOCAL_PATH/$DEFAULT_FILE_NAME." >> update.log
        exit
    fi
}

#DNS downlaod file name will be different need to change the filename to config name
function updateWindows ()
{
    GET_EPA_FILE_NAME="${CLIENT_URL##*/}"
    #echo $GET_EPA_FILE_NAME
    sed -i "s|EPA_FILE_NAME.*|EPA_FILE_NAME='"$GET_EPA_FILE_NAME"' |" ./config.properties
    sleep 5
    ./windowsUpgrade.sh
}

#Backup file Validation for Revert Agent 
function fileValidation()
{
    if [ -f "$LOCAL_PATH/$EPA_OLD_VERSION/$RENAME_EPA_FILE" ] 
    then
        echo "Revert File is avaiable! You will get revert soon"
        echo "Revert File is avaiable! You will get revert soon" >> update.log
        ./revertWindowsUpgrade.sh
    else
        echo "Error Backup file not present in $LOCAL_PATH/$EPA_OLD_VERSION/$RENAME_EPA_FILE."
        echo "Error Backup file not present in $LOCAL_PATH/$EPA_OLD_VERSION/$RENAME_EPA_FILE." >> update.log
        exit
    fi
}
