#!/bin/bash
#                                                                                       #
# SCRIPT: install_primary_monmgo.sh		                                                #
# DATE:   27-Oct-2016                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems								#
# PURPOSE: Contains all the utility functions for mongo Installation                  	#
# PLATFORM: Ubuntu                                                                      #

MONGO_SERVICE_SCRIPT_PATH=./mongo_service.sh
PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh
source $MONGO_SERVICE_SCRIPT_PATH
source $PARABLU_CONFIG_SCRIPT_PATH
 

#iptable redirection
function iptable_redirection ()
{
        ufw allow 27017
        iptables -A INPUT -p tcp --dport 443 -j ACCEPT
        iptables -t nat -I PREROUTING -p tcp --dport 443 -j REDIRECT --to-port 27017
        iptables-save > /etc/iptables.conf

        sed -i '/"exit 0"/i \iptables-restore < /etc/iptables.conf' /etc/rc.local
}

function auth_enable () 
{
	mongo_key_path=parablusys/private
	export LC_ALL=C
	sed -i "s|#auth = true|auth = true|" /etc/mongod.conf
	#### enable key verification
	sed -i "s|#keyFile=/path/to/keyfile|keyFile=$CLIENT_ROOT_PATH/$mongo_key_path/$mongo_key|" /etc/mongod.conf
}

function update_mongo_conf () 
{
	sed -i "/bindIp/d" /etc/mongod.conf
}

function release_secondary_mongo ()
{
	release_mongodb       
        update_mongo_conf
        restart_mongodb
        iptable_redirection
        auth_enable
        restart_mongodb
}

function rollback_secondary_mongo()
{
	rm -rf /etc/mongod.conf
        ufw disable 27017
        rollback_mongodb
}
