#!/bin/bash

#Path for all files
date_time=`date +%F_%T`
BACKUP_PATH_WITH_TIME=$BACKUP_PATH/Backup_$date_time
#BACKUP_OLD=$BACKUP_PATH_WITH_TIME/old
#BACKUP_NEW=$BACKUP_PATH_WITH_TIME/new
SCRIPT_PATH="./"
FILE_PATH=$BACKUP_NEW
DEFAULT_FILE_PATH="../installables"
#Default file path used for logrotate,ssl,mongod.conf
BACKUP_PATH="../installables/patch"
TOMCAT_PATH="/var/lib/tomcat"
TOMCAT_PCB1_PATH="/var/lib/tomcat-pcb1"
TOMCAT_PG1_PATH="/var/lib/tomcat-pcb1"
TOMCAT_JOB1_PATH="/var/lib/tomcat-job1"
TOMCAT_SOLR1_PATH="/var/lib/tomcat-solr1"
UI_PATH="/var/www"
ROOT_PATH="/parablu"
LOG_PATH=$ROOT_PATH/log/
DATA_PATH=$ROOT_PATH/data/
ARCHIVE_PATH=$ROOT_PATH/archive/
LOGROTATE_D_PATH=/etc/logrotate.d/
CLIENT_ROOT_PATH="/var/lib"
PORTAL_LOG_FOLDER="/var/tmp/logs"
NOW=$(date +"%d-%m-%Y")
TWO_DAYS_BEFORE=$(date --date="-2 day" +"%d-%m-%Y")
NANOSECOND_NOW=$(date +"%s%n")'0000'
###########################################################################################################################
#URL and filename_path for Download files from outside environment
BLUKRYPT_JOB_WAR="BluKryptJob.war"
BLUKRYPT_BUILDER_WAR="BluKryptBuilder.war"
BLUVAULT_JOB_WAR="paracloudjob.war"
BLUVAULT_WAR="paracloud.war"
SUPPORT_WAR="support.war"
PARAMAIL_WAR="paramail.war"
PORTAL_WAR="portal.zip"
PORTAL_S_NAME="portal.zip"
SHARE_NAME="share.zip"
BIN_SCRIPTS_NAME="scripts.zip"
JAR_NAME="pcbjars-1.0-jars.zip"
JOB_JAR_NAME="pgjars-1.0-jars.zip"
PARACLOUD_SEARCH_WAR="ParacloudSearch.war"
##########################################################################################################################
#URL and filename_path for Download files internally

if [ ! -z $BRANCH_URL ] && [ ! -z $BRANCH_NAME ]; then
BLUKRYPT_JOB_WAR_URL=$BRANCH_URL$BRANCH_NAME"BluKryptJobWar/lastSuccessfulBuild/artifact/Job/target/$BLUKRYPT_JOB_WAR"
BLUKRYPT_BUILDER_WAR_URL=$BRANCH_URL$BRANCH_NAME"BluKryptBuilderWar/lastSuccessfulBuild/artifact/Builder/target/$BLUKRYPT_WAR"
BLUVAULT_JOB_URL_PATH=$BRANCH_URL$BRANCH_NAME"ParaCloudJobWar/lastSuccessfulBuild/artifact/Job/target/$BLUVAULT_JOB_WAR"
BLUVAULT_URL_PATH=$BRANCH_URL$BRANCH_NAME"ParaCloudBuilderWar/lastSuccessfulBuild/artifact/Builder/target/$BLUVAULT_WAR"
BLUVAULT_BACKUP_URL_PATH=$BRANCH_URL$BRANCH_NAME"ParaCloudBuilderWar/lastSuccessfulBuild/artifact/Builder/target/$BLUVAULT_WAR"
BLUVAULT_SYNC_URL_PATH=$BRANCH_URL$BRANCH_NAME"ParaCloudBuilderWar/lastSuccessfulBuild/artifact/Builder/target/$BLUVAULT_WAR"
SUPPORT_URL_PATH=$BRANCH_URL$BRANCH_NAME"SupportWar/lastSuccessfulBuild/artifact/Support/target/$SUPPORT_WAR"
PARAMAIL_URL_PATH=$BRANCH_URL$BRANCH_NAME"ParaMailWar/lastSuccessfulBuild/artifact/target/$PARAMAIL_WAR"
PORTAL_URL_PATH=$BRANCH_URL$BRANCH_NAME"PortalWar/lastSuccessfulBuild/artifact/build/$PORTAL_S_NAME"
PORTAL_NEW_URL_PATH=$BRANCH_URL$BRANCH_NAME"PortalWar/lastSuccessfulBuild/artifact/build/$PORTAL_S_NAME"
PORTAL_S_URL_PATH=$BRANCH_URL$BRANCH_NAME"PortalWar/lastSuccessfulBuild/artifact/build/$PORTAL_S_NAME"
SHARE_URL_PATH="view/UI/job/share/lastSuccessfulBuild/artifact/portalShare/build/$SHARE_NAME"
BIN_SCRIPTS_URL_PATH="view/Scripts/job/Scripts-zip/lastSuccessfulBuild/artifact/build/$BIN_SCRIPTS_NAME"
JAR_URL_PATH=$BRANCH_URL$BRANCH_NAME"PCBJars/lastSuccessfulBuild/artifact/pcbjars/target/$JAR_NAME"
PG_JAR_URL_PATH=$BRANCH_URL$BRANCH_NAME"PGJars/lastSuccessfulBuild/artifact/pgjars/target/$JOB_JAR_NAME"
PARACLOUD_SEARCH_WAR_URL=$BRANCH_URL$BRANCH_NAME"ParaCloudSearchWar/lastSuccessfulBuild/artifact/target/$PARACLOUD_SEARCH_WAR"
fi

PORT1=9810
PORT2=9610
PORT3=9710
PORT4=9620
JOB_PORT1=9840
JOB_PORT2=9640
JOB_PORT3=9740

###########################################################################################################################
#Client names
WINDOWS_EPA="Parablu_EPA.exe"
MAC_EPA="Parablu_EPA.dmg"
#################Deploy_File_Names
#################Bluvault 
BLUVAULT="paracloud"
#################  Bluvault-Support
SUPPORT="support"
################# ParaMail
PARAMAIL="paramail"
##################   BluVault-JOB
BLUVAULT_JOB="paracloudjob"
##################  BluKrypt 
BLUKRYPT="BluKryptBuilder"
BLUKRYPT_JOB="BluKryptJob"
##################  BluKrypt JOB
PARACLOUD_SEARCH="ParacloudSearch"
##################  UI
portal_zip="portal.zip"
portat_ui="portal"
share_zip="share.zip"
share_ui="share"
HOST_EXTENSION=".cloudapp.net"
HOST_ENABLED="false"
##################  AGENT   ##################
EPA_FILE_NAME="bsupdate.exe"
RENAME_EPA_FILE="windows"
EPA_ENV_LINK="https://"$BLUVAULT_IP"/download/bsupdate.exe"
CLIENT_URL="http://$CLIENT_URL_IP_LOCAL/client"
###################  cert / key file name with extenstion
CERT_FILE="ca.crt"
KEY_FILE="ca.key"
DER_FILE="ca.der"
mongo_key="parabluKey" ##################  (replicaKeyname)

##################################################################

LOGROTATEROOTPATH=/var/lib

#########PG repo specification############
PG_REPO_FOLDER_NAME="pgjars-1.0"
PG_REPO_NAME="repo"
##############################

#########pcb repo specification#######
REPO_JAR_FOLDER_NAME="pcbjars-1.0"
REPO_NAME="repo"
#################################

###jenkins url to download war pls give as it is, how i have given below
BRANCH_URL="view/Release%202.1/job/"
BRANCH_NAME="Release" #which prepended with project name ex- ReleaseBluKryptJobWar
##################################

DNS_USERNAME="wardrobe"
DNS_PASS="be0O5tar@P"
DNS_URL="https://dns.parablu.com/parablu_installables/master_testing"
JENKINS_URL="http://192.168.7.101:8081"
CLIENT_URL_IP_LOCAL="192.168.7.59" #192.168.7.59 #CLIENT_URL="https://dns.parablu.com/parablu_installables"

LDAP="true" #false
AMICHECK="false" #false
AZURE_VM="false" #false
SSL_ENABLED="false" #false
##################  AGENT   ##################
EPA_VERSION="v1.1603.53" #v1.1603.53
##############################################
                          ENVIRON_MODE='Azure_BS' 
#########################################
####mongo port specifications######

PROXY_ENABLED=""
PROXY_HOSTNAME=""
PROXY_PORT=""
PROXY_A_USERNAME=""
PROXY_A_PASSWD=""
REP_ENB=""
R_DB_PORT="27017" 
MONGODB_PORT="27017" 
MONGODB1_PORT="27017" 
MONGODB2_PORT="27017" 
MONGODB3_PORT="27017" 
###############################
LOGOFILE1="/var/lib/parablusys/bin/logos/login_logo.png"
LOGOFILE2="/var/lib/parablusys/bin/logos/header_logo.png"
CERT_FILEPATH=/var/lib/parablusys/conf
MIN_LIMIT_INSLASH="10000"
MIN_LIMIT_INMNT="4000"
MIN_LIMIT_INRAM="1000"
CSVFILE=../installables/patch/patch.csv
DNS_LINK_PATCHCSV_FOLDER="https://dns.parablu.com/parablu_installables/release/"
DNS_PATCHCSV_FILENAME="patch.csv"
STORAGE_TYPE=0
IS_WATCHDOG_ENABLED="false"
WATCHDOG_MAIL_ADDRESS="support@parablu.com"
CUSTOMER_NAME="PARABLU"
WATCHDOG_FROM_MAIL_ADDRESS="support@parablu.com"
IS_LITEVERSION_ENABLED="false"
OTHER_WATCHDOG_IP="localhost"
SSH_USERNAME="parablu"
IS_PG1="false"
MAIL_MACHINE="localhost"
SSH_PORT="22"
PARAMAIL_MACHINE="localhost"
MOUNT_POINTS="/"
FILE_SYSTEMS="/ /etc /parablu /var"
BDB_USER="pbwatchdog"
BDB_PASS="parablu123"
####################### EXCLUDE PROJECTS ########################
EXCLUDE_BLUKRYPT_JOB="false"
EXCLUDE_BLUKRYPT_BUILDER="false"
EXCLUDE_PARACLOUD_JOB="false"
EXCLUDE_PARACLOUD="false"
EXCLUDE_SUPPORT="false"
EXCLUDE_PARAMAIL="false"
EXCLUDE_PORTAL="false"
EXCLUDE_PARACLOUD_SEARCH="false"
EXCLUDE_MSJOB="true"
EXCLUDE_SPEEDTEST="true"
PGOVERLOADLIMIT=50
WATCHDOG_DISK="/ /parablu"
MS_JOB="MSJob"
MS_JOB_WAR="MSJob.war"
#ONLYMSJOB="false"
#EXCHANGEONLY="false"
### Change Local mongo port to custom port if 27017 is not used for mongo
LOCAL_MONGO_PORT="27017"
dbport=$(grep port: /etc/mongod.conf)
DBPORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')
MAIN_PARACLOUD="false"
SSH_KEY_FILE=''
## New Variables for one drive and exchange Backup
ONE_DRIVE_BACKUP="false"
EXCHANGE_BACKUP="false"
OFFICE_SUITE="false"
