#!/bin/bash
#                                                                                       #
# SCRIPT: msjob_health_check.sh                                                             #
# DATE:   7-Oct-2019                                                                  #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems                                                         #
# DEVELOPER: Vaibhav K
# PURPOSE: Checks MSJOB Health Status                    #
# PLATFORM: Ubuntu

PARABLU_COMPONENT_SCRIPT_PATH=./common_health_check.sh
source $PARABLU_COMPONENT_SCRIPT_PATH


function msjob_component_check ()
{
        echo "CHECKING MSJOB COMPONENTS......"
        tomcat_job_check
#       tomcat_pcb_check
        memcache_check
        apache_check
#       activemq_check
        if [ "$SERVER_TYPE" != "0" ]; then
                mongo_check
        fi
}

function monitor_msjob ()
{
        msjob_component_check
        echo "********************************************************************************************************************" >>watchdog.log
        echo "">>watchdog.log
        echo "********************************************************************************************************************" >>watchdog.log
        echo -e "DISK\t\t | AVAILABLE_MEMORY\t | USED_MEMORY\t | USED_PERCENTAGE\t" >>watchdog.log
        space_check
        ram_check
#          jsonObjectMemRoot=$(memory_root)
        jsonObjectMemParablu=$(memory_parablu)
 #       jsonObjectMemMdatabase=$(memory_mdatabase)
        echo "********************************************************************************************************************" >>watchdog.log
        echo "">>watchdog.log
        echo "********************************************************************************************************************" >>watchdog.log
        echo -e "MEMORY_TYPE\t | TOTAL_MEMORY\t | USED_MEMORY\t | FREE_MEMORY\t | BUFFER\t | CACHE\t" >>watchdog.log

        jsonObjectRamMem=$(ram_mem)
        jsonObjectRamSwap=$(ram_swap)
}

