use parablu001;
print('Total Number of Users : ');
db.USER.count()
print('')

print('Number of Active Users : ')
db.USER.find({"active" : true}).count()
print('')

print('Number of Blocked Users : ')
db.USER.find({"active" : false, "deleted":false}).count()
print('')

print('Number of Deleted Users : ')
db.USER.find({"active" : false, "deleted":true}).count()
print('')

print('Total Number of Devices : ')
db.DEVICE.count()
print('')

print('Number of Active Devices : ')
db.DEVICE.find({"blocked" : false, "deleted" : false, "decoupled" : false}).count()
print('')

print('Number of Blocked Devices : ')
db.DEVICE.find({"blocked" : true, "deleted" : false}).count()
print('')

print('Number of Deleted Devices : ')
db.DEVICE.find({"deleted" : true}).count()
print('')

print('Number of Decoupled Devices : ')
db.DEVICE.find({"blocked" : false, "deleted" : false, "decoupled" : true}).count()
print('')

print('Number of Devices based on their versions : ')
db.DEVICE.aggregate([{"$group" : {_id:"$clientVersion", No_Of_Devices:{$sum:1}}}])
print('')

var count = 01;
var fileInCloud = db.BACKUP.find({"storagePlace" : "CLOUD"}).count();
var fileInPG = db.BACKUP.find({storagePlace: {$ne : "CLOUD"}, "folder" : false}).count();
var totalFiles = db.BACKUP.find().count();
var storagePlaceNotUpdated = db.BACKUP.find({$where : "this.chunkFiles.length > 0", "folder" : false,"present" : true,'storagePlace':{$exists:false}}).count();
var curruptedFiles =  db.BACKUP.find({$where : "this.chunkFiles.length<= 0", "folder" : false,"present" : true,'storagePlace':{$exists:true}}).count();
var bkpTableCount = 01;

while (true) {
if(db.getCollection("BACKUP_"+count).exists()){
	var fileInCloud = fileInCloud + db.getCollection("BACKUP_"+count).find({"storagePlace" : "CLOUD"}).count();
	var fileInPG = fileInPG + db.getCollection("BACKUP_"+count).find({storagePlace: {$ne : "CLOUD"}, "folder" : false}).count();
	var totalFiles = totalFiles + db.getCollection("BACKUP_"+count).find().count();
	var storagePlaceNotUpdated = storagePlaceNotUpdated + db.getCollection("BACKUP_"+count).find({$where : "this.chunkFiles.length > 0", "folder" : false,"present" : true,'storagePlace':{$exists:false}}).count();
	var curruptedFiles = curruptedFiles + db.getCollection("BACKUP_"+count).find({$where : "this.chunkFiles.length<= 0", "folder" : false,"present" : true,'storagePlace':{$exists:true}}).count();
	var bkpTableCount = bkpTableCount + 1;
}else{
break;
}
var count = count + 1;
}

print('Total Backup table count : ')
print(bkpTableCount);
print('')

print('Number of files in Cloud : ')
print(fileInCloud);
print('')

print('Total Size in Cloud : ')
db.DEVICE_BACKUP_OVERVIEW.aggregate([{$group: {_id: null,total: { $sum: "$storageUtilizedInCloud"}}}])
print('')

print('Number of files in PG : ')
print(fileInPG);
print('')

print('Total Size in PG : ')
db.DEVICE_BACKUP_OVERVIEW.aggregate([{$group: {_id: null,total: { $sum: "$storageUtilized"}}}])
print('')

print('Total Number of backup files : ')
print(totalFiles);
print('')

print('Number of Devices where Full Backup Completed : ')
db.DEVICE_BACKUP_OVERVIEW.find({$where : "this.firstBkpStartTime != this.lastBkpStartTime"} ).count()
print('')

print(' Number of users where Backup Policy is not mapped : ')
db.USER_BACKUP_POLICY_MAPPING.find({"backupPolicy" : null } ).count()
print('')

print('Files moved to cloud but storage place not updated: ')
print(storagePlaceNotUpdated);
print('')

print('Corrupted Files: ')
print(curruptedFiles);
print('')

