/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility.parablu001.devicebackupoverview;

import com.parablu.utility.element.BackupOverviewElement;
import com.parablu.utility.model.DeviceBackupOverviewStatistics;
import com.parablu.utility.parablu001.device.DeviceRepository;
import com.parablu.utility.parablu001.devicebackupoverview.DeviceBackupOverView;
import com.parablu.utility.parablu001.devicebackupoverview.DeviceBackupOverviewRepository;
import com.parablu.utility.parablu001.devicebackupoverview.DeviceBackupOverviewService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DeviceBackupOverviewServiceImpl
implements DeviceBackupOverviewService {
    @Autowired
    private DeviceBackupOverviewRepository deviceBackupOverviewRepository;
    @Autowired
    private DeviceRepository deviceRepository;
    public static final String COMPLETED = "COMPLETED";
    private static final String USER_NAME = "User Name";
    private static final String DEVICE_NAME = "Device Name";
    public static final String POLICY_NAME = "Policy Name";
    private static final String STATUS_STARTED = "STARTED";
    private static int deviceBlocked = 0;
    private static int firstBkpNotStarted = 0;
    private static int lah7ltdays = 0;
    private static int lah7gtdays = 0;
    private static int lahNAdays = 0;
    private static int firstBkpStarted = 0;
    private static int firstBkplah7gtdays = 0;
    private static int firstBkplah30gtdays = 0;
    static int firstBkplah7ltdays = 0;
    static int firstBkplah30ltdays = 0;
    private static int bkpCompleted0mbUsers = 0;
    private static int bkpcompletedAnd7Started = 0;
    private static int bkpnotcompletedAnd7Started = 0;
    private static int bkpcompletedAnd30Started = 0;
    private static int bkpcompletedAnd30NotStarted = 0;
    private static Set<String> noOfUsersNotHeard7Days = new HashSet();
    private static int bkpcompletedAnd7NotStarted = 0;
    private static Set<String> noOfUsersNotHeard30Days = new HashSet();
    private static Set<String> noOfUsersHeardLast7days = new HashSet();
    private static Set<String> noOfUsersHeardLast30days = new HashSet();
    static Map<String, BackupOverviewElement> firstBkplah7gtdaysMap = new HashMap();
    static Map<String, BackupOverviewElement> firstBkplah30gtdaysMap = new HashMap();
    static Map<String, BackupOverviewElement> firstBkplah7ltdaysMap = new HashMap();
    static Map<String, BackupOverviewElement> firstBkplah30ltdaysMap = new HashMap();
    static Map<String, BackupOverviewElement> deviceBlockedMap = new HashMap();
    static Map<String, BackupOverviewElement> firstBkpNotStartedMap = new HashMap();
    static Map<String, BackupOverviewElement> lah7ltdaysMap = new HashMap();
    static Map<String, BackupOverviewElement> lah7gtdaysMap = new HashMap();
    static Map<String, BackupOverviewElement> lahNAdaysMap = new HashMap();
    static Map<String, BackupOverviewElement> bkpcompletedAnd30StartedMap = new HashMap();
    static Map<String, BackupOverviewElement> bkpcompletedAnd30NotStartedMap = new HashMap();
    static Map<String, BackupOverviewElement> bkpcompletedAnd7StartedProtMap = new HashMap();
    static Map<String, BackupOverviewElement> bkpcompletedAnd7StartedNotProtMap = new HashMap();
    static Set<String> activeUsers = new HashSet();
    static int overAllUsersSize = 0;
    static Set<String> activeUsersBkpCompleted = new HashSet();
    static Set<String> activeUsersBkpNotCompleted = new HashSet();
    static Set<String> activeUsersWithoutDevice = new HashSet();
    static Set<String> activeUsersWithDevice = new HashSet();
    static Set<String> activeUsersFullBkpNotStarted = new HashSet();
    static Map<String, BackupOverviewElement> activeUsersWithoutDeviceMap = new HashMap();
    static Map<String, BackupOverviewElement> activeOverViewMap = new HashMap();
    static Map<String, BackupOverviewElement> activeUsersNotCompletedBkpMap = new HashMap();
    static Map<String, BackupOverviewElement> firstBkpStartedBkpMap = new HashMap();
    static Map<String, BackupOverviewElement> activeUsersNotCompletedWithDevBkpMap = new HashMap();
    static Map<String, BackupOverviewElement> activeUsersBkpCompletedMap = new HashMap();
    static Map<String, BackupOverviewElement> zeroMbMap = new HashMap();
    static Set<String> activeUsersWithBlockedDevice = new HashSet();
    static Set<String> activeUsersWithDeviceFirstBkpNotStarted = new HashSet();
    static Set<String> activeUsersWithDeviceFirstBkpStarted = new HashSet();
    static Set<String> lastHeardGt15days = new HashSet();
    static Set<String> lastHeardLT15days = new HashSet();
    static String outputFileName = "";
    static StringBuilder builder = new StringBuilder();
    public static final String DD_MMM_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";

    public DeviceBackupOverviewStatistics getDeviceBackupOverviewStatistics() {
        List deviceBackupOverViews = this.deviceBackupOverviewRepository.findAll();
        Map lastAgentHeardDetails = this.getLastAgentHeardDetails(deviceBackupOverViews);
        Map lastSuccessfullBackupEndTimeDetails = this.getLastSuccessfullBackupEndTimeDetails(deviceBackupOverViews);
        Map FirstBackupCompletedTimeDetails = this.getFirstBackupCompletedTimeDetails(deviceBackupOverViews);
        Map lastAgentHeardDetailsInPercentage = this.getInPercentage(lastAgentHeardDetails);
        Map lastSuccessfullBackupEndTimeDetailsInPercentage = this.getInPercentage(lastSuccessfullBackupEndTimeDetails);
        Map FirstBackupCompletedTimeDetailsInPercentage = this.getInPercentage(FirstBackupCompletedTimeDetails);
        long totalNoOfRestore = this.getTotalNoOfRestore(deviceBackupOverViews);
        String totalSizeInPg = this.getTotalSizeInPG(deviceBackupOverViews);
        return new DeviceBackupOverviewStatistics(this.deviceBackupOverviewRepository.getAllFirstBackupCompletedCount(), this.getTotalSizeInPG(deviceBackupOverViews), lastSuccessfullBackupEndTimeDetails, lastAgentHeardDetails, FirstBackupCompletedTimeDetails, totalNoOfRestore, lastSuccessfullBackupEndTimeDetailsInPercentage, lastAgentHeardDetailsInPercentage, FirstBackupCompletedTimeDetailsInPercentage, this.deviceBackupOverviewRepository.getDeviceFullBkpCompletedCount(), totalSizeInPg);
    }

    private Map<Integer, Float> getInPercentage(Map<Integer, Integer> deviceDetails) {
        HashMap<Integer, Float> results = new HashMap<Integer, Float>();
        long totaldevices = this.deviceRepository.getAllActiveDeviceCount();
        int[] i = new int[]{1, 3, 7, 15, 30, 3650};
        Float percentage = null;
        try {
            for (int j : i) {
                if (deviceDetails.get(j) != null) {
                    percentage = Float.valueOf(DeviceBackupOverviewServiceImpl.getPercentage((int)deviceDetails.get(j), (int)((int)totaldevices)));
                }
                results.put(j, percentage);
            }
        }
        catch (Exception e) {
            System.out.println("Execption while parsing");
        }
        return results;
    }

    public static float getPercentage(int n, int total) {
        float proportion = (float)n / (float)total;
        return proportion * 100.0f;
    }

    private String getTotalSizeInPG(List<DeviceBackupOverView> deviceBackupOverViews) {
        return DeviceBackupOverviewServiceImpl.formatFileSize((long)deviceBackupOverViews.stream().mapToLong(DeviceBackupOverView::getStorageUtilizedInPg).sum());
    }

    private long getTotalNoOfRestore(List<DeviceBackupOverView> deviceBackupOverViews) {
        return deviceBackupOverViews.stream().mapToLong(DeviceBackupOverView::getNoOfSuccessfulRestores).sum();
    }

    private Map<Integer, Integer> getLastSuccessfullBackupEndTimeDetails(List<DeviceBackupOverView> deviceBackupOverViews) {
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>();
        for (DeviceBackupOverView backupOverView : deviceBackupOverViews) {
            if (backupOverView.getLastSuccessfulBackupEndTime() == 0L || backupOverView.isDeviceBolcked() || backupOverView.isDeviceDeleted()) continue;
            Timestamp timestamp = new Timestamp(backupOverView.getLastSuccessfulBackupEndTime());
            Date date = new Date(timestamp.getTime());
            int daysDiff = this.getDaysDiffByDate(date);
            Integer deviceCount = (Integer)results.get(daysDiff);
            if (deviceCount == null) {
                deviceCount = 1;
            } else {
                Integer n = deviceCount;
                Integer n2 = deviceCount = Integer.valueOf(deviceCount + 1);
            }
            results.put(daysDiff, deviceCount);
        }
        return this.getActuallData(results);
    }

    private Map<Integer, Integer> getFirstBackupCompletedTimeDetails(List<DeviceBackupOverView> deviceBackupOverViews) {
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>();
        for (DeviceBackupOverView backupOverView : deviceBackupOverViews) {
            if (StringUtils.isEmpty((String)backupOverView.getFirstBkpEndTime()) || backupOverView.isDeviceBolcked() || backupOverView.isDeviceDeleted()) continue;
            int daysDiff = this.getDaysDiffByString(backupOverView.getFirstBkpEndTime());
            Integer deviceCount = (Integer)results.get(daysDiff);
            if (deviceCount == null) {
                deviceCount = 1;
            } else {
                Integer n = deviceCount;
                Integer n2 = deviceCount = Integer.valueOf(deviceCount + 1);
            }
            results.put(daysDiff, deviceCount);
        }
        return this.getActuallData(results);
    }

    private Map<Integer, Integer> getLastAgentHeardDetails(List<DeviceBackupOverView> deviceBackupOverViews) {
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>();
        for (DeviceBackupOverView backupOverView : deviceBackupOverViews) {
            long lastAgentHeard = backupOverView.getLastHeardTime();
            if (backupOverView.getLastSuccessfulBackupEndTime() != 0L && lastAgentHeard < backupOverView.getLastSuccessfulBackupEndTime()) {
                lastAgentHeard = backupOverView.getLastSuccessfulBackupEndTime();
            }
            if (lastAgentHeard == 0L || backupOverView.isDeviceBolcked() || backupOverView.isDeviceDeleted()) continue;
            Timestamp timestamp = new Timestamp(backupOverView.getLastHeardTime());
            Date date = new Date(timestamp.getTime());
            int daysDiff = this.getDaysDiffByDate(date);
            Integer deviceCount = (Integer)results.get(daysDiff);
            if (deviceCount == null) {
                deviceCount = 1;
            } else {
                Integer n = deviceCount;
                Integer n2 = deviceCount = Integer.valueOf(deviceCount + 1);
            }
            results.put(daysDiff, deviceCount);
        }
        return this.getActuallData(results);
    }

    private Map<Integer, Integer> getActuallData(Map<Integer, Integer> results) {
        HashMap<Integer, Integer> resultMap = new HashMap<Integer, Integer>();
        resultMap.put(1, 0);
        resultMap.put(3, 0);
        resultMap.put(7, 0);
        resultMap.put(15, 0);
        resultMap.put(30, 0);
        resultMap.put(3650, 0);
        for (Map.Entry<Integer, Integer> entry : results.entrySet()) {
            for (Map.Entry resultEntry : resultMap.entrySet()) {
                if (entry.getKey() > (Integer)resultEntry.getKey()) continue;
                resultMap.put((Integer)resultEntry.getKey(), entry.getValue() + (Integer)resultEntry.getValue());
            }
        }
        return resultMap;
    }

    private int getDaysDiffByString(String time) {
        int daysDiff = 0;
        try {
            Date date = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").parse(time);
            DateTime dt1 = new DateTime((Object)date);
            DateTime dt2 = new DateTime();
            daysDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
        }
        catch (ParseException e) {
            System.out.println("Execption while parsing");
        }
        return daysDiff;
    }

    private int getDaysDiffByDate(Date date) {
        int daysDiff = 0;
        DateTime dt1 = new DateTime((Object)date);
        DateTime dt2 = new DateTime();
        daysDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
        return daysDiff;
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    public String getDeviceBackupOverviewReportStatistics() {
        String outputFileName = "";
        File inputFile = null;
        try {
            DateTime dt1;
            String currentBkpStarted;
            DateTime dt2;
            Date yourDate;
            BackupOverviewElement element;
            String path = "/parablu/bkpOverview/summary/Backup_OverviewStatus.xlsx";
            inputFile = new File(path);
            List backupOverviewElementsList = DeviceBackupOverviewServiceImpl.getOverviewElementFromExcel((File)inputFile);
            System.out.println(" Over all users in excel ..." + backupOverviewElementsList.size());
            overAllUsersSize = backupOverviewElementsList.size();
            for (BackupOverviewElement backupOverviewElement : backupOverviewElementsList) {
                String string = backupOverviewElement.getUserId();
                if (backupOverviewElement.isUserActive()) {
                    activeUsers.add(string);
                    activeOverViewMap.put(string, backupOverviewElement);
                }
                if (!backupOverviewElement.isFirstBackupCompleted() || !backupOverviewElement.isUserActive()) continue;
                activeUsersBkpCompleted.add(string);
                activeUsersBkpCompletedMap.put(string, backupOverviewElement);
            }
            for (Map.Entry entry : activeOverViewMap.entrySet()) {
                BackupOverviewElement backupOverviewElement = (BackupOverviewElement)entry.getValue();
                if (backupOverviewElement.isFirstBackupCompleted() || activeUsersBkpCompleted.contains(backupOverviewElement.getUserId())) continue;
                activeUsersBkpNotCompleted.add(backupOverviewElement.getUserId());
                activeUsersNotCompletedBkpMap.put(backupOverviewElement.getUserId(), backupOverviewElement);
                if (!StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpStartTime())) continue;
                activeUsersFullBkpNotStarted.add(backupOverviewElement.getUserId());
            }
            activeUsersBkpNotCompleted.removeAll(activeUsersBkpCompleted);
            for (Map.Entry entry : activeUsersNotCompletedBkpMap.entrySet()) {
                BackupOverviewElement backupOverviewElement = (BackupOverviewElement)entry.getValue();
                if (!StringUtils.isEmpty((String)backupOverviewElement.getDeviceName())) {
                    activeUsersNotCompletedWithDevBkpMap.put(backupOverviewElement.getUserId(), backupOverviewElement);
                    activeUsersWithDevice.add(backupOverviewElement.getUserId());
                    continue;
                }
                activeUsersWithoutDevice.add(backupOverviewElement.getUserId());
                activeUsersWithoutDeviceMap.put(backupOverviewElement.getUserId(), backupOverviewElement);
            }
            HashMap<String, BackupOverviewElement> activeUsersWithDeviceFirstBkpStartedMap = new HashMap<String, BackupOverviewElement>();
            for (Map.Entry entry : activeUsersNotCompletedWithDevBkpMap.entrySet()) {
                BackupOverviewElement element4 = (BackupOverviewElement)entry.getValue();
                if (!element4.isDeviceActive()) {
                    activeUsersWithBlockedDevice.add(element4.getUserId());
                    continue;
                }
                if (StringUtils.isEmpty((String)element4.getFirstBkpStartTime())) {
                    activeUsersWithDeviceFirstBkpNotStarted.add(element4.getUserId());
                }
                if (StringUtils.isEmpty((String)element4.getFirstBkpStartTime()) || element4.isFirstBackupCompleted()) continue;
                activeUsersWithDeviceFirstBkpStarted.add(element4.getUserId());
                activeUsersWithDeviceFirstBkpStartedMap.put(element4.getUserId(), element4);
            }
            HashMap<String, BackupOverviewElement> hashMap = new HashMap<String, BackupOverviewElement>();
            HashMap<String, BackupOverviewElement> hashMap2 = new HashMap<String, BackupOverviewElement>();
            HashMap<String, BackupOverviewElement> noOfUsersHeardLast7daysMap = new HashMap<String, BackupOverviewElement>();
            HashMap<String, BackupOverviewElement> noOfUsersHeardLast30daysMap = new HashMap<String, BackupOverviewElement>();
            int i = 0;
            int j = 0;
            for (Map.Entry entry : activeUsersBkpCompletedMap.entrySet()) {
                String lastHeardTime;
                ++i;
                BackupOverviewElement element5 = (BackupOverviewElement)entry.getValue();
                if (!element5.isUserActive()) continue;
                ++j;
                if (element5.getStorageUtilized().equals("0.00 MB")) {
                    ++bkpCompleted0mbUsers;
                    zeroMbMap.put(element5.getUserId(), element5);
                }
                if (StringUtils.isEmpty((String)(lastHeardTime = element5.getLastHeardTime()))) {
                    noOfUsersNotHeard30Days.add(element5.getUserId());
                    hashMap2.put(element5.getUserId(), element5);
                    continue;
                }
                SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                Date yourDate2 = format.parse(lastHeardTime);
                yourDate2.setHours(0);
                yourDate2.setMinutes(0);
                DateTime dt12 = new DateTime((Object)yourDate2);
                DateTime dt22 = new DateTime();
                int daysDifference = Days.daysBetween((ReadableInstant)dt12, (ReadableInstant)dt22).getDays();
                if (daysDifference >= 30) {
                    noOfUsersNotHeard30Days.add(element5.getUserId());
                    hashMap2.put(element5.getUserId(), element5);
                }
                if (daysDifference >= 7) {
                    noOfUsersNotHeard7Days.add(element5.getUserId());
                    hashMap.put(element5.getUserId(), element5);
                }
                if (daysDifference < 7) {
                    noOfUsersHeardLast7days.add(element5.getUserId());
                    noOfUsersHeardLast7daysMap.put(element5.getUserId(), element5);
                    noOfUsersHeardLast30days.add(element5.getUserId());
                    noOfUsersHeardLast30daysMap.put(element5.getUserId(), element5);
                }
                if (daysDifference >= 30) continue;
                noOfUsersHeardLast30days.add(element5.getUserId());
                noOfUsersHeardLast30daysMap.put(element5.getUserId(), element5);
            }
            noOfUsersNotHeard7Days.removeAll(noOfUsersHeardLast7days);
            noOfUsersNotHeard30Days.removeAll(noOfUsersHeardLast30days);
            boolean vv = false;
            for (Map.Entry entry : noOfUsersHeardLast7daysMap.entrySet()) {
                element = (BackupOverviewElement)entry.getValue();
                int daysDifferenceCurr = 8;
                int lastBkpEndDiff = 8;
                int firstBkpEndDiff = 8;
                yourDate = null;
                DateTime dt13 = null;
                dt2 = new DateTime();
                if (!StringUtils.isEmpty((String)element.getCurrentBkpStartTime())) {
                    currentBkpStarted = element.getCurrentBkpStartTime();
                    yourDate = DeviceBackupOverviewServiceImpl.getDate((String)currentBkpStarted);
                    dt13 = new DateTime((Object)yourDate);
                    daysDifferenceCurr = Days.daysBetween((ReadableInstant)dt13, (ReadableInstant)dt2).getDays();
                }
                if (!StringUtils.isEmpty((String)element.getLastBkpEndTime())) {
                    yourDate = DeviceBackupOverviewServiceImpl.getDate((String)element.getLastBkpEndTime());
                    dt13 = new DateTime((Object)yourDate);
                    lastBkpEndDiff = Days.daysBetween((ReadableInstant)dt13, (ReadableInstant)dt2).getDays();
                }
                if (!StringUtils.isEmpty((String)element.getLastBkpEndTime())) {
                    yourDate = DeviceBackupOverviewServiceImpl.getDate((String)element.getFirstBkpEndTime());
                    dt13 = new DateTime((Object)yourDate);
                    firstBkpEndDiff = Days.daysBetween((ReadableInstant)dt13, (ReadableInstant)dt2).getDays();
                }
                if (daysDifferenceCurr < 7 || lastBkpEndDiff < 7 || firstBkpEndDiff < 7) {
                    ++bkpcompletedAnd7Started;
                    bkpcompletedAnd7StartedProtMap.put(element.getUserId(), element);
                    continue;
                }
                ++bkpcompletedAnd7NotStarted;
                bkpcompletedAnd7StartedNotProtMap.put(element.getUserId(), element);
            }
            for (Map.Entry entry : noOfUsersHeardLast30daysMap.entrySet()) {
                element = (BackupOverviewElement)entry.getValue();
                int daysDifferenceCurr = 31;
                int lastBkpEndDiff = 31;
                int firstBkpEndDiff = 31;
                yourDate = null;
                DateTime dt14 = null;
                dt2 = new DateTime();
                if (!StringUtils.isEmpty((String)element.getCurrentBkpStartTime())) {
                    currentBkpStarted = element.getCurrentBkpStartTime();
                    yourDate = DeviceBackupOverviewServiceImpl.getDate((String)currentBkpStarted);
                    dt14 = new DateTime((Object)yourDate);
                    daysDifferenceCurr = Days.daysBetween((ReadableInstant)dt14, (ReadableInstant)dt2).getDays();
                }
                if (!StringUtils.isEmpty((String)element.getLastBkpEndTime())) {
                    yourDate = DeviceBackupOverviewServiceImpl.getDate((String)element.getLastBkpEndTime());
                    dt14 = new DateTime((Object)yourDate);
                    lastBkpEndDiff = Days.daysBetween((ReadableInstant)dt14, (ReadableInstant)dt2).getDays();
                }
                if (!StringUtils.isEmpty((String)element.getLastBkpEndTime())) {
                    yourDate = DeviceBackupOverviewServiceImpl.getDate((String)element.getFirstBkpEndTime());
                    dt14 = new DateTime((Object)yourDate);
                    firstBkpEndDiff = Days.daysBetween((ReadableInstant)dt14, (ReadableInstant)dt2).getDays();
                }
                if (daysDifferenceCurr < 30 || lastBkpEndDiff < 30 || firstBkpEndDiff < 30) {
                    ++bkpcompletedAnd30Started;
                    bkpcompletedAnd30StartedMap.put(element.getUserId(), element);
                    continue;
                }
                ++bkpcompletedAnd30NotStarted;
                bkpcompletedAnd30NotStartedMap.put(element.getUserId(), element);
            }
            activeUsersWithoutDevice.removeAll(activeUsersWithDevice);
            for (Map.Entry entry : activeUsersNotCompletedBkpMap.entrySet()) {
                element = (BackupOverviewElement)entry.getValue();
                if (!StringUtils.isEmpty((String)element.getDeviceName())) {
                    activeUsersNotCompletedWithDevBkpMap.put(element.getUserId(), element);
                    activeUsersWithDevice.add(element.getUserId());
                } else {
                    activeUsersWithoutDevice.add(element.getUserId());
                }
                if (StringUtils.isEmpty((String)element.getDeviceName())) continue;
                if (!element.isDeviceActive()) {
                    ++deviceBlocked;
                    deviceBlockedMap.put(element.getUserId(), element);
                }
                if (!element.isDeviceActive()) continue;
                if (StringUtils.isEmpty((String)element.getFirstBkpStartTime())) {
                    ++firstBkpNotStarted;
                    firstBkpNotStartedMap.put(element.getUserId(), element);
                    String lastHeardTime = element.getLastHeardTime();
                    if (StringUtils.isEmpty((String)lastHeardTime)) {
                        ++lahNAdays;
                        lahNAdaysMap.put(element.getUserId(), element);
                        continue;
                    }
                    SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                    Date yourDate3 = format.parse(lastHeardTime);
                    yourDate3.setHours(0);
                    yourDate3.setMinutes(0);
                    dt1 = new DateTime((Object)yourDate3);
                    DateTime dt23 = new DateTime();
                    int diffInDays = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt23).getDays();
                    if (diffInDays < 7) {
                        ++lah7ltdays;
                        lah7ltdaysMap.put(element.getUserId(), element);
                    }
                    if (diffInDays < 7) continue;
                    ++lah7gtdays;
                    lah7gtdaysMap.put(element.getUserId(), element);
                    continue;
                }
                ++firstBkpStarted;
                firstBkpStartedBkpMap.put(element.getUserId(), element);
            }
            for (Map.Entry entry : firstBkpStartedBkpMap.entrySet()) {
                element = (BackupOverviewElement)entry.getValue();
                String lastHeardTime = element.getLastHeardTime();
                if (StringUtils.isEmpty((String)lastHeardTime)) {
                    ++firstBkplah30gtdays;
                    continue;
                }
                SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                Date yourDate4 = format.parse(lastHeardTime);
                yourDate4.setHours(0);
                yourDate4.setMinutes(0);
                dt1 = new DateTime((Object)yourDate4);
                DateTime dt24 = new DateTime();
                int diffInDays = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt24).getDays();
                if (diffInDays < 7) {
                    ++firstBkplah7ltdays;
                    firstBkplah7ltdaysMap.put(element.getUserId(), element);
                }
                if (diffInDays < 30) {
                    ++firstBkplah30ltdays;
                    firstBkplah30gtdaysMap.put(element.getUserId(), element);
                }
                if (diffInDays >= 7) {
                    ++firstBkplah7gtdays;
                    firstBkplah7gtdaysMap.put(element.getUserId(), element);
                }
                if (diffInDays < 30) continue;
                ++firstBkplah30gtdays;
                firstBkplah30gtdaysMap.put(element.getUserId(), element);
            }
            builder.append("*************************Backup Overview Flowchart Statistics*******************\n");
            builder.append("\n");
            builder.append("1. Active Users ..." + activeOverViewMap.size() + "\n");
            builder.append("\n");
            builder.append("2. Full backup completed active users with out duplicates ..." + activeUsersBkpCompleted.size() + "\n");
            builder.append("\n");
            builder.append("\t1. Users with 0.0MB backup ..." + bkpCompleted0mbUsers + "\n");
            builder.append("\n");
            builder.append("\t2. Users Not heard from 7 days ..." + noOfUsersNotHeard7Days.size() + "\n");
            builder.append("\n");
            builder.append("\t3. Users Not heard from 30 Days ..." + noOfUsersNotHeard30Days.size() + "\n");
            builder.append("\n");
            builder.append("\t4. Users  heard from 7 Days ..." + noOfUsersHeardLast7days.size() + "\n");
            builder.append("\t\t1. Users Protected (FB end time, Last Backup end time & Current backup start time) " + bkpcompletedAnd7Started + "\n");
            builder.append("\t\t2. Users Not Protected (FB end time, Last Backup end time & Current backup start time) " + bkpcompletedAnd7NotStarted + "\n");
            builder.append("\n");
            builder.append("\t5. Users heard from 30 Days ..." + noOfUsersHeardLast30days.size() + "\n");
            builder.append("\t\t1. Users Backup completed and started ..." + bkpcompletedAnd30Started + "\n");
            builder.append("\t\t2. Users Backup completed and not started ..." + bkpcompletedAnd30NotStarted + "\n");
            builder.append("\n");
            builder.append("3. Users with out Device, with out duplicates " + activeUsersWithoutDevice.size() + "\n");
            builder.append("\n");
            builder.append("4. Full backup not completed active users without duplicates " + activeUsersBkpNotCompleted.size() + "\n");
            builder.append("\n");
            builder.append("\t1. Users Device blocked " + deviceBlocked + "\n");
            builder.append("\n");
            builder.append("\t2. Users First backup not started " + firstBkpNotStarted + "\n");
            builder.append("\t\t1. Users device heard from 7 days " + lah7ltdays + "\n");
            builder.append("\t\t2. Users device not heard from 7 days " + lah7gtdays + "\n");
            builder.append("\t\t3. Users device with no heard time at all " + lahNAdays + "\n");
            builder.append("\n");
            builder.append("\t3. User with First backup start time " + firstBkpStarted + "\n");
            builder.append("\t\t1. Users Not heard from 7 days " + firstBkplah7gtdays + "\n");
            builder.append("\t\t2. Users Not heard from 30 days " + firstBkplah30gtdays + "\n");
            builder.append("\t\t1. Users heard from 7 days " + firstBkplah7ltdays + "\n");
            builder.append("\t\t2. Users heard from 30 days " + firstBkplah30ltdays + "\n");
            try (XSSFWorkbook xSSFWorkbook = new XSSFWorkbook();){
                String overViewTime = String.valueOf(System.currentTimeMillis());
                System.out.println(" Before Generating output for overview ...");
                DeviceBackupOverviewServiceImpl.createSummary((XSSFWorkbook)xSSFWorkbook);
                ArrayList activeUsersList = new ArrayList();
                Collection values = activeOverViewMap.values();
                activeUsersList.addAll(values);
                List recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(activeUsersList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Active Users");
                Collection vals = activeUsersBkpCompletedMap.values();
                ArrayList bkpCompletedList = new ArrayList();
                bkpCompletedList.addAll(vals);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(bkpCompletedList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"First Bkp completed");
                Collection vals0mb = zeroMbMap.values();
                ArrayList bkpCompletedzerombList = new ArrayList();
                bkpCompletedzerombList.addAll(vals0mb);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(bkpCompletedzerombList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Users with 0.0MB backup");
                Collection vals7 = hashMap.values();
                ArrayList bkpCompleted7valsList = new ArrayList();
                bkpCompleted7valsList.addAll(vals7);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(bkpCompleted7valsList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Users Not heard from 7 days");
                Collection vals30 = hashMap2.values();
                ArrayList bkpCompleted30valsList = new ArrayList();
                bkpCompleted30valsList.addAll(vals30);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(bkpCompleted30valsList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Users Not heard from 30 days");
                Collection less7 = noOfUsersHeardLast7daysMap.values();
                ArrayList bkpCompletedLt7valsList = new ArrayList();
                bkpCompletedLt7valsList.addAll(less7);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(bkpCompletedLt7valsList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Users heard from 7 days");
                Collection bkpcompletedAnd7StartedProtMa = bkpcompletedAnd7StartedProtMap.values();
                ArrayList bkpcompletedAnd7StartedProtMapList = new ArrayList();
                bkpcompletedAnd7StartedProtMapList.addAll(bkpcompletedAnd7StartedProtMa);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(bkpcompletedAnd7StartedProtMapList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Protected U-H from 7 days");
                Collection bkpcompletedAnd7StartedNotProtMa = bkpcompletedAnd7StartedNotProtMap.values();
                ArrayList bkpcompletedAnd7StartedNotProtMapList = new ArrayList();
                bkpcompletedAnd7StartedNotProtMapList.addAll(bkpcompletedAnd7StartedNotProtMa);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(bkpcompletedAnd7StartedNotProtMapList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Not Protected U-H from 7 days");
                Collection less30 = noOfUsersHeardLast30daysMap.values();
                ArrayList bkpCompletedLt30valsList = new ArrayList();
                bkpCompletedLt30valsList.addAll(less30);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(bkpCompletedLt30valsList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"U-H from 30 days");
                Collection bkp30 = bkpcompletedAnd30StartedMap.values();
                ArrayList bkpproCompletedLt30valsList = new ArrayList();
                bkpproCompletedLt30valsList.addAll(bkp30);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(bkpproCompletedLt30valsList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Protected U-H from 30 days");
                Collection bkpnot30 = bkpcompletedAnd30NotStartedMap.values();
                ArrayList bkpnotproCompletedLt30valsList = new ArrayList();
                bkpnotproCompletedLt30valsList.addAll(bkpnot30);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(bkpnotproCompletedLt30valsList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Not-protected U-H from 30 days");
                Collection activeUsersWithoutDevices = activeUsersWithoutDeviceMap.values();
                ArrayList activeUsersWithoutDeviceList = new ArrayList();
                activeUsersWithoutDeviceList.addAll(activeUsersWithoutDevices);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(activeUsersWithoutDeviceList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Users with out Device");
                Collection activeUsersNotCompletedBkps = activeUsersNotCompletedBkpMap.values();
                ArrayList activeUsersNotCompletedBkpsList = new ArrayList();
                activeUsersNotCompletedBkpsList.addAll(activeUsersNotCompletedBkps);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(activeUsersNotCompletedBkpsList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Full backup not completed");
                Collection deviceBlockedMapVal = deviceBlockedMap.values();
                ArrayList deviceBlockedMapList = new ArrayList();
                deviceBlockedMapList.addAll(deviceBlockedMapVal);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(deviceBlockedMapList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Users Device blocked");
                Collection firstBkpNotStartedMapVal = firstBkpNotStartedMap.values();
                ArrayList firstBkpNotStartedMapList = new ArrayList();
                firstBkpNotStartedMapList.addAll(firstBkpNotStartedMapVal);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(firstBkpNotStartedMapList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"First backup not started ");
                Collection lah7ltdaysMapVal = lah7ltdaysMap.values();
                ArrayList lah7ltdaysMapValList = new ArrayList();
                lah7ltdaysMapValList.addAll(lah7ltdaysMapVal);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(lah7ltdaysMapValList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Users device heard from 7");
                Collection lah7gtdaysMapVal = lah7gtdaysMap.values();
                ArrayList lah7gtdaysMapValList = new ArrayList();
                lah7gtdaysMapValList.addAll(lah7gtdaysMapVal);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(lah7gtdaysMapValList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Users device not heard from 7");
                Collection lahNAdaysMapVal = lahNAdaysMap.values();
                ArrayList lahNAdaysMapList = new ArrayList();
                lahNAdaysMapList.addAll(lahNAdaysMapVal);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(lahNAdaysMapList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Users device with no heard time");
                Collection firstBkpStartedBkpMapVal = firstBkpStartedBkpMap.values();
                ArrayList firstBkpStartedBkpMapList = new ArrayList();
                firstBkpStartedBkpMapList.addAll(firstBkpStartedBkpMapVal);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(firstBkpStartedBkpMapList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"User with First backup start time");
                Collection firstBkplah7gtdaysMapVal = firstBkplah7gtdaysMap.values();
                ArrayList firstBkplah7gtdaysMapValList = new ArrayList();
                firstBkplah7gtdaysMapValList.addAll(firstBkplah7gtdaysMapVal);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(firstBkplah7gtdaysMapValList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Users N-H from 7 days");
                Collection firstBkplah30gtdaysMapVal = firstBkplah30gtdaysMap.values();
                ArrayList firstBkplah30gtdaysMapList = new ArrayList();
                firstBkplah30gtdaysMapList.addAll(firstBkplah30gtdaysMapVal);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(firstBkplah30gtdaysMapList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Users N-H from 30 days");
                Collection firstBkplah7ltdaysMapVal = firstBkplah7ltdaysMap.values();
                ArrayList firstBkplah7ltdaysMapValList = new ArrayList();
                firstBkplah7ltdaysMapValList.addAll(firstBkplah7ltdaysMapVal);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(firstBkplah7ltdaysMapValList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Users-heard from 7 days");
                Collection firstBkplah30ltdaysMapVal = firstBkplah30ltdaysMap.values();
                ArrayList firstBkplah30ltdaysMapList = new ArrayList();
                firstBkplah30ltdaysMapList.addAll(firstBkplah30ltdaysMapVal);
                recordToAdd = DeviceBackupOverviewServiceImpl.updateValuesToExcel(firstBkplah30gtdaysMapList, (long)DeviceBackupOverviewServiceImpl.getLongValue((String)overViewTime));
                DeviceBackupOverviewServiceImpl.createExcelForXlsx((List)recordToAdd, (XSSFWorkbook)xSSFWorkbook, (String)"Users-heard from 30 days");
                DeviceBackupOverviewServiceImpl.writeExcelForXlsx((XSSFWorkbook)xSSFWorkbook, (String)inputFile.getParent());
                System.out.println(" After creating excel for overview ...");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    private static List<BackupOverviewElement> getOverviewElementFromExcel(File inputFile) throws IOException, InvalidFormatException {
        ArrayList<BackupOverviewElement> backupOverviewElementsList = new ArrayList<BackupOverviewElement>();
        Workbook workbook = WorkbookFactory.create((File)inputFile);
        Sheet sheet = workbook.getSheetAt(0);
        Iterator rowIterator = sheet.rowIterator();
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (row.getRowNum() == 0 || row.getRowNum() == 1) continue;
            BackupOverviewElement overviewElement = DeviceBackupOverviewServiceImpl.getOverviewElement((Row)row);
            backupOverviewElementsList.add(overviewElement);
        }
        return backupOverviewElementsList;
    }

    private static void createSummary(XSSFWorkbook workbookVal) {
        XSSFSheet firstSheet = workbookVal.createSheet("Summary");
        XSSFCellStyle style = DeviceBackupOverviewServiceImpl.getStyle((XSSFWorkbook)workbookVal);
        int rowCount = 3;
        int columnCount = 0;
        XSSFRow row = firstSheet.createRow(rowCount);
        Cell cell = row.createCell(columnCount);
        cell.setCellValue(" OverAll users in Excel ");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(++columnCount);
        cell.setCellValue((double)overAllUsersSize);
        cell.setCellStyle((CellStyle)style);
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)activeOverViewMap.size(), (String)"1. Active users without Duplicates ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)activeUsersBkpCompleted.size(), (String)"2. Full backup completed active users with out duplicates ...");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)bkpCompleted0mbUsers, (String)"     1. Users with 0.0MB backup ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)noOfUsersNotHeard7Days.size(), (String)"     2. Users Not heard from 7 days ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)noOfUsersNotHeard30Days.size(), (String)"     3. Users Not heard from 30 Days ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)noOfUsersHeardLast7days.size(), (String)"     4. Users  heard from 7 Days ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)bkpcompletedAnd7Started, (String)"          1. Users Protected (FB end time, Last Backup end time & Current backup start time) ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)bkpcompletedAnd7NotStarted, (String)"          2. Users Not Protected (FB end time, Last Backup end time & Current backup start time) ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)noOfUsersHeardLast30days.size(), (String)"     5. Users heard from 30 Days ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)bkpcompletedAnd30Started, (String)"          1. Users Backup completed and started ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)bkpcompletedAnd30NotStarted, (String)"          2. Users Backup not completed and started ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)activeUsersWithoutDevice.size(), (String)"3. Users with out Device, with out duplicates ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)activeUsersBkpNotCompleted.size(), (String)"4. Full backup not completed active users without duplicates ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)deviceBlocked, (String)"     1. Users Device blocked ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)firstBkpNotStarted, (String)"     2. Users First backup not started ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)lah7ltdays, (String)"          1. Users device heard from 7 days ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)lah7gtdays, (String)"          2. Users device not heard from 7 days ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)lahNAdays, (String)"          3. Users device with no heard time at all ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)firstBkpStarted, (String)"     3. User with First backup start time ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)firstBkplah7gtdays, (String)"          1. Users Not heard from 7 days  ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)firstBkplah30gtdays, (String)"          2. Users Not heard from 30 days ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)firstBkplah7ltdays, (String)"          3. Users heard from 7 days  ");
        DeviceBackupOverviewServiceImpl.addRowsToSummary((XSSFWorkbook)workbookVal, (XSSFSheet)firstSheet, (int)(++rowCount), (long)firstBkplah30ltdays, (String)"          4. Users heard from 30 days ");
    }

    private static XSSFCellStyle getStyle(XSSFWorkbook workbookVal) {
        XSSFFont defaultFont = workbookVal.createFont();
        defaultFont.setFontHeightInPoints((short)10);
        defaultFont.setFontName("Arial");
        defaultFont.setColor(IndexedColors.BLACK.getIndex());
        defaultFont.setBold(false);
        defaultFont.setItalic(false);
        XSSFCellStyle style = workbookVal.createCellStyle();
        style.setWrapText(true);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setFont((Font)defaultFont);
        return style;
    }

    private static void addRowsToSummary(XSSFWorkbook workbookVal, XSSFSheet firstSheet, int rowCount, long size, String rowheader) {
        int columnCount = 0;
        XSSFRow row = firstSheet.createRow(rowCount);
        firstSheet.setColumnWidth(0, 15000);
        XSSFCellStyle style = DeviceBackupOverviewServiceImpl.getStyle((XSSFWorkbook)workbookVal);
        Cell cell = row.createCell(columnCount);
        cell.setCellStyle((CellStyle)style);
        cell.setCellValue(rowheader);
        cell = row.createCell(++columnCount);
        cell.setCellStyle((CellStyle)style);
        cell.setCellValue((double)size);
    }

    static void writeExcelForXlsx(XSSFWorkbook workbook, String path) {
        String dateStringFormat = "";
        System.out.println("...." + path);
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy");
            Date dateD = new Date();
            dateStringFormat = df2.format(dateD);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String outputFileName = "Backup_Overview_Summary.xlsx";
        try (FileOutputStream fos = new FileOutputStream(new File(path + "/" + outputFileName));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom(BorderStyle.MEDIUM);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void createExcelForXlsx(List<List> l1, XSSFWorkbook workbook, String sheetName) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet(sheetName);
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                XSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    XSSFFont font;
                    XSSFCellStyle cellStyle;
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum == 0) {
                        cellStyle = workbook.createCellStyle();
                        cellStyle.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        font = workbook.createFont();
                        font.setFontName("Arial");
                        font.setFontHeightInPoints((short)12);
                        font.setBold(true);
                        cellStyle.setFont((Font)font);
                        cell.setCellStyle((CellStyle)cellStyle);
                        firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A1:C1"));
                    }
                    if (rownum != 1) continue;
                    cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor(HSSFColor.GOLD.index);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBold(true);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static List<List> updateValuesToExcel(List<BackupOverviewElement> bkpOverViewList, long reportDate) {
        boolean showAdditionalAdAttrbs = true;
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("User ID");
        headerRow.add("Email ID");
        headerRow.add("User Status");
        headerRow.add("Device Name");
        headerRow.add("Device Status");
        headerRow.add("Device Installation Time");
        headerRow.add("Client Version");
        headerRow.add("Policy Name");
        headerRow.add("First Backup Start Time");
        headerRow.add("First Backup End Time");
        headerRow.add("Is First Backup Completed");
        headerRow.add("Last Successful Backup Start Time");
        headerRow.add("Last Successful Backup End Time");
        headerRow.add("Is Last Backup Completed");
        headerRow.add("Current Backup Start Time");
        headerRow.add("Current Backup Status");
        headerRow.add("Current Backup Completion %");
        headerRow.add("Is Backup Running");
        headerRow.add("Last Time Heard");
        headerRow.add("Total Storage Utilized");
        headerRow.add("Notes");
        if (showAdditionalAdAttrbs) {
            headerRow.add("Display Name");
            headerRow.add("Location");
            headerRow.add("Department");
            headerRow.add("Active Directory User Status");
        }
        headerRow.add("First Full Backup Files Size");
        headerRow.add("First Full Backup No Of Files");
        headerRow.add("Last SucessFull Backup Files Size");
        headerRow.add("Last SucessFull Backup No Of Files");
        headerRow.add("Currently Running Backup Files Size");
        headerRow.add("Currently Running Backup No Of Files");
        headerRow.add("Total Size To Upload");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add("Report generated on " + DeviceBackupOverviewServiceImpl.getTimeZoneShortFormat((long)reportDate));
        recordToAdd.add(headerRow1);
        recordToAdd.add(headerRow);
        for (BackupOverviewElement backupOverviewElement : bkpOverViewList) {
            ArrayList<String> firstRow = new ArrayList<String>();
            try {
                int percentage;
                boolean isBackupRunning;
                firstRow.add(backupOverviewElement.getUserId());
                firstRow.add(backupOverviewElement.getEmailId());
                String userActive = "Active";
                userActive = backupOverviewElement.isUserActive() ? "Active" : "Blocked";
                firstRow.add(userActive);
                firstRow.add(backupOverviewElement.getDeviceName());
                boolean isDeviceActive = backupOverviewElement.isDeviceActive();
                String deviceActive = DeviceBackupOverviewServiceImpl.getDeviceActiveState((BackupOverviewElement)backupOverviewElement, (boolean)isDeviceActive);
                firstRow.add(deviceActive);
                firstRow.add(backupOverviewElement.getEpaInstallationDate());
                firstRow.add(backupOverviewElement.getClientVersion());
                firstRow.add(backupOverviewElement.getPolicyName());
                long firstBkpStartTime = DeviceBackupOverviewServiceImpl.getFirstBkpStartTime((BackupOverviewElement)backupOverviewElement);
                firstRow.add(DeviceBackupOverviewServiceImpl.getDateInFormat((Long)firstBkpStartTime));
                firstRow.add(backupOverviewElement.getFirstBkpEndTime());
                String lastSuccessfulBackupEndTime = backupOverviewElement.getLastSuccessfulBackupEndTime();
                boolean isFirstBkpCompleted = !StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime()) || !StringUtils.isEmpty((String)lastSuccessfulBackupEndTime);
                String firstBkpCompleted = DeviceBackupOverviewServiceImpl.getFirstBkpCompletedState((boolean)isFirstBkpCompleted);
                firstRow.add(firstBkpCompleted);
                String lastSuccessBkpStartTime = "";
                if (isFirstBkpCompleted) {
                    long lstBkpEndTime;
                    long lstBkpStartTime;
                    if (StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupStartTime()) || StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                        backupOverviewElement.setLastSuccessfulBackupStartTime(backupOverviewElement.getFirstBkpStartTime());
                        backupOverviewElement.setLastSuccessfulBackupEndTime(backupOverviewElement.getFirstBkpEndTime());
                    }
                    if ((lstBkpStartTime = DeviceBackupOverviewServiceImpl.getTime((String)backupOverviewElement.getLastSuccessfulBackupStartTime())) > (lstBkpEndTime = DeviceBackupOverviewServiceImpl.getTime((String)backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                        lstBkpEndTime = lstBkpStartTime + 0x6DDD00L;
                    }
                    lastSuccessBkpStartTime = DeviceBackupOverviewServiceImpl.getDateInFormat((Long)lstBkpStartTime);
                    lastSuccessfulBackupEndTime = DeviceBackupOverviewServiceImpl.getDateInFormat((Long)lstBkpEndTime);
                }
                firstRow.add(lastSuccessBkpStartTime);
                firstRow.add(lastSuccessfulBackupEndTime);
                String lastBkpStatus = backupOverviewElement.getLastBkpStatus();
                if (lastBkpStatus == null) {
                    lastBkpStatus = "";
                }
                if (backupOverviewElement.isLastBackupCompleted()) {
                    firstRow.add("Y");
                } else {
                    firstRow.add("N");
                }
                boolean bl = isBackupRunning = StringUtils.isNotEmpty((String)lastBkpStatus) && !"COMPLETED".equalsIgnoreCase(lastBkpStatus) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && isDeviceActive;
                if (!StringUtils.isEmpty((String)lastBkpStatus) && !"COMPLETED".equalsIgnoreCase(lastBkpStatus) && isBackupRunning) {
                    String lstBkpStartTimeStr = backupOverviewElement.getLastBkpStartTime();
                    if (StringUtils.isNotEmpty((String)lstBkpStartTimeStr) && StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                        long lstsuccessBkpEndTime;
                        long lstBkpStartTime = DeviceBackupOverviewServiceImpl.getTime((String)backupOverviewElement.getLastBkpStartTime());
                        if (lstBkpStartTime < (lstsuccessBkpEndTime = DeviceBackupOverviewServiceImpl.getTime((String)backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                            lstBkpStartTime = lstsuccessBkpEndTime + 0x6DDD00L;
                        }
                        lstBkpStartTimeStr = DeviceBackupOverviewServiceImpl.getDateInFormat((Long)lstBkpStartTime);
                    }
                    firstRow.add(lstBkpStartTimeStr);
                } else {
                    firstRow.add("");
                }
                if (lastBkpStatus.equalsIgnoreCase("COMPLETED") || !isBackupRunning) {
                    firstRow.add("");
                } else {
                    firstRow.add(lastBkpStatus);
                }
                int totalNoOfFiles = 0;
                boolean noOfFilesRemaining = false;
                if (!StringUtils.isEmpty((String)backupOverviewElement.getTotalNoOfFiles())) {
                    totalNoOfFiles = Integer.parseInt(backupOverviewElement.getTotalNoOfFiles());
                }
                if ((percentage = DeviceBackupOverviewServiceImpl.getPercentageCompleted((BackupOverviewElement)backupOverviewElement)) >= 100) {
                    percentage = 97;
                }
                if (StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpStartTime()) && !lastBkpStatus.equalsIgnoreCase("COMPLETED") && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && isBackupRunning) {
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getTotalCurrentlyRunningBkpSizeInPer())) {
                        firstRow.add(backupOverviewElement.getTotalCurrentlyRunningBkpSizeInPer() + "%");
                    } else {
                        firstRow.add(String.valueOf(percentage) + "%");
                    }
                } else {
                    firstRow.add("");
                }
                if (isBackupRunning) {
                    firstRow.add("Y");
                } else {
                    firstRow.add("N");
                }
                String lastHeardDate = "";
                firstRow.add(backupOverviewElement.getLastHeardTime());
                firstRow.add(backupOverviewElement.getStorageUtilized());
                String reason = DeviceBackupOverviewServiceImpl.getReason((BackupOverviewElement)backupOverviewElement, (String)backupOverviewElement.getLastBkpStatus(), (boolean)isBackupRunning);
                firstRow.add(reason);
                if (showAdditionalAdAttrbs) {
                    firstRow.add(backupOverviewElement.getDisplayName());
                    firstRow.add(backupOverviewElement.getLocation());
                    firstRow.add(backupOverviewElement.getDepartment());
                    if (backupOverviewElement.isAccountStatus()) {
                        firstRow.add("Y");
                    } else {
                        firstRow.add("N");
                    }
                }
                if (isFirstBkpCompleted) {
                    firstRow.add(backupOverviewElement.getFirstFullBkpTotalSizeOfFiles());
                    firstRow.add("" + backupOverviewElement.getFirstFullBkpNoOfFiles());
                    firstRow.add(backupOverviewElement.getLastSucessfulBkpTotalSizeOfFiles());
                    firstRow.add("" + backupOverviewElement.getLastSucessfulBkpNoOfFiles());
                } else {
                    firstRow.add("");
                    firstRow.add("");
                    firstRow.add("");
                    firstRow.add("");
                }
                if (isBackupRunning) {
                    firstRow.add(backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFiles());
                    firstRow.add("" + backupOverviewElement.getCurrentlyRunningBkpNoOfFiles());
                } else {
                    firstRow.add("");
                    firstRow.add("");
                }
                firstRow.add(backupOverviewElement.getTotalSizeToUpload());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private static String getReason(BackupOverviewElement backupOverviewElement, String lastBkpStatus, boolean isBackupRunning) {
        String reason = backupOverviewElement.getReason();
        if (!StringUtils.isEmpty((String)lastBkpStatus) && ("STARTED".equalsIgnoreCase(lastBkpStatus) || "COMPLETED".equalsIgnoreCase(lastBkpStatus))) {
            reason = "";
        }
        if (StringUtils.isEmpty((String)backupOverviewElement.getReason()) && !"STARTED".equalsIgnoreCase(lastBkpStatus) && "COMPLETED".equalsIgnoreCase(lastBkpStatus)) {
            reason = "Backup temporarily suspended because server is busy.Will be retried later";
        }
        if (!isBackupRunning || StringUtils.isEmpty((String)lastBkpStatus)) {
            reason = "";
        }
        return reason;
    }

    private static String getDateInFormat(Long deviceCreatedDate) {
        String dateStringFormat = "";
        if (deviceCreatedDate == null || deviceCreatedDate == 0L) {
            return dateStringFormat;
        }
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            Date dateD = new Date(deviceCreatedDate);
            dateStringFormat = df2.format(dateD);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateStringFormat;
    }

    private static long getTime(String strdate) {
        if (StringUtils.isEmpty((String)strdate)) {
            return 0L;
        }
        long milliseconds = 0L;
        SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        try {
            Date d = f.parse(strdate);
            milliseconds = d.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return milliseconds;
    }

    private static long getFirstBkpStartTime(BackupOverviewElement backupOverviewElement) {
        long firstBkpEndTime;
        long firstBkpStartTime = DeviceBackupOverviewServiceImpl.getTime((String)backupOverviewElement.getFirstBkpStartTime());
        if (StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpEndTime()) && firstBkpStartTime > (firstBkpEndTime = DeviceBackupOverviewServiceImpl.getTime((String)backupOverviewElement.getFirstBkpEndTime()))) {
            firstBkpStartTime = firstBkpEndTime - 0x6DDD00L;
        }
        return firstBkpStartTime;
    }

    private static String getFirstBkpCompletedState(boolean isFirstBkpCompleted) {
        String firstBkpCompleted = isFirstBkpCompleted ? "Y" : "N";
        return firstBkpCompleted;
    }

    private static String getDeviceActiveState(BackupOverviewElement backupOverviewElement, boolean isDeviceActive) {
        String deviceActive = backupOverviewElement.isDecoupled() ? "Decoupled" : (isDeviceActive && !StringUtils.isEmpty((String)backupOverviewElement.getDeviceName()) ? "Active" : (StringUtils.isEmpty((String)backupOverviewElement.getEpaInstallationDate()) ? "" : "Blocked"));
        return deviceActive;
    }

    private static String getTimeZoneShortFormat(long milliSeonds) {
        TimeZone toTimeZone = TimeZone.getDefault();
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date resultdate = new Date(milliSeonds);
        String displayName = toTimeZone.getDisplayName(false, 0);
        return sdf.format(resultdate) + " " + displayName;
    }

    private static long getLongValue(String deviceCreatedDate) {
        if (!StringUtils.isNumeric((String)deviceCreatedDate)) {
            return 0L;
        }
        return Long.parseLong(deviceCreatedDate);
    }

    private static BackupOverviewElement getOverviewElement(Row row) {
        BackupOverviewElement backupOverviewElement = new BackupOverviewElement();
        backupOverviewElement.setUserId(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(0)));
        backupOverviewElement.setEmailId(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(1)));
        backupOverviewElement.setUserActive(DeviceBackupOverviewServiceImpl.getBooleanValue((Cell)row.getCell(2)));
        backupOverviewElement.setDeviceName(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(3)));
        backupOverviewElement.setDeviceActive(DeviceBackupOverviewServiceImpl.getBooleanValue((Cell)row.getCell(4)));
        backupOverviewElement.setEpaInstallationDate(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(5)));
        backupOverviewElement.setOsType(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(6)));
        backupOverviewElement.setClientVersion(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(7)));
        backupOverviewElement.setPolicyName(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(8)));
        backupOverviewElement.setFirstBkpStartTime(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(9)));
        backupOverviewElement.setFirstBkpEndTime(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(10)));
        backupOverviewElement.setFirstBackupCompleted(DeviceBackupOverviewServiceImpl.getBooleanValue((Cell)row.getCell(11)));
        backupOverviewElement.setLastBkpStartTime(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(12)));
        backupOverviewElement.setLastBkpEndTime(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(13)));
        backupOverviewElement.setLastBackupCompleted(DeviceBackupOverviewServiceImpl.getBooleanValue((Cell)row.getCell(14)));
        backupOverviewElement.setCurrentBkpStartTime(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(15)));
        backupOverviewElement.setCurrentBkpStatus(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(16)));
        backupOverviewElement.setCurrentBkpCompletionPct(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(17)));
        backupOverviewElement.setBkpRunning(DeviceBackupOverviewServiceImpl.getBooleanValue((Cell)row.getCell(18)));
        backupOverviewElement.setLastHeardTime(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(19)));
        backupOverviewElement.setStorageUtilized(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(20)));
        backupOverviewElement.setReason(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(21)));
        backupOverviewElement.setDisplayName(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(22)));
        backupOverviewElement.setLocation(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(23)));
        backupOverviewElement.setDepartment(DeviceBackupOverviewServiceImpl.getStringValue((Cell)row.getCell(24)));
        backupOverviewElement.setAccountStatus(DeviceBackupOverviewServiceImpl.getBooleanValue((Cell)row.getCell(25)));
        return backupOverviewElement;
    }

    private static int getPercentageCompleted(BackupOverviewElement backupOverviewElement) {
        int totalNoOfFiles = 0;
        int noOfFilesRemaining = 0;
        if (!StringUtils.isEmpty((String)backupOverviewElement.getTotalNoOfFiles())) {
            totalNoOfFiles = Integer.parseInt(backupOverviewElement.getTotalNoOfFiles());
        }
        if (!StringUtils.isEmpty((String)backupOverviewElement.getNoOfFilesRemaining())) {
            noOfFilesRemaining = Integer.parseInt(backupOverviewElement.getNoOfFilesRemaining());
        }
        int filesBackedup = totalNoOfFiles - noOfFilesRemaining;
        int percentage = 100;
        if (totalNoOfFiles != 0) {
            percentage = filesBackedup * 100 / totalNoOfFiles;
        }
        return percentage;
    }

    private static String getStringValue(Cell cell) {
        String val = "";
        if (cell != null) {
            val = cell.toString();
        }
        return val;
    }

    private static Date getDate(String currentBkpStarted) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date yourDate = format.parse(currentBkpStarted);
        yourDate.setHours(0);
        yourDate.setMinutes(0);
        return yourDate;
    }

    private static boolean getBooleanValue(Cell cell) {
        String value;
        boolean val = false;
        if (cell != null && (value = cell.toString()) != null && (value.equalsIgnoreCase("active") || value.equalsIgnoreCase("y"))) {
            val = true;
        }
        return val;
    }
}

