#!/bin/bash
PARABLU_PATH=/parablu
PARABLU_LOG_ARCHIVE_PATH=$PARABLU_PATH/archive
PARABLU_BKP_ARCHIVE_PATH=$PARABLU_PATH/bkparchice
YESTERDAY_DATE=$(date -d "1 day ago" '+%Y-%m-%d')
DAYBEFORE_YESTERDAY_DATE=$(date -d "10 day ago" '+%Y-%m-%d')
if [ ! -d "$PARABLU_BKP_ARCHIVE_PATH" ];
then
        mkdir -p $PARABLU_BKP_ARCHIVE_PATH 2>&1
fi
rm -rf $PARABLU_BKP_ARCHIVE_PATH/$DAYBEFORE_YESTERDAY_DATE*
if [[ -d $PARABLU_BKP_ARCHIVE_PATH/$YESTERDAY_DATE ]]; then
        YESTERDAY_DATE_WITHTIME="$YESTERDAY_DATE-$(date +"%T")"
        mkdir $PARABLU_BKP_ARCHIVE_PATH/$YESTERDAY_DATE_WITHTIME
        mv $PARABLU_LOG_ARCHIVE_PATH/mongodb $PARABLU_BKP_ARCHIVE_PATH/$YESTERDAY_DATE_WITHTIME/
        mv $PARABLU_LOG_ARCHIVE_PATH/tomcat-job1 $PARABLU_BKP_ARCHIVE_PATH/$YESTERDAY_DATE_WITHTIME/
        mv $PARABLU_LOG_ARCHIVE_PATH/tomcat-pcb1 $PARABLU_BKP_ARCHIVE_PATH/$YESTERDAY_DATE_WITHTIME/
        mv $PARABLU_LOG_ARCHIVE_PATH/portal $PARABLU_BKP_ARCHIVE_PATH/$YESTERDAY_DATE_WITHTIME/
else
        mkdir $PARABLU_BKP_ARCHIVE_PATH/$YESTERDAY_DATE
        mv $PARABLU_LOG_ARCHIVE_PATH/mongodb $PARABLU_BKP_ARCHIVE_PATH/$YESTERDAY_DATE_WITHTIME/
        mv $PARABLU_LOG_ARCHIVE_PATH/tomcat-job1 $PARABLU_BKP_ARCHIVE_PATH/$YESTERDAY_DATE_WITHTIME/
        mv $PARABLU_LOG_ARCHIVE_PATH/tomcat-pcb1 $PARABLU_BKP_ARCHIVE_PATH/$YESTERDAY_DATE_WITHTIME/
        mv $PARABLU_LOG_ARCHIVE_PATH/portal $PARABLU_BKP_ARCHIVE_PATH/$YESTERDAY_DATE_WITHTIME/
fi
mkdir $PARABLU_LOG_ARCHIVE_PATH/mongodb
mkdir $PARABLU_LOG_ARCHIVE_PATH/tomcat-job1
mkdir $PARABLU_LOG_ARCHIVE_PATH/tomcat-pcb1
mkdir $PARABLU_LOG_ARCHIVE_PATH/portal
chown -R tomcat:tomcat $PARABLU_LOG_ARCHIVE_PATH/tomcat-job1
chown -R tomcat:tomcat $PARABLU_LOG_ARCHIVE_PATH/tomcat-pcb1
chown -R mongodb:mongodb $PARABLU_LOG_ARCHIVE_PATH/mongodb
