#!/bin/bash
#by rSuresh
source ./conf.sh 2>&1
source ./defaultConf.sh
source ./onlyFunction.sh

service couchdb stop
service memcached stop
service tomcat-pcb1 stop
service tomcat-job1 stop
service apache2 stop

#Cloud_details
case $STORAGE_TYPE in
	Local_B) serverstatus "parablu_tables_B_L" "parablu001_tables_B" ;;
	Local_S) serverstatus "parablu_tables_S_L" "parablu001_tables_S" ;;
	Local_BS) serverstatus "parablu_tables_B_S_L" "parablu001_tables_BS" ;;
	Azure_B) serverstatus "parablu_tables_B_A" "parablu001_tables_B" ;;
	Azure_S) serverstatus "parablu_tables_S_A" "parablu001_tables_S" ;;
	Azure_BS) serverstatus "parablu_tables_B_S_A" "parablu001_tables_BS" ;;
	OD4B_B) serverstatus "parablu_tables_B_O" "parablu001_tables_B" ;;
	OD4B_S) serverstatus "parablu_tables_S_O" "parablu001_tables_S" ;;
	OD4B_BS) serverstatus "parablu_tables_B_S_O" "parablu001_tables_BS" ;;
	Local_SR) serverstatus "parablu_tables_SR_L" "parablu001_tables_SR" ;;
	Azure_SR) serverstatus "parablu_tables_SR_A" "parablu001_tables_SR" ;;
	OD4B_SR) serverstatus "parablu_tables_SR_O" "parablu001_tables_SR" ;;
esac

sleep 15
export LC_ALL=C
#Mongo Scripts for user / pwd creation
mongo admin ./auth_mongo.js
#in support table
mongo support ./support_tables.js

sed -i "s|bind_ip.*|bind_ip = $DB1_IP|" /etc/mongod.conf
# sed -i "s|port.*|port = $MONGODB_PORT|" /etc/mongod.conf

if [[ $REP_ENB = "yes" ]]; then
	#Replication
	./replica_enable.sh
fi

#IPtable redirection
./iptable_redirection.sh