#!/bin/bash
#                                                                                       #
# SCRIPT: mongo_restore.sh                                                             #
# DATE:   13-May-2019                                                                  #
# REV:    2.4                                                                           #
# DEVELOPED BY: Parablu Systems                                                         #
# DEVELOPER: Vaibhav K

dbport=$(grep port: /etc/mongod.conf)
MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')

tput clear
echo "                          <===================================== MONGO RESTORE ================================>"
        tput cup 7 15
        echo "ENVIRONMENT TYPE:"

        tput cup 10 20
        echo "1.  PRODUCTION"
        tput cup 11 20
        echo "2.  POC" 
	tput cup 12 20
        echo "3.  STAGING" 
        tput cup 14 20
        echo "Enter your choice number:"
        tput cup 14 50
        read env_type




	tput clear
        tput cup 7 15
        echo "MONGO DUMP LOCATION:"
	tput cup 10 20
        echo "EXAMPLE: [ parablu/backup/mongodb/20190510 ]"
	tput cup 13 20
        echo "Enter Directory Path:"
	tput cup 13 42
	read mng_dir

	mongorestore --username=neil --password=parablu $mng_dir
	if [ $? -eq 0 ];
	then 
		echo "##################################################
#                                                #
#      MONGO BACKUP RESTORED SUCCESSFULLY        #
#                                                #
##################################################"
		if [ $env_type == 3 ]; then
			echo "use parablu

db.SMTP_CREDENTIALS.drop()" > drop_smtp.js
        		sudo mongo localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < drop_smtp.js >> smtp_drop.log
        		sleep 1s
        		rm drop_smtp.js
		fi
	else
		echo "##################################################
#                                                #
#       MONGO BACKUP RESTORE FAILED              #
#                                                #
##################################################"
	fi
