#!/bin/bash
# DEVELOPER: Vaibhav K

PARABLU_CONFIG_SCRIPT_PATH=/parablu/parablu-scripts/Installable/config/parablu_config.sh
PARABLU_COMPONENT_SCRIPT_PATH=/parablu/parablu-scripts/Installable/config/parablu_component_config.sh
source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_COMPONENT_SCRIPT_PATH

export PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:$PATH"

# Functions
setVariables () {

	# Username to access the mongo server e.g. dbuser. Unnecessary if authentication is off
	DBUSERNAME="neil"

	# Password to access the mongo server e.g. password. Unnecessary if authentication is off
	DBPASSWORD="parablu"

	# Database for authentication to the mongo server e.g. admin. Unnecessary if authentication is off
	DBAUTHDB="admin"

	# Host name (or IP address) of mongo server e.g localhost
	DBHOST="$1" 

	# Port that mongo is listening on
	dbport=$(grep port: /etc/mongod.conf)
        DBPORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')


	# Allow DBUSERNAME without DBAUTHDB
	REQUIREDBAUTHDB="no"

	# OPT string for use with mongodump
	OPT=""                                            

	# Use oplog for point-in-time snapshotting.
	OPLOG="no"

	### Take value from Database
	echo 'use parablu001

db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_BKDIR=" +e.backupdir)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_ACHDIR=" +e.archivedir)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_BKID=" +e.backblaze_id)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_APPKEY=" +e.application_key)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_BUCKET=" +e.backblaze_bucket)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_CUSTNAME=" +e.customer_name)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_BKBACKUP=" +e.backblaze_backup)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_ENCBKP=" +e.encrypt_backup)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_USERNAME=" +e.proxyUserName)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_PORT=" +e.proxyPort)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_HOST=" +e.proxyHost)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_PASSWORD=" +e.proxyPassword)})' >mongoproperties.js

	cp mongoproperties.js mongoproperties_install.js
	sudo mongo localhost:$DBPORT -u "neil" -p "parablu" --authenticationDatabase "admin" < mongoproperties_install.js > mongo_properties

	BACKUPDIR_VAL=$(grep "P_BKDIR" mongo_properties | sed -e 's/P_BKDIR=//')
	ARCHIVEDIR_VAL=$(grep "P_ACHDIR" mongo_properties | sed -e 's/P_ACHDIR=//')
	BACKBLAZE_ID_VAL=$(grep "P_BKID" mongo_properties | sed -e 's/P_BKID=//')
	APPLICATION_KEY_VAL=$(grep "P_APPKEY" mongo_properties | sed -e 's/P_APPKEY=//')
	BACKBLAZE_BUCKET_VAL=$(grep "P_BUCKET" mongo_properties | sed -e 's/P_BUCKET=//')
	CLOUD_NAME_VAL=$(grep "P_CUSTNAME" mongo_properties | sed -e 's/P_CUSTNAME=//')
	BACKBLAZE_BACKUP_VAL=$(grep "P_BKBACKUP" mongo_properties | sed -e 's/P_BKBACKUP=//')
	ENCRYPT_BACKUP_VAL=$(grep "P_ENCBKP" mongo_properties | sed -e 's/P_ENCBKP=//')
	

	if [ "$BACKUPDIR_VAL" == "undefined" ]; then

                BACKUPDIR="/parablu/backup/mongodb"

        elif [ ! -z "$BACKUPDIR_VAL" ]; then

                BACKUPDIR=$BACKUPDIR_VAL

        else

                BACKUPDIR="/parablu/backup/mongodb"

        fi

        if [ "$ARCHIVEDIR_VAL" == "undefined" ]; then

                ARCHIVEDIR="/parablu/archive/mongodb_backup"

        elif [ ! -z "$ARCHIVEDIR_VAL" ]; then

                ARCHIVEDIR=$ARCHIVEDIR_VAL

        else

                ARCHIVEDIR="/parablu/archive/mongodb_backup"

        fi

	if [ "$BACKBLAZE_ID_VAL" == "undefined" ]; then

                BACKBLAZE_ID="43fee37666d9"

        elif [ ! -z "$BACKBLAZE_ID_VAL" ]; then

                BACKBLAZE_ID=$BACKBLAZE_ID_VAL

        else

                BACKBLAZE_ID="43fee37666d9"

        fi


	if [ "$APPLICATION_KEY_VAL" == "undefined" ]; then

	decrypt_key=$(java -jar /parablu-scripts/Installable/scripts/EncryptAndDecypt.jar dec MDAwMGZmMmYxMjJjMTUzZmYzYzU2NGVlOGQxZDhmNjA0ZjAzYjQ0NDEy)
                decrypt_key_val=$(echo $decrypt_key | sed -e 's/Result=//')
                APPLICATION_KEY="$decrypt_key_val"

        elif [ ! -z "$APPLICATION_KEY_VAL" ]; then
                decrypt_key=$(java -jar /parablu-scripts/Installable/scripts/EncryptAndDecypt.jar dec $APPLICATION_KEY_VAL)
                decrypt_key_val=$(echo $decrypt_key | sed -e 's/Result=//')

                APPLICATION_KEY=$decrypt_key_val

        else

                decrypt_key=$(java -jar /parablu-scripts/Installable/scripts/EncryptAndDecypt.jar dec MDAwMGZmMmYxMjJjMTUzZmYzYzU2NGVlOGQxZDhmNjA0ZjAzYjQ0NDEy)
                decrypt_key_val=$(echo $decrypt_key | sed -e 's/Result=//')
                APPLICATION_KEY="$decrypt_key_val"

        fi

	if [ "$BACKBLAZE_BUCKET_VAL" == "undefined" ]; then

                BACKBLAZE_BUCKET="CUST-Mongodbbackups"

        elif [ ! -z "$BACKBLAZE_BUCKET_VAL" ]; then

                BACKBLAZE_BUCKET=$BACKBLAZE_BUCKET_VAL

        else

                BACKBLAZE_BUCKET="CUST-Mongodbbackups"

        fi

        if [ "$CLOUD_NAME_VAL" == "undefined" ]; then

                CLOUD_NAME="$CLOUD_NAME"

        elif [ ! -z "$CLOUD_NAME_VAL" ]; then

                CLOUD_NAME=$CLOUD_NAME_VAL

        else

                CLOUD_NAME="$CLOUD_NAME"

        fi

	if [ "$BACKBLAZE_BACKUP_VAL" == "undefined" ]; then

                BACKBLAZE_BACKUP="no"

        elif [ ! -z "$BACKBLAZE_BACKUP_VAL" ]; then

                BACKBLAZE_BACKUP=$BACKBLAZE_BACKUP_VAL

        else

                BACKBLAZE_BACKUP="no"

        fi

        if [ "$ENCRYPT_BACKUP_VAL" == "undefined" ]; then

                ENCRYPT_BACKUP="yes"

        elif [ ! -z "$ENCRYPT_BACKUP_VAL" ]; then

                ENCRYPT_BACKUP=$ENCRYPT_BACKUP_VAL

        else

                ENCRYPT_BACKUP="yes"

        fi

	max_attempts=7
	timeout=1
	attempt=1
	exitCode=0

	echo 'use parablu
db.CLOUD_PROPERTIES.find({"cloudType" : "enterprise"}).forEach(function(e){print("ENCRYPTPASSWORD=" +e.dbBackupPassword)});' >encrypt_password.js

        sudo mongo localhost:$DBPORT -u "neil" -p "parablu" --authenticationDatabase "admin" < encrypt_password.js >encryptpassword.log
        DB_ENCRYPT_PASSWORD=`grep "ENCRYPTPASSWORD" encryptpassword.log`
        DB_ENCRYPT_PASSWORD_VAL=$( echo $DB_ENCRYPT_PASSWORD | sed -e 's/ENCRYPTPASSWORD=//')
        if [ "$DB_ENCRYPT_PASSWORD_VAL" == "undefined" ]; then

                ENCRYPT_PASSPHRASE="$CLOUD_NAME-@#*7#87^t"

        elif [ ! -z "$DB_ENCRYPT_PASSWORD_VAL" ]; then

                ENCRYPT_PASSPHRASE=$DB_ENCRYPT_PASSWORD_VAL

        else

                ENCRYPT_PASSPHRASE="$CLOUD_NAME-@#*7#87^t"



        fi


        MONGO_ZIP_FILE="$CLOUD_NAME-`date '+%Y%m%d'`.zip"

	MONGO_ENCRYPTED_FILE="$CLOUD_NAME-`date '+%Y%m%d'`.gpg"

	# Do we need to use a username/password?
	if [ "$DBUSERNAME" ]; then
    		OPT="$OPT --username=$DBUSERNAME --password=$DBPASSWORD"
    		if [ "$REQUIREDBAUTHDB" = "yes" ]; then
        		OPT="$OPT --authenticationDatabase=$DBAUTHDB"
    		fi
	fi

	# Do we use oplog for point-in-time snapshotting?
	if [ "$OPLOG" = "yes" ]; then
    		OPT="$OPT --oplog"
	fi
}

function get_support_mail ()
{

unset MAILARRAY
echo 'use parablu
db.CLOUD_PROPERTIES.find({}).forEach(function(e){print("SUPPORT_MAIL=" +e.supportMail)})' > supportmailids.js

        sudo mongo localhost:$DBPORT -u "neil" -p "parablu" --authenticationDatabase "admin" < supportmailids.js >supportmailid.log

        WATCHDOG_MAIL_ADDRESS=`grep "SUPPORT_MAIL" supportmailid.log | sed -e 's/SUPPORT_MAIL=//' | sed -e 's/,/\ /g'`

        if [[ -z $WATCHDOG_MAIL_ADDRESS ]]; then

                WATCHDOG_MAIL_ADDRESS="support@parablu.com"
        fi
for mail_id in ${WATCHDOG_MAIL_ADDRESS[@]}
                do
                        MAILARRAY+=({\"email\":\"$mail_id\"},)
        done


        tempids=$(echo -e "${MAILARRAY[*]}")
        get_mail_id=$(echo $tempids | sed -e 's/.$//')


}

function send_backpfail_alert ()
{

        ##Get mail ids
        get_support_mail

        MSG_SUBJECT="ALERT: MONGO BACKUP DUMP FAILURE [$CLOUD_NAME] Machine `hostname` at `date`"
        MSG_BODY="MONGO BACKUP FAILED"
        if [ "$SERVER_TYPE" == "3" ]; then
                scp -P $SSH_PORT /parablu/log/mongodb/full.log $SSH_USERNAME@$PARAMAIL_MACHINE:/parablu-scripts/Installable/scripts/
                sleep 5s

                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyData":"'"${MSG_BODY}"'","subjectData":"'"${MSG_SUBJECT}"'","recipents":['"${get_mail_id}"'], "attachmentFilePaths":"/parablu-scripts/Installable/scripts/full.log"}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
                sleep 5s
                ssh -p $SSH_PORT $SSH_USERNAME@$PARAMAIL_MACHINE  "cd /parablu-scripts/Installable/scripts/ && rm full.log"

        else
                curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyData":"'"${MSG_BODY}"'","subjectData":"'"${MSG_SUBJECT}"'","recipents":['"${get_mail_id}"'], "attachmentFilePaths":"/parablu/log/mongodb/full.log"}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
        fi


}

# Database dump function
dbdump () {
	setVariables "localhost"
	echo
	echo Backup of Database Server - on $DBHOST 
	echo ======================================================================

	echo Backup Start `date`
	echo ======================================================================

	mkdir -p $BACKUPDIR
	mkdir -p $ARCHIVEDIR
	DEFAULT_FOLDER=$BACKUPDIR/`hostname`
	TIMESTAMP_FOLDER=$DEFAULT_FOLDER/`date '+%Y%m%d'`
	MONGOBACKUP_FOLDER=$TIMESTAMP_FOLDER/DB
	FILES_BACKUP=$TIMESTAMP_FOLDER/FILES
	rm -rf $DEFAULT_FOLDER
	mkdir -p $MONGOBACKUP_FOLDER
	mkdir -p $FILES_BACKUP
echo "Starting backup------"
    	mongodump --host=$DBHOST:$DBPORT --out=$MONGOBACKUP_FOLDER $OPT |& tee /parablu/log/mongodb/full.log
	if [ ${PIPESTATUS[0]} -ne 0 ] ; then
                echo "MongoDump Failed" >> /parablu/mongo_backup_status
		send_backpfail_alert
                return 0
        fi

    	if [ ! -e "$MONGOBACKUP_FOLDER" ] ; then 
		echo "MongoDump Failed" >> /parablu/mongo_backup_status
		send_backpfail_alert
		return 0
	fi
	echo ----------------------------------------------------------------------
	echo Backup End Time `date`
	echo ======================================================================
	echo "MONGO BACKUP 
LAST BACKEDUP FILE : "$BACKUPDIR/$MONGO_ZIP_FILE" 
LAST BACKEDUP DATE: `date`" >> /parablu/mongo_backup_status
	check_proxy
	files_folder_backup
	zip -r $BACKUPDIR/$MONGO_ZIP_FILE $DEFAULT_FOLDER
	#if [ "$SERVER_TYPE" == "3" ]; then
	#	get_remote_files
	#fi
	sleep 2s
        rm -rf $DEFAULT_FOLDER
    	cd $BACKUPDIR
        echo "Moving old Backups to archive...."
        for i in `find . -mtime +1`; do
                echo -e "Archiving Backup Folder $i";
                mv $i $ARCHIVEDIR
                #tar -cf $ARCHIVEDIR/$i.tar -C $ARCHIVEDIR $i;
                #rm -rf $ARCHIVEDIR/$i
        done
        cd $ARCHIVEDIR
        ls -t | find . -mtime +3 | xargs -d '\n' rm
	if [ "$EXTERNAL_bACKUP" = "yes" ]; then
                ssh -p $EXTERNAL_DB_SSH_PORT $EXTERNAL_DB_SSH_USER@$EXTERNAL_DB_IP "mkdir -p $EXTERNAL_DB_PATH"
                scp -r $FOLDER $EXTERNAL_DB_SSH_USER@$EXTERNAL_DB_IP:$EXTERNAL_DB_PATH
        fi
	if [ "$BACKBLAZE_BACKUP" = "yes" ]; then
                if [ "$ENCRYPT_BACKUP" = "yes" ]; then

			 echo "STARTING BACKBLAZE BACKUP" |& tee -a /parablu/log/mongodb/full.log

                 #       zip -r $MONGO_ZIP_FILE $FOLDER
                        gpg -c --batch --passphrase $ENCRYPT_PASSPHRASE -o $MONGO_ENCRYPTED_FILE $BACKUPDIR/$MONGO_ZIP_FILE
			###new logic
			while [[ $attempt < $max_attempts ]]
			do
			      backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY |& tee -a /parablu/log/mongodb/full.log
			      backblaze-b2 upload-file  $BACKBLAZE_BUCKET $MONGO_ENCRYPTED_FILE $CLOUD_NAME/$MONGO_ENCRYPTED_FILE |& tee -a /parablu/log/mongodb/full.log
			      exitCode=${PIPESTATUS[0]}

			      if [[ $exitCode == 0 ]]
			      then
				        break
			      fi
			      echo "RETRY COUNT: $attempt" |& tee -a /parablu/log/mongodb/full.log
			      echo "FAILURE!! Retrying in $timeout.. MINUTE" |& tee -a /parablu/log/mongodb/full.log
			      sleep ${timeout}m
			      attempt=$(( attempt + 1 ))
			      timeout=$(( timeout * 2 ))
		        done

		       if [[ $exitCode != 0 ]]
		       then
			      echo "FAILED AFTER 6 ATTEMPTS....!!" |& tee -a /parablu/log/mongodb/full.log
			      ##Get mail ids
                              get_support_mail

                              MSG_SUBJECT="ALERT: MONGO BACKUP BACKBLAZE UPLOAD FAILURE [$CLOUD_NAME] Machine `hostname` at `date`"
                              MSG_BODY="MONGO BACKUP BACKBLAZE UPLOAD FAILED"
                              if [ "$SERVER_TYPE" == "3" ]; then
                                    scp -P $SSH_PORT /parablu/log/mongodb/full.log $SSH_USERNAME@$PARAMAIL_MACHINE:/parablu-scripts/Installable/scripts/
                                    sleep 5s

                                    curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyData":"'"${MSG_BODY}"'","subjectData":"'"${MSG_SUBJECT}"'","recipents":['"${get_mail_id}"'], "attachmentFilePaths":"/parablu-scripts/Installable/scripts/full.log"}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
                                    sleep 5s
                                    ssh -p $SSH_PORT $SSH_USERNAME@$PARAMAIL_MACHINE  "cd /parablu-scripts/Installable/scripts/ && rm full.log"
                              else
                                    curl -k -X PUT -H "Content-Type: application/json" -d '{"bodyData":"'"${MSG_BODY}"'","subjectData":"'"${MSG_SUBJECT}"'","recipents":['"${get_mail_id}"'], "attachmentFilePaths":"/parablu/log/mongodb/full.log"}' https://$PARAMAIL_MACHINE/paramail/send/customMail/
                               fi

		       fi
			

                else
                  #      zip -r $MONGO_ZIP_FILE $FOLDER
                        backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY
                        backblaze-b2 upload-file  $BACKBLAZE_BUCKET $BACKUPDIR/$MONGO_ZIP_FILE $CLOUD_NAME/$MONGO_ZIP_FILE
			if [ $? -ne 0 ]; then
				sleep 20s
				backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY
	                        backblaze-b2 upload-file  $BACKBLAZE_BUCKET $BACKUPDIR/$MONGO_ZIP_FILE $CLOUD_NAME/$MONGO_ZIP_FILE
			fi
                fi

		sleep 2s
                rm -rf $MONGO_ZIP_FILE
		rm -rf $MONGO_ENCRYPTED_FILE
		rm -rf $ARCHIVEDIR/*
        fi
    	return 1
}
function files_folder_backup ()
{
	cp -r --parents /var/lib/tomcat-pcb1/webapps/BluKryptBuilder/WEB-INF/classes/privacygateway.properties $FILES_BACKUP
	cp -r --parents /var/lib/tomcat-job1/webapps/BluKryptJob/WEB-INF/classes/privacygateway.properties $FILES_BACKUP
	cp -r --parents /var/lib/tomcat-job1/webapps/BluKryptJob/WEB-INF/classes/spring-config/scheduler-context.xml $FILES_BACKUP
	cp -r --parents /var/lib/tomcat-job1/webapps/paracloudjob/WEB-INF/classes/spring-config/scheduler-context.xml $FILES_BACKUP
	cp -r --parents /var/lib/tomcat-job1/webapps/paracloudjob/WEB-INF/classes/spring-config/security-broker-scheduler-context.xml $FILES_BACKUP
	cp -r --parents /var/lib/tomcat-job1/webapps/paracloudjob/WEB-INF/classes/pb-credential.properties $FILES_BACKUP
	cp -r --parents /var/www/portal/app/Core/Config.php $FILES_BACKUP
	cp -r --parents /etc/apache2/sites-enabled/default-ssl.conf $FILES_BACKUP

	cp -r --parents /var/lib/parablusys/conf $FILES_BACKUP
	cp -r --parents /var/lib/parablusys/upgrade $FILES_BACKUP
	cp -r --parents /var/lib/parablusys/clients $FILES_BACKUP

}

function get_ip_list ()
{
echo 'use parablu001
db.PRIVACY_GATEWAY.distinct("gatewayName")

db.BLUVAULT.distinct("bluVaultName");' >iplist.js

        sudo mongo localhost:$DBPORT -u "neil" -p "parablu" --authenticationDatabase "admin" < iplist.js >iplist.log

        grep '"' iplist.log | sed -e 's/\[//' | sed -e 's/\]//' | sed -e 's/"//g' | sed -e 's/,//g'  >sorted_iplist.log
	sed -i "/Implicit/d" sorted_iplist.log
        final_iplist=`cat sorted_iplist.log`
        OTHER_WATCHDOG_IP=$(echo "$final_iplist" | xargs -n1 | sort -u | xargs)

}


function consolidate_remote_files ()
{
        cur_dir=`pwd`
        mkdir -p prop_backup
        cd prop_backup
        cp -r --parents /var/lib/tomcat-pcb1/webapps/BluKryptBuilder/WEB-INF/classes/privacygateway.properties .
        cp -r --parents /var/lib/tomcat-job1/webapps/BluKryptJob/WEB-INF/classes/privacygateway.properties .
        cp -r --parents /var/lib/tomcat-job1/webapps/BluKryptJob/WEB-INF/classes/spring-config/scheduler-context.xml .
        cp -r --parents /var/lib/tomcat-job1/webapps/paracloudjob/WEB-INF/classes/spring-config/scheduler-context.xml .
        cp -r --parents /var/lib/tomcat-job1/webapps/paracloudjob/WEB-INF/classes/spring-config/security-broker-scheduler-context.xml .
        cp -r --parents /var/lib/tomcat-job1/webapps/paracloudjob/WEB-INF/classes/pb-credential.properties .
        cp -r --parents /var/www/portal/app/Core/Config.php .
        cp -r --parents /etc/apache2/sites-enabled/default-ssl.conf .

        cp -r --parents /var/lib/parablusys/conf .
        cp -r --parents /var/lib/parablusys/upgrade .
        cp -r --parents /var/lib/parablusys/clients .
        cd $cur_dir

        zip -r prop_backup.zip prop_backup
        rm -rf prop_backup
}

function get_remote_files ()
{
        get_ip_list
        for ping_ip in ${OTHER_WATCHDOG_IP[@]}
        do

                mkdir -p $BACKUPDIR/$ping_ip
                cd $BACKUPDIR/$ping_ip
                ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "$(typeset -f consolidate_remote_files); consolidate_remote_files"
                scp -r -P $SSH_PORT $SSH_USERNAME@$ping_ip:~/prop_backup.zip .
                ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "rm -rf ~/prop_backup.zip"
		cd ..
		zip -r $BACKUPDIR/$MONGO_ZIP_FILE  $ping_ip
		rm -rf $ping_ip
        done
}

function check_proxy ()
{
        echo 'use parablu001

db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_USERNAME=" +e.proxyUserName)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_PORT=" +e.proxyPort)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_HOST=" +e.proxyHost)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_PASSWORD=" +e.proxyPassword)})' >proxy_details.js

        cp proxy_details.js newproxy_details.js
        sleep 1s
        sed -i "s|GATEWAY_NAME|$BLUKRYPT_IP|g" newproxy_details.js

        sudo mongo localhost:$DBPORT -u "neil" -p "parablu" --authenticationDatabase "admin" < newproxy_details.js > proxy_details

        PY_UNAME=$(grep "P_USERNAME" proxy_details | sed -e 's/P_USERNAME=//')
        PY_PORT=$(grep "P_PORT" proxy_details | sed -e 's/P_PORT=//')
        PY_HOST=$(grep "P_HOST" proxy_details | sed -e 's/P_HOST=//')
        PY_PASSWORD=$(grep "P_PASSWORD" proxy_details | sed -e 's/P_PASSWORD=//')

        if [[ ! -z $PY_UNAME ]] && [[ ! -z $PY_PORT ]] && [[ ! -z $PY_HOST ]] && [[ ! -z $PY_PASSWORD ]]; then

                echo "PROXY ENABLED"
                PROXY_URL="https_proxy=\"https://$PY_UNAME:$PY_PASSWORD@$PY_HOST:$PY_PORT\""
                #export $PROXY_URL
		export https_proxy="https://$PY_UNAME:$PY_PASSWORD@$PY_HOST:$PY_PORT"
        else
                echo "Proxy DISABLED"
        fi

}

rm -rf /parablu/mongo_backup_status*
dbdump 

exit $STATUS
