#!/bin/bash

# DATE:   14-Sep-2019                                                                   #
# REV:    2.0                                                                           #
# DEVELOPED BY: Parablu Systems                                                         #
# DEVELOPER: VAIBHAV K                                                                  #
# PLATFORM: Ubuntu

PARABLU_COMPONENT_SCRIPT_PATH=../../config/parablu_component_config.sh
PARABLU_CONFIG_SCRIPT_PATH=../../config/parablu_config.sh

source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_CONFIG_SCRIPT_PATH

##Get Support mail IDs from Database
function get_supportmail ()
{
	unset MAILARRAY

	if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "3" ]; then
		dbport=$(grep port: /etc/mongod.conf)
		MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')
	fi

	echo 'use parablu
db.CLOUD_PROPERTIES.find({}).forEach(function(e){print("SUPPORT_MAIL=" +e.supportMail)})' > supportmailids.js

	sudo mongo $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < supportmailids.js >supportmailid.log

	WATCHDOG_MAIL_ADDRESS=`grep "SUPPORT_MAIL" supportmailid.log | sed -e 's/SUPPORT_MAIL=//' | sed -e 's/,/\ /g'`

	if [[ -z $WATCHDOG_MAIL_ADDRESS ]]; then

        	WATCHDOG_MAIL_ADDRESS="support@parablu.com"
	fi

	for mail_id in ${WATCHDOG_MAIL_ADDRESS[@]}
        do
	        MAILARRAY+=({\"email\":\"$mail_id\"},)
	done


        tempids=$(echo -e "${MAILARRAY[*]}")
        get_mail_id=$(echo $tempids | sed -e 's/.$//')

}

function get_paracloud_url ()
{


echo 'use parablu001
db.BLUVAULT_PROPERTIES.find({}).forEach(function(e){print( "PARACLOUD_URL="+e.componentsProperties.paracloudUrl)})' > pc_value.js

sleep 2s

                if [[ "$SERVER_TYPE" == "0" ]]; then
                        mgport=$(grep port: /etc/mongod.conf)
                        mg_PORT=$(echo $mgport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')
                        mongo_port=$mg_PORT


                elif [[ "$SERVER_TYPE" == "1" ]]; then

                        mongo_port=$MONGODB_PORT


                elif [[ "$SERVER_TYPE" == "2" ]]; then

                        mongo_port=$MONGODB_PORT


                elif [[ "$SERVER_TYPE" == "3" ]]; then

                        mgport=$(grep port: /etc/mongod.conf)
                        mg_PORT=$(echo $mgport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')
                        mongo_port=$mg_PORT


                elif [[ "$SERVER_TYPE" == "6" ]]; then
			
			mongo_port=$MONGODB_PORT


                elif [[ "$SERVER_TYPE" == "1 2" ]]; then

                        mongo_port=$MONGODB_PORT


                elif [[ "$SERVER_TYPE" == "3 1" ]]; then

                        mgport=$(grep port: /etc/mongod.conf)
                        mg_PORT=$(echo $mgport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')
                        mongo_port=$mg_PORT


                fi

sudo mongo $DB1_IP:$mongo_port -u "neil" -p "parablu" --authenticationDatabase "admin" < pc_value.js > pc_value.txt

PC_URL=$(grep "PARACLOUD_URL" pc_value.txt | sed -e 's/PARACLOUD_URL=//' | sed -e 's/http:\/\///' | sed -e 's/https:\/\///')

echo "PARACLOUD URL IS:$PC_URL"
PARAMAIL_MACHINE=$PC_URL
echo "PARAMAIL MACHINE:$PARAMAIL_MACHINE"
}
