#!/bin/bash
#                                                                                       #
# SCRIPT: blukrypt_service.sh		                                                #
# DATE:   27-Oct-2016                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems								#
# DEVELOPER: Vaibhav K
# PURPOSE: Contains all the utility functions for blukrypt Installation                 #
# PLATFORM: Ubuntu                                                                      #

TOMCAT_SERVICE_SCRIPT_PATH=./tomcat_service.sh
APACHE_SERVICE_SCRIPT_PATH=./apache_service.sh
#COUCHDB_SERVICE_SCRIPT_PATH=./couch_service.sh
#ACTIVEMQ_SERVICE_SCRIPT_PATH=./activemq_service.sh
UBUNTU_SERVICE_SCRIPT_PATH=./ubuntu_service.sh
PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh
PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh
MEMCACHED_SERVICE_SCRIPT_PATH=./memcached_service.sh
COMMON_SERVICE_SCRIPT_PATH=./common_service.sh
MONGO_SERVICE_SCRIPT_PATH=./mongo_service.sh
INSTALLABLES_SCRIPT_PATH=../installables

source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_COMPONENT_SCRIPT_PATH
source $UBUNTU_SERVICE_SCRIPT_PATH
source $TOMCAT_SERVICE_SCRIPT_PATH
#source $COUCHDB_SERVICE_SCRIPT_PATH
source $APACHE_SERVICE_SCRIPT_PATH
#source $ACTIVEMQ_SERVICE_SCRIPT_PATH
source $MEMCACHED_SERVICE_SCRIPT_PATH
source $COMMON_SERVICE_SCRIPT_PATH
source $MONGO_SERVICE_SCRIPT_PATH

# Deploy repo to tomcat
function deploy_blukrypt_repo_to_tomcat () 
{	
	#copy the config file for the path
	if [ ! -e $TOMCAT_PG1_PATH/conf/server.xml ] 
	then
		cp $TOMCAT_PATH/conf/server.xml $TOMCAT_PG1_PATH/conf/
	fi

	if [ ! -e $TOMCAT_PG1_PATH/conf/web.xml ] 
	then
		cp $TOMCAT_PATH/conf/web.xml $TOMCAT_PG1_PATH/conf/
	fi

	if [ ! -e $TOMCAT_PG1_PATH/conf/tomcat-users.xml ] 
	then
		cp $TOMCAT_PATH/conf/tomcat-users.xml $TOMCAT_PG1_PATH/conf/
	fi

	if [ ! -e $TOMCAT_PG1_PATH/solr ] 
	then
		cp -r $DEFAULT_FILE_PATH/solr $TOMCAT_PG1_PATH/
	fi
	
	if [[ $FILE_LOCATION == "jenkins" ]]; then
        	wget -P $TOMCAT_PG1_PATH/$PG_REPO_NAME/ $JENKINS_URL/$PG_JAR_URL_PATH
        elif [[ $FILE_LOCATION == "dns" ]]; then
                wget --user $DNS_USERNAME --password $DNS_PASS -O $TOMCAT_PG1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME $DNS_URL/$JOB_JAR_NAME
        elif [[ $FILE_LOCATION == "local" ]]; then
                #will be included in file path once repo is part of patch, so currently downloading from DNS
                 cp $FILE_PATH/$JOB_JAR_NAME $TOMCAT_PG1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME
               # wget --user $DNS_USERNAME --password $DNS_PASS -O $TOMCAT_PG1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME $DNS_URL/$JOB_JAR_NAME
		
	fi

	if [ -e $TOMCAT_PG1_PATH/$PG_REPO_NAME ] && [ -e $FILE_PATH/$JOB_JAR_NAME ]; then
	        mkdir -p $BACKUP_OLD/REPO_PCB
       		cp -r $TOMCAT_PG1_PATH/$PG_REPO_NAME  $BACKUP_OLD/REPO_PCB
	fi
###########################Implementeting below logic for multi machine setup ###############	
	if [ "$SERVER_TYPE" == "2" ] && [ -e $FILE_PATH/$JOB_JAR_NAME ]; then
		rm -rf $TOMCAT_PG1_PATH/$PG_REPO_NAME/*.jar
	fi
##############################################################################################
	if [ ! -e $TOMCAT_PG1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME ] 
	then
		echo "Invalid PG Repo Jar Name"
		
	fi
	unzip -oqq $TOMCAT_PG1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME -d $TOMCAT_PG1_PATH/$PG_REPO_NAME/
	
	if [[ -d $TOMCAT_PG1_PATH/$PG_REPO_NAME/$PG_REPO_FOLDER_NAME ]]; then
        	mv $TOMCAT_PG1_PATH/$PG_REPO_NAME/$PG_REPO_FOLDER_NAME/* $TOMCAT_PG1_PATH/$PG_REPO_NAME/
        	rm -rf $TOMCAT_PG1_PATH/$PG_REPO_NAME/$PG_REPO_FOLDER_NAME 
        	rm -rf $TOMCAT_PG1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME
	fi

	chown -R tomcat:tomcat $TOMCAT_PG1_PATH
	chmod a+x $TOMCAT_PG1_PATH/conf/server.xml 
	chmod a+x $TOMCAT_PG1_PATH/conf/web.xml

	sed -i "s/port=\"8005\"/port=\"$PORT1\"/" $TOMCAT_PG1_PATH/conf/server.xml
	sed -i "s/port=\"8080\"/port=\"$PORT2\"/" $TOMCAT_PG1_PATH/conf/server.xml
	if [ "`grep -o 'disableUploadTimeout="false" autodeploy="false"' $TOMCAT_PG1_PATH/conf/server.xml | wc -l`" -le 0 ]
        then
	        sed -i "s/connectionTimeout=\"20000\"/connectionTimeout=\"20000\" disableUploadTimeout=\"false\" autodeploy=\"false\"/g" $TOMCAT_PG1_PATH/conf/server.xml
        fi
 	sed -i "s/pathname=\"conf/tomcat-users.xml\"/removeAbandoned=\"true\" logAbandoned=\"true\" removeAbandonedTimeout=\"420\"/" $TOMCAT_PG1_PATH/conf/server.xml
	sed -i "s/port=\"8009\"/port=\"$PORT4\"/" $TOMCAT_PG1_PATH/conf/server.xml
}

#deploy job to tomcat
function deploy_blukrypt_job_repo_to_tomcat ()
{

	#copy the config file for the path

	if [ ! -e $TOMCAT_JOB1_PATH/conf/server.xml ] 
	then
		cp $TOMCAT_PATH/conf/server.xml $TOMCAT_JOB1_PATH/conf/
	fi
	
	if [ ! -e $TOMCAT_JOB1_PATH/conf/web.xml ] 
	then
		cp $TOMCAT_PATH/conf/web.xml $TOMCAT_JOB1_PATH/conf/
	fi

	if [ ! -e $TOMCAT_JOB1_PATH/conf/tomcat-users.xml ] 
	then
		cp $TOMCAT_PATH/conf/tomcat-users.xml $TOMCAT_JOB1_PATH/conf/
	fi

	if [[ $FILE_LOCATION == "jenkins" ]]; then
                wget -P $TOMCAT_JOB1_PATH/$PG_REPO_NAME/ $JENKINS_URL/$PG_JAR_URL_PATH
	elif [[ $FILE_LOCATION == "dns" ]]; then
                wget -O --user $DNS_USERNAME --password $DNS_PASS -O $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME $DNS_URL/$JOB_JAR_NAME
    	elif [[ $FILE_LOCATION == "local" ]]; then
                #will be included in file path once repo is part of patch, so currently downloading from DNS
                cp $FILE_PATH/$JOB_JAR_NAME $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME
               # wget --user $DNS_USERNAME --password $DNS_PASS -O $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME $DNS_URL/$JOB_JAR_NAME
		sleep 5
	fi
	
	if [ -e $TOMCAT_JOB1_PATH/$PG_REPO_NAME ] && [ -e $FILE_PATH/$JOB_JAR_NAME ]; then
	        mkdir -p $BACKUP_OLD/REPO_PCB_JOB
       		cp $TOMCAT_JOB1_PATH/$PG_REPO_NAME  $BACKUP_OLD/REPO_PCB_JOB
		echo "$JOB_JAR_NAME" >>patchtrack.txt
	fi

	if [ "$SERVER_TYPE" == "2" ] && [ -e $FILE_PATH/$JOB_JAR_NAME ]; then
		rm -rf $TOMCAT_JOB1_PATH/$PG_REPO_NAME/*.jar
	fi

	if [ ! -e $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME ]
	then
		echo "Invalid PG Job Repo Jar Name"
		
	fi
	unzip -oqq $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME -d $TOMCAT_JOB1_PATH/$PG_REPO_NAME/

	mv $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$PG_REPO_FOLDER_NAME/* $TOMCAT_JOB1_PATH/$PG_REPO_NAME/
	rm -rf  $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$PG_REPO_FOLDER_NAME
	rm -rf  $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME

	chown -R tomcat:tomcat $TOMCAT_JOB1_PATH
	chmod a+x $TOMCAT_JOB1_PATH/conf/server.xml 
	chmod a+x $TOMCAT_JOB1_PATH/conf/web.xml

	sed -i "s/port=\"8005\"/port=\"$JOB_PORT1\"/" $TOMCAT_JOB1_PATH/conf/server.xml
	sed -i "s/port=\"8080\"/port=\"$JOB_PORT2\"/" $TOMCAT_JOB1_PATH/conf/server.xml

	if [ "`grep -o 'disableUploadTimeout="false" autodeploy="false"' $TOMCAT_JOB1_PATH/conf/server.xml | wc -l`" -le 0 ]
        then
	        sed -i "s/connectionTimeout=\"20000\"/connectionTimeout=\"20000\" disableUploadTimeout=\"false\" autodeploy=\"false\"/g" $TOMCAT_JOB1_PATH/conf/server.xml
        fi
	sed -i "s/pathname=\"conf/tomcat-users.xml\"/removeAbandoned=\"true\" logAbandoned=\"true\" removeAbandonedTimeout=\"420\"/" $TOMCAT_JOB1_PATH/conf/server.xml
	sed -i "s/port=\"8009\"/port=\"$JOB_PORT3\"/" $TOMCAT_JOB1_PATH/conf/server.xml
}

#blukrypt war to tomcat
function deploy_blukrypt_war_to_tomcat ()
{
	if [[ $FILE_LOCATION == "jenkins" ]]; then
                wget -P $FILE_PATH/ $JENKINS_URL/$BLUKRYPT_BUILDER_WAR_URL
	        wget -P $FILE_PATH/ $JENKINS_URL/$PARACLOUD_SEARCH_WAR_URL
        elif [[ $FILE_LOCATION == "dns" ]]; then
                wget --user $DNS_USERNAME --password $DNS_PASS -O $FILE_PATH/$BLUKRYPT_BUILDER_WAR $DNS_URL/$BLUKRYPT_BUILDER_WAR
		wget --user $DNS_USERNAME --password $DNS_PASS -O $FILE_PATH/$PARACLOUD_SEARCH_WAR $DNS_URL/$PARACLOUD_SEARCH_WAR
        elif [[ $FILE_LOCATION == "local" ]]; then
                echo "Files already extracted from patch"
        fi

	#backing-up old deploy
	if [ -e $FILE_PATH/$BLUKRYPT_BUILDER_WAR ] ; then
       		mv $TOMCAT_PG1_PATH/webapps/$BLUKRYPT  $BACKUP_OLD
	fi

	if [ -e $FILE_PATH/$PARACLOUD_SEARCH_WAR ]; then
		mv $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH  $BACKUP_OLD
	fi
	
	# copy download war
	if [ ! -e $FILE_PATH/$BLUKRYPT_BUILDER_WAR ] || [ ! -e $FILE_PATH/$PARACLOUD_SEARCH_WAR ] 
	then
		echo "Builder war or paracloud search war not found"
		
	fi
	echo "file path"$FILE_PATH
	if [[ $EXCLUDE_BLUKRYPT_BUILDER != "true" ]]; then
		unzip -oqq $FILE_PATH/$BLUKRYPT_BUILDER_WAR -d $TOMCAT_PG1_PATH/webapps/$BLUKRYPT
	fi
	if [[ $EXCLUDE_PARACLOUD_SEARCH != "true" ]]; then
		unzip -oqq $FILE_PATH/$PARACLOUD_SEARCH_WAR -d $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH
	fi
	chown -R tomcat:tomcat $TOMCAT_PG1_PATH/webapps/$BLUKRYPT
	chown -R tomcat:tomcat $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH

}

function deploy_blukrypt_job_war_to_tomcat ()
{

	#backing-up old deploy
#	mkdir -p $BACKUP_OLD

	if [[ $FILE_LOCATION == "jenkins" ]]; then
               wget -P $FILE_PATH/ $JENKINS_URL/$BLUKRYPT_JOB_WAR_URL
        elif [[ $FILE_LOCATION == "dns" ]]; then
                wget --user $DNS_USERNAME --password $DNS_PASS -O $FILE_PATH/$BLUKRYPT_JOB_WAR $DNS_URL/$BLUKRYPT_JOB_WAR
        elif [[ $FILE_LOCATION == "local" ]]; then
                echo "Files already extracted from patch"
        fi

	if [ -e $FILE_PATH/$BLUKRYPT_JOB_WAR ]; then
                mv $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB  $BACKUP_OLD
        fi

	if [ -e $FILE_PATH/$MS_JOB_WAR ]; then
                mv $TOMCAT_JOB1_PATH/webapps/$MS_JOB  $BACKUP_OLD
        fi
	
	# copy download war
	if [ ! -e $FILE_PATH/$BLUKRYPT_JOB_WAR ]
	then
		echo "Blukrypt Job war not found"
		
	fi
	if [[ $EXCLUDE_BLUKRYPT_JOB != "true" ]]; then
		unzip -oqq $FILE_PATH/$BLUKRYPT_JOB_WAR -d $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB
	fi

	if [[ $EXCLUDE_MSJOB == "false" ]]; then
                unzip -oqq $FILE_PATH/$MS_JOB_WAR -d $TOMCAT_JOB1_PATH/webapps/$MS_JOB
        fi

}

function set_blukrypt_properties_values ()
{
	
		echo "Executing PG property files value changes....,"
	PROPERTIES_FILE=WEB-INF/classes/privacygateway.properties
	PROPERTIES_FILE_PCB=WEB-INF/classes/pb-credential.properties
	CLOUD_PROPERTY_FILE=WEB-INF/classes/pb-cloudproperty.properties

	chmod -R 755 $TOMCAT_PG1_PATH/webapps/$BLUKRYPT
        chmod -R 755 $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH

	#################Configuring PARACLOUD SEARCH properties file#####################

	if [ -e $FILE_PATH/$PARACLOUD_SEARCH_WAR ] && [ "$EXCLUDE_PARACLOUD_SEARCH" != "true" ]; then
	
		sed -i 's|/mnt|/parablu|' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$CLOUD_PROPERTY_FILE
		sed -i "/db_port/d" $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		sed -i "/db_host/d" $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		sed -i "/db_port1/d" $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		sed -i "/db_host1/d" $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		sed -i "/db_port2/d" $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		sed -i "/db_host2/d" $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		sed -i "/db_port3/d" $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		sed -i "/db_host3/d" $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB

		if [ "`grep -o 'db_port' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB | wc -l`" -le 0 ]
        	then
			echo "db_port=$MONGODB_PORT" >> $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		fi

		if [ "`grep -o 'db_host' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB | wc -l`" -le 0 ]
        	then
		        echo "db_host=$DB_IP" >> $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		fi

		#DB1 and PORT1
		if [ "`grep -o 'db_port1' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB | wc -l`" -le 0 ]
	        then
	        	echo "db_port1=$MONGODB1_PORT" >> $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		fi
	
		if [ "`grep -o 'db_host1' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB | wc -l`" -le 0 ]
	        then
	       	 	echo "db_host1=$DB1_IP" >> $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		fi

		#DB2 and PORT2
		if [ "`grep -o 'db_port2' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB | wc -l`" -le 0 ]
	        then
	       	 	echo "db_port2=$MONGODB2_PORT" >> $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		fi

		if [ "`grep -o 'db_host2' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB | wc -l`" -le 0 ]
	        then
	        	echo "db_host2=$DB2_IP" >> $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		fi

		#DB3 and PORT3
		if [ "`grep -o 'db_port3' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB | wc -l`" -le 0 ]
	        then
	        	echo "db_port3=$MONGODB3_PORT" >> $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		fi
		if [ "`grep -o 'db_host3' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB | wc -l`" -le 0 ]
	        then
		        echo "db_host3=$DB3_IP" >> $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		fi

		sed -i "/solrUrl/d" $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$CLOUD_PROPERTY_FILE
		echo "solrUrl=$TOMCAT_PG1_PATH/solr" >> $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$CLOUD_PROPERTY_FILE
	fi

	#################Configuring BlukryptBuilder properties file#####################
	if [ -e $FILE_PATH/$BLUKRYPT_BUILDER_WAR ] && [ "$EXCLUDE_BLUKRYPT_BUILDER" != "true" ]; then

		sed -i 's|/mnt|/parablu|' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		sed -i "/db_port/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		sed -i "/db_host/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		sed -i "/db_port1/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		sed -i "/db_host1/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		sed -i "/db_port2/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		sed -i "/db_host2/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		sed -i "/db_port3/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		sed -i "/db_host3/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		sed -i "/componentName=/d"  $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		sed -i "/local_db_port=/d"  $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE

		if [ "`grep -o 'db_port' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	        then
	                echo "" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
			echo "db_port=$MONGODB_PORT" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		fi
	
		if [ "`grep -o 'db_host' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	        then
	      	  	echo "db_host=$DB_IP" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		fi

	        #DB1 and PORT1
		if [ "`grep -o 'db_port1' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	        then
	        	echo "db_port1=$MONGODB1_PORT" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		fi
	
		if [ "`grep -o 'db_host1' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	        then
	       	 	echo "db_host1=$DB1_IP" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		fi
	
	        #DB2 and PORT2
		if [ "`grep -o 'db_port2' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	        then
	       	 	echo "db_port2=$MONGODB2_PORT" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		fi

		if [ "`grep -o 'db_host2' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	        then
	        	echo "db_host2=$DB2_IP" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		fi

	        #DB3 and PORT3
		if [ "`grep -o 'db_port3' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	        then
	        	echo "db_port3=$MONGODB3_PORT" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		fi
		if [ "`grep -o 'db_host3' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	        then
		        echo "db_host3=$DB3_IP" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		fi
		sed -i "/localdbhost=/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		#sed -i "/paracloudUrl=/d"  $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		#sed -i "/solrUrl=/d"  $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		#if [ "`grep -o 'paracloudUrl' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	        #then
		#	echo "paracloudUrl=https://$BLUVAULT_IP" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		#fi

		if [ "`grep -o 'localdbhost' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	        then
	        	echo "localdbhost=$BLUKRYPT_IP" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		fi
	
		#if [ "`grep -o 'solrUrl' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	        #then
	        #	echo "solrUrl=http://$SOLR_URL/ParacloudSearch/search/" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE	
		#fi


		##Component Name
		echo "componentName=$BLUKRYPT_IP" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		echo "local_db_port=27017" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		if [[ $ENVIRON_MODE = 'Local_B' ]] || [[ $ENVIRON_MODE = 'Local_S' ]] || [[ $ENVIRON_MODE = 'Local_BS' ]] || [[ $ENVIRON_MODE = 'Local_SR' ]]; then
			sed -i "/localStorageEnabled/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
			echo "localStorageEnabled=true" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		fi

		if [[ $PROXY_ENABLED = 'y' ]]; then
			sed -i "/proxyHost/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
			sed -i "/proxyPort/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
			sed -i "/proxyUserName/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
			sed -i "/proxyPassword/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
			echo "proxyHost=$PROXY_HOSTNAME" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
			echo "proxyPort=$PROXY_PORT" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
			echo "proxyUserName=$PROXY_A_USERNAME" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
			echo "proxyPassword=$PROXY_A_PASSWD" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		fi
	fi
}


function set_blukrypt_job_property_values ()
{

	echo -e " \n Executing PG-Job_property values  changes....,"
	chmod -R 755 $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB

	######### paths 
	PROPERTIES_FILE=WEB-INF/classes/privacygateway.properties
	SCHEDULER_CONTEXT=WEB-INF/classes/spring-config/scheduler-context.xml

	###### NOTE : Uncomment scheduler context only if it is Sync Enabled setup #########
	#### Pre-Changes

	#remove the tomcat.war before change do the changes
	rm -rf $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB_WAR

	#### StaRt-changes
	if [ -e $FILE_PATH/$BLUKRYPT_JOB_WAR ] && [ "$EXCLUDE_BLUKRYPT_JOB" != "true" ]; then

		sed -i 's|/mnt|/parablu|' $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		sed -i "/db_port/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		sed -i "/db_host/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		sed -i "/db_port1/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		sed -i "/db_host1/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		sed -i "/db_port2/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		sed -i "/db_host2/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		sed -i "/db_port3/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		#sed -i "/paracloudUrl=/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		sed -i "/localdbhost=/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		sed -i "/maindbhost=/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		sed -i "/componentName=/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		sed -i "/local_db_port=/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		
		echo "" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		echo "db_port=$MONGODB_PORT" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		echo "db_host=$DB_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		#DB1 and PORT1
		echo "db_port1=$MONGODB1_PORT" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		echo "db_host1=$DB1_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		#DB2 and PORT2
		echo "db_port2=$MONGODB2_PORT" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		echo "db_host2=$DB2_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		#DB3 and PORT3
		echo "db_port3=$MONGODB3_PORT" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		echo "db_host3=$DB3_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		#echo "paracloudUrl=https://$BLUVAULT_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		echo "localdbhost=$BLUKRYPT_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE

		echo "maindbhost=$DB_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE

		if [[ $ENVIRON_MODE = 'Local_B' ]] || [[ $ENVIRON_MODE = 'Local_S' ]] || [[ $ENVIRON_MODE = 'Local_BS' ]] || [[ $ENVIRON_MODE = 'Local_SR' ]]; then
			sed -i "/localStorageEnabled/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
			echo "localStorageEnabled=true" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		fi

		if [[ $PROXY_ENABLED = 'y' ]]; then
			sed -i "/proxyHost/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
			sed -i "/proxyPort/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
			sed -i "/proxyUserName/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
			sed -i "/proxyPassword/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
			echo "proxyHost=$PROXY_HOSTNAME" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
			echo "proxyPort=$PROXY_PORT" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
			echo "proxyUserName=$PROXY_A_USERNAME" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
			echo "proxyPassword=$PROXY_A_PASSWD" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		fi
		## Component Name
		echo "componentName=$BLUKRYPT_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		echo "local_db_port=27017" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	fi	

	######Start MSJOB Changes
	if [ -e $FILE_PATH/$MS_JOB_WAR ] && [ "$EXCLUDE_MSJOB" == "false" ]; then

		sed -i 's|/mnt|/parablu|' $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		sed -i "/db_port/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		sed -i "/db_host/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		sed -i "/db_port1/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		sed -i "/db_host1/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		sed -i "/db_port2/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		sed -i "/db_host2/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		sed -i "/db_port3/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		#sed -i "/paracloudUrl=/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		sed -i "/localdbhost=/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		sed -i "/maindbhost=/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		sed -i "/componentName=/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		sed -i "/local_db_port=/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		
		echo "" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		echo "db_port=$MONGODB_PORT" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		echo "db_host=$DB_IP" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		#DB1 and PORT1
		echo "db_port1=$MONGODB1_PORT" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		echo "db_host1=$DB1_IP" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		#DB2 and PORT2
		echo "db_port2=$MONGODB2_PORT" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		echo "db_host2=$DB2_IP" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		#DB3 and PORT3
		echo "db_port3=$MONGODB3_PORT" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		echo "db_host3=$DB3_IP" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		#echo "paracloudUrl=https://$BLUVAULT_IP" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		echo "localdbhost=localhost" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE

		echo "maindbhost=$DB_IP" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE

		if [[ $ENVIRON_MODE = 'Local_B' ]] || [[ $ENVIRON_MODE = 'Local_S' ]] || [[ $ENVIRON_MODE = 'Local_BS' ]] || [[ $ENVIRON_MODE = 'Local_SR' ]]; then
			sed -i "/localStorageEnabled/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
			echo "localStorageEnabled=true" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		fi

		if [[ $PROXY_ENABLED = 'y' ]]; then
			sed -i "/proxyHost/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
			sed -i "/proxyPort/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
			sed -i "/proxyUserName/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
			sed -i "/proxyPassword/d" $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
			echo "proxyHost=$PROXY_HOSTNAME" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
			echo "proxyPort=$PROXY_PORT" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
			echo "proxyUserName=$PROXY_A_USERNAME" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
			echo "proxyPassword=$PROXY_A_PASSWD" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		fi
		## Component Name
		echo "componentName=$MS_IP" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
		echo "local_db_port=27017" >> $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
	fi	

}


function patch_set_blukrypt_properties_values ()
{
	PROPERTIES_FILE=WEB-INF/classes/privacygateway.properties
	PROPERTIES_FILE_PCB=WEB-INF/classes/pb-credential.properties
	CLOUD_PROPERTY_FILE=WEB-INF/classes/pb-cloudproperty.properties
	DATA_SOURCE_PROPERTIES_FILE=WEB-INF/classes/pb-datasource.properties
	PROPERTIES_FILE_PROD=WEB-INF/classes/privacygateway-prod.properties
	LOG_PROPERTIES_FILE=WEB-INF/classes/log4j.properties

	chmod -R 755 $TOMCAT_PG1_PATH/webapps/$BLUKRYPT
        chmod -R 755 $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH

	if [ -e $FILE_PATH/$BLUKRYPT_BUILDER_WAR ] && [ "$EXCLUDE_BLUKRYPT_BUILDER" != "true" ]; then
		###configuring Blukrypt PROPERTIES_FILE##

		PATH_NEW=$TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		PATH_OLD=$BACKUP_OLD/$BLUKRYPT/$PROPERTIES_FILE
		custom_property_change

		###configuring Blukrypt LOG_PROPERTIES_FILE##

                PATH_NEW=$TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$LOG_PROPERTIES_FILE
                PATH_OLD=$BACKUP_OLD/$BLUKRYPT/$LOG_PROPERTIES_FILE
                custom_log4j_changes

        	###configuring Blukrypt PROPERTIES_FILE_PROD##

		PATH_NEW=$TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE_PROD
		PATH_OLD=$BACKUP_OLD/$BLUKRYPT/$PROPERTIES_FILE_PROD
		custom_property_change
		echo "$BLUKRYPT_BUILDER_WAR" >>patchtrack.txt
	fi

	if [ -e $FILE_PATH/$PARACLOUD_SEARCH_WAR ] && [ "$EXCLUDE_PARACLOUD_SEARCH" != "true" ]; then
		###configuring ParacloudSearch PROPERTIES_FILE_PCB##

		PATH_NEW=$TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		PATH_OLD=$BACKUP_OLD/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
		custom_property_change

		#configuring ParacloudSearch CLOUD_PROPERTY_FILE

		PATH_NEW=$TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$CLOUD_PROPERTY_FILE
		PATH_OLD=$BACKUP_OLD/$PARACLOUD_SEARCH/$CLOUD_PROPERTY_FILE
		custom_property_change

		#configuring ParacloudSearch LOG_PROPERTIES_FILE

                PATH_NEW=$TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$LOG_PROPERTIES_FILE
                PATH_OLD=$BACKUP_OLD/$PARACLOUD_SEARCH/$LOG_PROPERTIES_FILE
                custom_log4j_changes

	        #configuring ParacloudSearch DATA_SOURCE_PROPERTIES_FILE

		PATH_NEW=$TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$DATA_SOURCE_PROPERTIES_FILE
		PATH_OLD=$BACKUP_OLD/$PARACLOUD_SEARCH/$DATA_SOURCE_PROPERTIES_FILE
		custom_property_change
		echo "$PARACLOUD_SEARCH_WAR" >>patchtrack.txt
	fi
}

function patch_set_blukrypt_job_property_values ()
{
	chmod -R 755 $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB
	chmod -R 755 $TOMCAT_JOB1_PATH/webapps/$MS_JOB
	PROPERTIES_FILE=WEB-INF/classes/privacygateway.properties
	DATA_SOURCE_PROPERTIES_FILE=WEB-INF/classes/pb-datasource.properties
	PROPERTIES_FILE_PROD=WEB-INF/classes/privacygateway-prod.properties
	LOG_PROPERTIES_FILE=WEB-INF/classes/log4j.properties

	if [ -e $FILE_PATH/$BLUKRYPT_JOB_WAR ] && [ "$EXCLUDE_BLUKRYPT_JOB" != "true" ]; then
		###configuring Blukrypt Job CLOUD_PROPERTY_FILE###

		PATH_NEW=$TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		PATH_OLD=$BACKUP_OLD/$BLUKRYPT_JOB/$PROPERTIES_FILE
		custom_property_change

		###configuring Blukrypt Job LOG_PROPERTIES_FILE###

                PATH_NEW=$TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$LOG_PROPERTIES_FILE
                PATH_OLD=$BACKUP_OLD/$BLUKRYPT_JOB/$LOG_PROPERTIES_FILE
                custom_log4j_changes

        	###configuring Blukrypt Job PROPERTIES_FILE_PROD###

		PATH_NEW=$TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE_PROD
		PATH_OLD=$BACKUP_OLD/$BLUKRYPT_JOB/$PROPERTIES_FILE_PROD
		custom_property_change

		###Copying backed up Scheduler Context###

		SCHEDULER_CONTEXT=WEB-INF/classes/spring-config/
		SCHEDULER_CONTEXT_FILE_PATH=WEB-INF/classes/spring-config/scheduler-context.xml
		BACKUP_SCHEDULER_PATH=$BACKUP_OLD/$BLUKRYPT_JOB/$SCHEDULER_CONTEXT_FILE_PATH
		#SCHEDULER_CONTEXT_OVERIDE=`grep SCHEDULER_CONTEXT_OVERIDE $PARABLU_COMPONENT_SCRIPT_PATH | awk -F= '{print$2}'`
		#if [ $? -eq 0 ]; then
		#	if [[ $SCHEDULER_CONTEXT_OVERIDE != "true" ]]; then
		#		cp $BACKUP_SCHEDULER_PATH $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$SCHEDULER_CONTEXT
		#	fi
		#fi
		echo "$BLUKRYPT_JOB_WAR" >>patchtrack.txt
	fi

	if [ -e $FILE_PATH/$MS_JOB_WAR ] && [ "$EXCLUDE_MSJOB" == "false" ]; then
                ###configuring MS Job CLOUD_PROPERTY_FILE###

                PATH_NEW=$TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE
                PATH_OLD=$BACKUP_OLD/$MS_JOB/$PROPERTIES_FILE
                custom_property_change

                ###configuring MS Job LOG_PROPERTIES_FILE###

                PATH_NEW=$TOMCAT_JOB1_PATH/webapps/$MS_JOB/$LOG_PROPERTIES_FILE
                PATH_OLD=$BACKUP_OLD/$MS_JOB/$LOG_PROPERTIES_FILE
                custom_log4j_changes

                ###configuring MS Job PROPERTIES_FILE_PROD###

                PATH_NEW=$TOMCAT_JOB1_PATH/webapps/$MS_JOB/$PROPERTIES_FILE_PROD
                PATH_OLD=$BACKUP_OLD/$MS_JOB/$PROPERTIES_FILE_PROD
                custom_property_change
		echo "$MS_JOB_WAR" >>patchtrack.txt
               
                
        fi
}

		

# Configure to run tomcat as service
function configure_blukrypt_tomcat_service()
{
	#copy the tomcat-blukrypt1 service script into /etc/init.d
	if [ ! -e /etc/init.d/tomcat-pcb1 ] 
	then
		cp $DEFAULT_FILE_PATH/tomcat-pcb1 /etc/init.d/
		chmod a+x /etc/init.d/tomcat-pcb1
		sed -i -e 's/\r//g' /etc/init.d/tomcat-pcb1
	fi

	#copy the tomcat-job1 service script into /etc/init.d
	if [ ! -e /etc/init.d/tomcat-job1 ] 
	then
		cp $DEFAULT_FILE_PATH/tomcat-job1 /etc/init.d/
		chmod a+x /etc/init.d/tomcat-job1
		sed -i -e 's/\r//g' /etc/init.d/tomcat-job1
	fi
}


function verify_blukrypt_components ()
{
	if [ ! -e /etc/logrotate.d/tomcat-job1 ] || [ ! -e /etc/logrotate.d/tomcat-pcb1  ] 
	then
		echo "Blukrypt Installation failed. Try again after some time"
		exit 0
	else
		echo "Blukrypt Successfully installed"
	fi	
}


#create required folder structure
function create_bluklypt_folder_structure ()
{
	mkdir -p $TOMCAT_PG1_PATH
	mkdir -p $TOMCAT_PG1_PATH/conf 
	mkdir -p $TOMCAT_PG1_PATH/logs 
	mkdir -p $TOMCAT_PG1_PATH/temp 
	mkdir -p $TOMCAT_PG1_PATH/webapps 
	mkdir -p $TOMCAT_PG1_PATH/work
	mkdir -p $TOMCAT_PG1_PATH/$PG_REPO_NAME


	mkdir -p $TOMCAT_JOB1_PATH
	mkdir -p $TOMCAT_JOB1_PATH/conf
	mkdir -p $TOMCAT_JOB1_PATH/logs
	mkdir -p $TOMCAT_JOB1_PATH/temp
	mkdir -p $TOMCAT_JOB1_PATH/webapps
	mkdir -p $TOMCAT_JOB1_PATH/work
	mkdir -p $TOMCAT_JOB1_PATH/$PG_REPO_NAME

	mkdir -p $ROOT_PATH/$CLOUD_NAME
	mkdir -p $ROOT_PATH/$CLOUD_NAME/upload
	mkdir -p $ROOT_PATH/$CLOUD_NAME/f
	mkdir -p $ROOT_PATH/$CLOUD_NAME/t
	mkdir -p $ROOT_PATH/$CLOUD_NAME/backup
	mkdir -p $ROOT_PATH/$CLOUD_NAME/sync-upload
	mkdir -p $ROOT_PATH/$CLOUD_NAME/sync-upload/Portal
	mkdir -p $ROOT_PATH/support
	mkdir -p $ROOT_PATH/backup
	mkdir -p $ROOT_PATH/sync
	mkdir -p $ROOT_PATH/bkpOverview
	mkdir -p $ROOT_PATH/reports
        mkdir -p $LOG_PATH/tomcat-job1
        mkdir -p $LOG_PATH/tomcat-pcb1
        mkdir -p $ARCHIVE_PATH/tomcat-job1
        mkdir -p $ARCHIVE_PATH/tomcat-pcb1
	mkdir -p $ARCHIVE_PATH/tomcat-pcb1/catalina
	mkdir -p $ARCHIVE_PATH/tomcat-job1/catalina
	mkdir -p $PORTAL_LOG_FOLDER
	mkdir -p $LOGROTATEROOTPATH/parablusys
	mkdir -p $LOGROTATEROOTPATH/parablusys/bin
	mkdir -p $ROOT_PATH/tmp-chunk
	mkdir -p /parablu/bkpOverview/summary/

	#cp $DEFAULT_FILE_PATH/logrotate/rotate_job1.sh  $LOGROTATEROOTPATH/parablusys/bin/
	#cp $DEFAULT_FILE_PATH/logrotate/rotate_pcb1.sh $LOGROTATEROOTPATH/parablusys/bin/
	#cp $DEFAULT_FILE_PATH/logrotate/rotate_catalina_job1.sh  $LOGROTATEROOTPATH/parablusys/bin/
        #cp $DEFAULT_FILE_PATH/logrotate/rotate_catalina_pcb1.sh $LOGROTATEROOTPATH/parablusys/bin/
	#cp $DEFAULT_FILE_PATH/logrotate/rotate_catalina_job1_localhost.sh $LOGROTATEROOTPATH/parablusys/bin/
	#cp $DEFAULT_FILE_PATH/logrotate/rotate_catalina_pcb1_localhost.sh $LOGROTATEROOTPATH/parablusys/bin/
	cp $DEFAULT_FILE_PATH/logrotate/tomcat-pcb1.logrotate $LOGROTATE_D_PATH/tomcat-pcb1
	cp $DEFAULT_FILE_PATH/logrotate/tomcat-job1.logrotate $LOGROTATE_D_PATH/tomcat-job1
	cp $DEFAULT_FILE_PATH/logrotate/tomcat_catalina-pcb1.logrotate $LOGROTATE_D_PATH/tomcat_catalina-pcb1
        cp $DEFAULT_FILE_PATH/logrotate/tomcat_catalina-job1.logrotate $LOGROTATE_D_PATH/tomcat_catalina-job1
	cp $DEFAULT_FILE_PATH/logrotate/tomcat_catalina-pcb1-localhost.logrotate $LOGROTATE_D_PATH/tomcat_catalina-pcb1-localhost
	cp $DEFAULT_FILE_PATH/logrotate/tomcat_catalina-job1-localhost.logrotate $LOGROTATE_D_PATH/tomcat_catalina-job1-localhost

	cp $DEFAULT_FILE_PATH/bulkBlockUnblockDeleteUsers.xlsx $ROOT_PATH/bkpOverview
	cp $DEFAULT_FILE_PATH/bulkBlockUnblockDeleteDevices.xlsx $ROOT_PATH/bkpOverview
	cp $DEFAULT_FILE_PATH/bulkCreateUsers.xlsx $ROOT_PATH/bkpOverview

	if [[ $NEW_INSTALL == "true" ]]; then
		chmod -R 755 $ROOT_PATH/$CLOUD_NAME
	        chown -R tomcat:parablu $ROOT_PATH/$CLOUD_NAME
		chown -R tomcat:parablu $ROOT_PATH/sync
	        chown -R tomcat:parablu $ROOT_PATH/backup
		chown -R tomcat:parablu $ROOT_PATH/tmp-chunk/
		chmod -R 775 $ROOT_PATH/$CLOUD_NAME/sync-upload/Portal
		chmod -R 755 $PORTAL_LOG_FOLDER
	fi

	chmod -R 644 $LOGROTATE_D_PATH/*
        chmod -R 755 $ROOT_PATH/support
        chown -R tomcat:parablu $ROOT_PATH/support
        chown -R tomcat:parablu $ROOT_PATH/$CLOUD_NAME/Portal
        chmod -R 755 $ROOT_PATH/bkpOverview
        chown -R tomcat:parablu $ROOT_PATH/bkpOverview
        chmod -R 755 $ROOT_PATH/reports
        chown -R tomcat:parablu $ROOT_PATH/reports                        
        chown -R root:root $LOGROTATEROOTPATH/parablusys/bin/*
        chmod -R 755 $LOGROTATEROOTPATH/parablusys/bin/*
        chmod -R 755 $LOG_PATH
        chown -R tomcat:tomcat $LOG_PATH/tomcat-job1
        chown -R tomcat:tomcat $LOG_PATH/tomcat-pcb1
        chown -R tomcat:tomcat $ARCHIVE_PATH/tomcat-job1
        chown -R tomcat:tomcat $ARCHIVE_PATH/tomcat-pcb1

	mkdir -p $CLIENT_ROOT_PATH/parablusys
	mkdir -p $CLIENT_ROOT_PATH/parablusys/bin
	mkdir -p $CLIENT_ROOT_PATH/parablusys/upgrade
	mkdir -p $CLIENT_ROOT_PATH/parablusys/clients
	mkdir -p $CLIENT_ROOT_PATH/parablusys/conf
	mkdir -p $CLIENT_ROOT_PATH/parablusys/private
	mkdir -p /var/www/odbInfo
        chown -R tomcat:tomcat /var/www/odbInfo
#	touch $CLIENT_ROOT_PATH/parablusys/conf/google.config.php
#	touch $CLIENT_ROOT_PATH/parablusys/conf/mail.config.php
#	touch $CLIENT_ROOT_PATH/parablusys/conf/odb.config.php
#	touch $CLIENT_ROOT_PATH/parablusys/conf/odc.config.php

	chmod 755 $CLIENT_ROOT_PATH/parablusys/conf/*
	chmod -R 777 /var/lib/parablusys/upgrade
	chmod -R 777 /var/lib/parablusys/clients
}

function configure_blukrypt_in_apache()
{
	sed -i "/$BLUKRYPT/d" /etc/apache2/mods-enabled/jk.conf
	sed -i "92iJkMount /$BLUKRYPT/* balancer" /etc/apache2/mods-enabled/jk.conf
}

#configuring blukrypt
function configure_blukrypt_odb_config ()
{
	if [ ! -e /var/lib/parablusys/conf/odb.config.php ] 
	then
		cp $FILE_PATH/odb.config.php /var/lib/parablusys/conf/odb.config.php
	fi
}

function restart_blukrypt_components ()
{
	if [[ $NEW_INSTALL == "true" ]]; then
         
		service memcached restart

	fi

        service tomcat-pcb1 restart
        service tomcat-job1 restart
}

# restarting blukrypt
function stop_blukrypt_components ()
{
	#service couchdb stop
	service tomcat-pcb1 stop
	service tomcat-job1 stop
	service apache2 stop
}

# restarting blukrypt
function start_blukrypt_components ()
{
	#service couchdb start
	#service activemq start
	if [[ $NEW_INSTALL == "true" ]]; then

		service memcached start

	fi
	service tomcat-pcb1 start
	service tomcat-job1 start
	service apache2 start
}

# Restarting all the components into init.d
function configure_blukrypt_components_start_service ()
{
	echo " service activmq restart
		service tomcat-pcb1 restart
		service tomcat-job1 restart
		service apache2 restart" > /etc/init.d/PB_autorun.sh

	chmod a+x /etc/init.d/PB_autorun.sh

	sudo update-rc.d PB_autorun.sh defaults
}

function configure_blukrypt_log4j ()
{
        LOG_PROPERTIES_FILE=WEB-INF/classes/log4j.properties
        if [ -e $FILE_PATH/$BLUKRYPT_JOB_WAR ]; then
            sed -i 's|DEBUG|INFO|' $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$LOG_PROPERTIES_FILE
            sed -i 's|/mnt|/parablu|' $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$LOG_PROPERTIES_FILE
        fi
	if [ -e $FILE_PATH/$MS_JOB_WAR ]; then
            sed -i 's|DEBUG|INFO|' $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$LOG_PROPERTIES_FILE
            sed -i 's|/mnt|/parablu|' $TOMCAT_JOB1_PATH/webapps/$MS_JOB/$LOG_PROPERTIES_FILE
        fi
        if [ -e $FILE_PATH/$BLUKRYPT_BUILDER_WAR ] ; then
            sed -i 's|DEBUG|INFO|' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$LOG_PROPERTIES_FILE
            sed -i 's|/mnt|/parablu|' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$LOG_PROPERTIES_FILE
        fi
        if [ -e $FILE_PATH/$PARACLOUD_SEARCH_WAR ]; then
            sed -i 's|DEBUG|INFO|' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$LOG_PROPERTIES_FILE
            sed -i 's|/mnt|/parablu|' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$LOG_PROPERTIES_FILE
        fi    

}

#Deletion of tmp-chunk file
function configure_tmpchunk_cron ()
{
	chunkscript_path=`pwd`
	chunkcroncmd="cd $chunkscript_path && ./chunk_delete.sh"
	chunkcronjob="0 * * * * $chunkcroncmd"
	( crontab -l | grep -v -F "$chunkcroncmd" ; echo "$chunkcronjob" ) | crontab -
}

#deploy components
function deploy_blukrypt_components ()
{
#	release_activemq
	release_tomcat
	release_apache
	#release_couchdb
	release_memcached
	configure_blukrypt_tomcat_service
	create_bluklypt_folder_structure
	stop_blukrypt_components
	deploy_blukrypt_repo_to_tomcat
	deploy_blukrypt_job_repo_to_tomcat
	deploy_blukrypt_war_to_tomcat
	deploy_blukrypt_job_war_to_tomcat
}

#Config components
function config_blukrypt_components ()
{
        set_blukrypt_properties_values
        set_blukrypt_job_property_values

        if [[ $JK_MOUNT_CONF == "true" ]]; then

             configure_blukrypt_in_apache
        fi

        configure_blukrypt_odb_config
        configure_blukrypt_components_start_service
        configure_blukrypt_log4j
	configure_tmpchunk_cron
        
        if [[ $PATCH_INSTALL == "true" ]]; then
                patch_set_blukrypt_properties_values
                patch_set_blukrypt_job_property_values
        fi
}

function config_blukrypt_mongo ()
{

        sed -i "s|CLOUD_NAME|$CLOUD_NAME|" $INSTALLABLES_SCRIPT_PATH/js/blukrypt_tables.js
	sleep 1s
	sudo mongo admin $INSTALLABLES_SCRIPT_PATH/js/auth_mongo.js
        sudo mongo blukrypt $INSTALLABLES_SCRIPT_PATH/js/blukrypt_tables.js
#	sudo mongo parablumsj $INSTALLABLES_SCRIPT_PATH/js/parablumsg_tables.js
	mkdir -p $LOG_PATH/mongodb
	chown mongodb:mongodb $LOG_PATH/mongodb
	chmod 0755 $LOG_PATH/mongodb
	sed -i "s|/var/log/mongodb/mongod.log|$LOG_PATH/mongodb/mongod.log|" /etc/mongod.conf
        configure_mongo_security

	service mongod restart

	sleep 3s

}

function config_msjob_mongo ()
{

        sudo mongo admin $INSTALLABLES_SCRIPT_PATH/js/auth_mongo.js
 #       sudo mongo parablumsj $INSTALLABLES_SCRIPT_PATH/js/parablumsg_tables.js
        configure_mongo_security

}

# external function to install blukrypt components
function release_blukrypt () 
{
	if [[ "$SERVER_TYPE" == "2" ]] || [[ "$SERVER_TYPE" == "1 2" ]];then
                if [[ $PATCH_INSTALL != "true" ]]; then

			sudo systemctl enable mongod

			sleep 3s
			service mongod restart

			sleep 3s
			
                        config_blukrypt_mongo
			if [[ "$EXCLUDE_MSJOB" != "true" ]]; then
				config_msjob_mongo
			fi
			if [[ "$SERVER_TYPE" == "2" ]]; then
				cp -r $INSTALLABLES_SCRIPT_PATH/js/jobconfig.js $INSTALLABLES_SCRIPT_PATH/js/jobconfig_install.js
				sleep 2s

				SERVER_IP=$BLUKRYPT_IP
				sed -i "s|SERVER_IP_ADDRESS|$SERVER_IP|g" $INSTALLABLES_SCRIPT_PATH/js/jobconfig_install.js

				sleep 1s
				echo "ADDING JOB CONFIG"
				sudo mongo $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < $INSTALLABLES_SCRIPT_PATH/js/jobconfig_install.js
				sleep 1s

				if [ "$PRODUCT_TYPE" == "1 2" ] || [ "$PRODUCT_TYPE" == "1" ];then

                                	sudo mongo $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < $INSTALLABLES_SCRIPT_PATH/js/sync_jobconfig.js

                        	fi
			fi
                fi
        fi

	if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "2" ]] || [[ "$SERVER_TYPE" == "1 2" ]];then
		if [[ $PATCH_INSTALL != "true" ]]; then

			cp -r $INSTALLABLES_SCRIPT_PATH/js/privacy_gateway.js $INSTALLABLES_SCRIPT_PATH/js/privacy_gateway_install.js
			sleep 1s
			sed -i "s|BV_VALUE|$BLUVAULT_IP|g" $INSTALLABLES_SCRIPT_PATH/js/privacy_gateway_install.js
                        sed -i "s|SERVER_IP_ADDRESS|$BLUKRYPT_IP|g" $INSTALLABLES_SCRIPT_PATH/js/privacy_gateway_install.js
			sleep 2s
			echo "ADDING PRIVACY GATEWAY"
                        sudo mongo $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < $INSTALLABLES_SCRIPT_PATH/js/privacy_gateway_install.js

			if [[ "$EXCLUDE_MSJOB" != "true" ]]; then
				cp -r ../installables/js/msjob_job.js ../installables/js/msjob_job_install.js
				sleep 2s
				sed -i "s|MSJOB_VAL|$BLUKRYPT_IP|" ../installables/js/msjob_job_install.js
				sed -i "s|MSHOST|$BLUKRYPT_IP|" ../installables/js/msjob_job_install.js
                                sed -i "s|MSPORT|$MONGODB_PORT|" ../installables/js/msjob_job_install.js
				sudo mongo $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < $INSTALLABLES_SCRIPT_PATH/js/msjob_job_install.js
			fi
		fi
	fi

	deploy_blukrypt_components 2>&1 >> install.log
	config_blukrypt_components 2>&1 >> install.log
	verify_blukrypt_components 2>&1 >> install.log
	start_blukrypt_components 2>&1 >> install.log
	chown -R tomcat:tomcat $TOMCAT_JOB1_PATH
        chown -R tomcat:tomcat $TOMCAT_PG1_PATH

	if [ "$SERVER_TYPE" == "2" ]; then
	  restart_blukrypt_components 2>&1 >> install.log
   	fi
}



function release_msjob ()
{

                if [[ $PATCH_INSTALL != "true" ]]; then

                        sudo systemctl enable mongod

                        sleep 3s
                        service mongod restart

                        sleep 3s
                        config_msjob_mongo
			sudo mongo parablumsg $INSTALLABLES_SCRIPT_PATH/js/parablumsg_tables.js

                fi

                if [[ $PATCH_INSTALL != "true" ]]; then
                        if [[ "$EXCLUDE_MSJOB" != "true" ]]; then

				cp ../installables/js/standalone_msjob_job.js ../installables/js/standalone_install_msjob_job.js
				sleep 2s

				read -p "Enter Number of MICROSOFT ONE DRIVE BACKUP USERS:" msjobusers
				sleep 1s
				sed -i "s|ODBUSER_PLACEHOLDER|$msjobusers|" ../installables/js/standalone_install_msjob_job.js
				sed -i "s|MSJOB_VAL|$MS_IP|" ../installables/js/standalone_install_msjob_job.js
				sed -i "s|MSHOST|$MS_IP|" ../installables/js/standalone_install_msjob_job.js
				sed -i "s|MSPORT|$MONGODB_PORT|" ../installables/js/standalone_install_msjob_job.js
				sleep 2s
                                sudo mongo $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < $INSTALLABLES_SCRIPT_PATH/js/standalone_install_msjob_job.js
				sleep 2s
				sed -i "s|bindIp:.*|bindIp: localhost,$MS_IP|" /etc/mongod.conf
				service mongod restart
				sleep 2s
                        fi
                fi

        deploy_blukrypt_components 2>&1 >> install.log
        config_blukrypt_components 2>&1 >> install.log
        verify_blukrypt_components 2>&1 >> install.log
        start_blukrypt_components 2>&1 >> install.log
        chown -R tomcat:tomcat $TOMCAT_JOB1_PATH
        chown -R tomcat:tomcat $TOMCAT_PG1_PATH

        if [ "$SERVER_TYPE" == "6" ]; then
          restart_blukrypt_components 2>&1 >> install.log
        fi
}
FILE=/etc/modsecurity/modsecurity.conf
function rollback_blukrypt ()
{
        rm -rf $ROOT_PATH/$CLOUD_NAME
	rm -rf $ROOT_PATH/support
	rm -rf $ROOT_PATH/backup
	rm -rf $ROOT_PATH/sync
	rm -rf $ROOT_PATH/bkpOverview
	rm -rf $ROOT_PATH/log
        rm -rf $ROOT_PATH/reports
        rm -rf $ROOT_PATH/installed_version
        rm -rf $ROOT_PATH/tmp-chunk
	rm -rf /var/lib/tomcat-pcb1
        rm -rf /var/lib/tomcat-job1
	rm -rf $LOG_PATH/tomcat-job1
        rm -rf $LOG_PATH/tomcat-pcb1
        rm -rf $ARCHIVE_PATH/tomcat-job1
        rm -rf $ARCHIVE_PATH/tomcat-pcb1
	rm -rf /etc/init.d/tomcat-pcb1
	rm -rf /etc/init.d/tomcat-job1
	rm -rf /etc/init.d/PB_autorun.sh
	rm -rf $LOGROTATE_D_PATH/tomcat-pcb1
	rm -rf $LOGROTATE_D_PATH/tomcat-job1
	rm -rf $LOGROTATE_D_PATH/tomcat_catalina-pcb1
        rm -rf $LOGROTATE_D_PATH/tomcat_catalina-job1
	rm -rf /var/www/odbInfo
        if [ -f "$FILE" ]; then
	#apt-get -y autoremove libapache2-mod-security2
	apt-get -y autoremove libapache2-mod-security2
        sudo apt-get -y purge --auto-remove libapache2-mod-security2
        rm -rf /etc/modsecurity/
        sudo apt-get -y purge --auto-remove modsecurity-crs
	#rm -rf /etc/modsecurity/
	fi
        #uninstall_activemq
        uninstall_tomcat
        uninstall_apache

}
