#!/bin/bash
#by rSuresh
source ./config.properties 2>&1
# Detials got from config.properties
# Copy the old backup version file to upgrade path
# Update the mongo to old version
# call PB Restart Services.

rm $EPA_UPDATE_PATH/$RENAME_EPA_FILE &> /dev/null 
rm parablu_update_old_tables.js &> /dev/null 
rm parablu_update_old_tables.txt &> /dev/null 
#cp $EPA_OLD_VERSION/$RENAME_EPA_FILE"_old" $EPA_UPDATE_PATH/$RENAME_EPA_FILE"_old"
cp $LOCAL_PATH/$EPA_OLD_VERSION/$RENAME_EPA_FILE $EPA_UPDATE_PATH/$RENAME_EPA_FILE

echo 'use parablu
db.PRODUCT_RELEASE.update({"productMinorGroup" : "service"},{$set:{"productVersion" : "EPA_OLD_VERSION"}})' > parablu_update_old_tables.js

sed -i "s|EPA_OLD_VERSION|$EPA_OLD_VERSION|" parablu_update_old_tables.js

tr -d '\r'  < ./parablu_update_old_tables.js > parablu_update_old_tables.txt
mv parablu_update_old_tables.txt parablu_update_old_tables.js

sudo mongo $DB1_IP:$PORT_DB1_IP -u "neil" -p "parablu" --authenticationDatabase "admin" < parablu_update_old_tables.js

echo "DB Updated to "$EPA_OLD_VERSION
echo "DB Updated to "$EPA_OLD_VERSION >> update.log
echo "Service Revert Completed."
echo "Service Revert Completed." >> update.log

rm $ROOT_PATH/old_agent_version >> update.log
rm $ROOT_PATH/new_agent_version >> update.log

echo $EPA_OLD_VERSION > $ROOT_PATH/old_agent_version
echo $EPA_OLD_VERSION > $ROOT_PATH/new_agent_version

./restart_agent_update.sh 2>&1 >> update.log
echo "Parablu Service Restarted."
