/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility.parablu001.user;

import com.parablu.utility.model.UserStatistics;
import com.parablu.utility.parablu001.backupPolicy.BackupPolicyRepository;
import com.parablu.utility.parablu001.backupPolicy.Policy;
import com.parablu.utility.parablu001.user.User;
import com.parablu.utility.parablu001.user.UserRepository;
import com.parablu.utility.parablu001.user.UserService;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private BackupPolicyRepository backupPolicyRepository;

    public UserStatistics getUserStatistics() {
        return new UserStatistics(this.userRepository.count(), this.userRepository.getAllActiveUserCount(), this.userRepository.getAllBlockedUserCount(), this.userRepository.getAllDeletedUserCount(), this.getUsersByPolicy(), this.getNoOfUserBkpPolicyNotMapped());
    }

    private long getNoOfUserBkpPolicyNotMapped() {
        long userBkpPolicyNotMappedCount = 0L;
        Map usersBkpPolicyList = this.getAllUserBackupPolicyList();
        List backupPolicyNameList = this.getAllPolicyNameList();
        for (Map.Entry entry : usersBkpPolicyList.entrySet()) {
            if (!StringUtils.isEmpty(entry.getKey()) && backupPolicyNameList.contains(entry.getKey())) continue;
            userBkpPolicyNotMappedCount += ((Long)entry.getValue()).longValue();
        }
        return userBkpPolicyNotMappedCount;
    }

    private Map<String, Long> getAllUserBackupPolicyList() {
        List usersList = this.userRepository.findAll();
        long userWithOutPolicy = usersList.parallelStream().filter(user -> user.isBackupEnabled() && user.isActive() && !user.isDeleted() && StringUtils.isEmpty((Object)user.getPolicyName())).count();
        Map<String, Long> userWithoutPolicyCounts = usersList.parallelStream().filter(user -> user.isBackupEnabled() && user.isActive() && !user.isDeleted() && !StringUtils.isEmpty((Object)user.getPolicyName())).collect(Collectors.toList()).parallelStream().collect(Collectors.groupingBy(User::getPolicyName, Collectors.counting()));
        userWithoutPolicyCounts.put("", userWithOutPolicy);
        return userWithoutPolicyCounts;
    }

    private List<String> getAllPolicyNameList() {
        List backupPolicyList = this.backupPolicyRepository.getAllBackupPolicies();
        return backupPolicyList.stream().filter(policy -> !StringUtils.isEmpty((Object)policy.getPolicyName())).sorted(Comparator.comparing(Policy::getPolicyName)).map(policy -> policy.getPolicyName()).collect(Collectors.toList());
    }

    private Map<String, Long> getUsersByPolicy() {
        List usersList = this.userRepository.findAll();
        return usersList.stream().filter(user -> user.isBackupEnabled() && user.isActive() && !user.isDeleted() && !StringUtils.isEmpty((Object)user.getPolicyName())).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(User::getPolicyName, Collectors.counting()));
    }
}

