#!/bin/bash
# DEVELOPER: Vaibhav K

PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh
PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh

source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_CONFIG_SCRIPT_PATH


apache_conf="/etc/apache2/sites-enabled/default-ssl.conf"
php_conf="/etc/php/7.2/cli/php.ini"
apache2_conf="/etc/apache2/apache2.conf"
apache_backup_path="/apacheconfbackup/"

mkdir -p $apache_backup_path/$date_time
cp -r $apache_conf $apache_backup_path/$date_time/

		#install openssl OFFLINE
		openssl version -a | grep 1.0.2g
		if [ $? -ne 0 ]; then
			#install openssl
	                curr_dir=`pwd`
        	        cd $DEFAULT_FILE_PATH
                	tar -xf openssl-1.0.2g.tar.gz
	                cd openssl-1.0.2g/
        	        ./config --prefix=/usr/
                	make
	                sudo make install
        	        cd $curr_dir
                	sleep 2s
		fi

		#### Apache changes

		sed -i 's|Options Indexes FollowSymLinks MultiViews|Options +FollowSymLinks -Indexes -MultiViews|g'  $apache_conf

		grep -r "ServerTokens Prod" $apache_conf
		if [ $? -eq 0 ]; then
			echo "Values already appended"
		else
			sed -i '/<\/VirtualHost>/a ServerTokens Prod' $apache_conf
			sed -i '/<\/VirtualHost>/a ServerSignature Off' $apache_conf
			#sed -i $'/<\/VirtualHost>/a \n' $apache_conf
		fi

		
		grep -r "SSLProtocol -all +TLSv1.2" $apache_conf
		if [ $? -eq 0 ]; then
			echo "Values already appended"
		else
			sed -i '/SSLCertificateKeyFile \/etc\/ssl\/private\/ca.key/a SSLCipherSuite EECDH+AESGCM:EDH+AESGCM:AES256+EECDH:ECDHE-RSA-AES128-SHA:DHE-RSA-AES128-GCM-SHA256:AES256+EDH:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GC$' $apache_conf
			sed -i '/SSLCertificateKeyFile \/etc\/ssl\/private\/ca.key/a SSLProtocol -all +TLSv1.2' $apache_conf
		fi


		## PHP Change

		rm -rf /var/www/html
		sed -i 's|expose_php = On|expose_php = Off|' $php_conf
		
		grep -r "Header always set Strict-Transport-Security" $apache_conf
		if [ $? -ne 0 ]; then
			sed -i '/<VirtualHost _default_:443>/a Header always set Strict-Transport-Security "max-age=63072000; includeSubdomains; preload"' $apache_conf
		fi

		grep -r "Header set X-XSS-Protection" $apache_conf
                if [ $? -ne 0 ]; then
                        sed -i '/Header always set Strict-Transport-Security "max-age=63072000; includeSubdomains; preload"/a Header set X-XSS-Protection "1; mode=block"' $apache_conf
                fi

		grep -r "Header set Content-Security-Policy" $apache_conf
                if [ $? -ne 0 ]; then
                        sed -i "/Header set X-XSS-Protection/a Header set Content-Security-Policy \"script-src https: 'unsafe-inline' 'unsafe-eval';\"" $apache_conf
                fi

                grep -r "Header set Referrer-Policy" $apache_conf
                if [ $? -ne 0 ]; then
                        sed -i "/Header set Content-Security-Policy \"script-src https: 'unsafe-inline' 'unsafe-eval';\"/a Header set Referrer-Policy \"no-referrer\"" $apache_conf
                fi

                grep -r "Header unset X-Forwarded-Host" $apache_conf
                if [ $? -ne 0 ]; then
                        sed -i '/Header set Referrer-Policy "no-referrer"/a Header unset X-Forwarded-Host' $apache_conf
                fi


		#### Adding server name to apache conf
		if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "1" ] || [ "$SERVER_TYPE" == "3 1" ]; then
			echo "$BLUVAULT_IP" |  grep -e ".com" -e ".net" -e ".in" -e ".co"
				if [ $? -eq 0 ]; then
					sed -i '/Servername/d' $apache2_conf
					sed -i "/<\/ifModule>/a Servername $BLUVAULT_IP" $apache2_conf
				fi


		fi
		if [ "$SERVER_TYPE" == "2" ]; then
			echo "$BLUKRYPT_IP" |  grep -e ".com" -e ".net" -e ".in" -e ".co"
			if [ $? -eq 0 ]; then
                        	sed -i '/Servername/d' $apache2_conf
                                sed -i "/<\/ifModule>/a Servername $BLUKRYPT_IP" $apache2_conf
                        fi

		fi
		service apache2 restart
