#!/bin/bash
# DEVELOPER: Vaibhav K
PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh
PARABLU_COMPONENT_CONFIG_SCRIPT_PATH=../config/parablu_component_config.sh

source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_COMPONENT_CONFIG_SCRIPT_PATH

export PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:$PATH"

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "3 1" ] ||  [ "$SERVER_TYPE" == "1 2" ]; then

echo 'use parablu001
db.BLUVAULT.find({"bluVaultName" : "GATEWAY_NAME"}).forEach(function(e) {print("brandingPropertyUpdated=" +e.componentsProperties.brandingPropertyUpdated)})' >capture_branding.js

        sed -i "s|GATEWAY_NAME|$BLUVAULT_IP|g" capture_branding.js
        dbport=$(grep port: /etc/mongod.conf)
        MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')

        sudo mongo $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < capture_branding.js > capture_branding

        BRANDING=`grep "brandingPropertyUpdated" capture_branding`
        echo "$BRANDING"
        BRANDING_VAL=$( echo $BRANDING | sed -e 's/brandingPropertyUpdated=//')
        echo "$BRANDING_VAL"
        if [[ ${BRANDING_VAL} == "false" ]]; then
                bash "/var/www/portal/app/curl.sh"
        fi
fi

function service_stop_status ()
{

if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "1 2" ]] || [[ "$SERVER_TYPE" == "2" ]];then 
        echo 'use parablu001

db.PRIVACY_GATEWAY.find({"gatewayName" : "GATEWAY_NAME"}).forEach(function(e) {print("SERVICESTOP=" +e.isActive)})' >capture_servicestop.js

        sed -i "s|GATEWAY_NAME|$BLUKRYPT_IP|g" capture_servicestop.js

        sudo mongo $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < capture_servicestop.js > capture_servicestop

        SERVICESTOP=`grep "SERVICESTOP" capture_servicestop`
        BK_ACTIVE=$( echo $SERVICESTOP | sed -e 's/SERVICESTOP=//')

else
        BK_ACTIVE=true
fi

} 



service_stop_status

echo "-------------------BEGIN `date`-------------------"

if [ "$BK_ACTIVE" == "true" ]; then

echo 'y' | bash service-parablu.sh stop
sleep 45s
echo 'y' | bash service-parablu.sh stop
sleep 15s
sync; echo 3 > /proc/sys/vm/drop_caches
sleep 10s
echo 'y' | bash service-parablu.sh start

sleep 3m

        count=1
        until [ $count -ge 3 ]
        do
		if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "1 2" ]] || [[ "$SERVER_TYPE" == "2" ]];then
			echo "TRYING TO  PING BLUKRYPTBUILDER...............[`date`]"
        		call_bkapi=`curl -k /dev/null --max-time 300 --silent --get --write-out '%{http_code}\n'  https://$BLUKRYPT_IP/BluKryptBuilder/ping/`
	        	echo "$call_bkapi" | grep 200
	        	if [ $? -ne 0 ]; then
        	        	restartflag=true
	        	        echo "BLUKRYPTBUILDER IS NOT PINGING..!!!"
	        	else
		            echo "BLUKRYPTBUILDER IS PINGING..!!!"
        		fi
		fi

		if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "1 2" ]] || [[ "$SERVER_TYPE" == "1" ]] || [[ "$SERVER_TYPE" == "3 1" ]];then

			echo "TRYING TO  PING PARACLOUD...............[`date`]"
        		call_paracloudPing=`curl -k /dev/null --max-time 120 --silent --get --write-out '%{http_code}\n'  https://$BLUVAULT_IP/paracloud/ping/`
	        	echo "$call_paracloudPing" | grep 400
	        	if [ $? -ne 0 ]; then
		              restartflag=true
        		      echo "PARACLOUD IS NOT PINGING"
		        else
        		      echo "PARACLOUD IS PINGING"
	        	fi
		fi

	#        echo "RESTART FLAG IS:$restartflag"


        	if [ "$restartflag" == "true" ]; then
			sleep 3s
			echo "RETRYING.......[$count] [`date`]"
        	        echo 'y' | bash service-parablu.sh stop
                	sleep 10s
	                sync; echo 3 > /proc/sys/vm/drop_caches
        	        sleep 10s
                	echo 'y' | bash service-parablu.sh start
	        else
        	        break
	        fi
        	count=$[$count+1]
	        sleep 5s
		restartflag=''
        done

else

        echo "BLUKRYPT DISABLED. NOT RUNNING RESTART SCRIPT"    
fi
echo "-----------------------------------END `date`--------------------------"
