#!/bin/bash
#                                                                                       #
# SCRIPT: mongo_service.sh		                                                #
# DATE:   27-Oct-2016                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems								#
# DEVELOPER: Vaibhav K
# PURPOSE: Contains all the utility functions for mongo Installation                  	#
# PLATFORM: Ubuntu                                                                      #

UBUNTU_SERVICE_SCRIPT_PATH=./ubuntu_service.sh
source $UBUNTU_SERVICE_SCRIPT_PATH 

PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh
source $PARABLU_COMPONENT_SCRIPT_PATH
# Configure all the prerequisite components
function prerequisite_mongodb ()
{
	#       if [ ! -e /etc/mongod.conf ]
        if [ ! -e ../installables/mongo_installed ]
        then
		install_common_packages
		sudo groupadd mongodb
                sudo useradd -r -s /bin/false -g mongodb mongodb
		mkdir -p $LOG_PATH/mongodb
		chown mongodb:mongodb $LOG_PATH/mongodb
		chmod 0755 $LOG_PATH/mongodb
		mkdir -p $ARCHIVE_PATH/mongodb
		chown mongodb:mongodb $ARCHIVE_PATH/mongodb
		chmod 0755 $ARCHIVE_PATH/mongodb
		mkdir -p $DATA_PATH/mongodb
		chown mongodb:mongodb $DATA_PATH/mongodb
		chmod 0755 $DATA_PATH/mongodb

		mkdir -p $LOGROTATEROOTPATH/parablusys
		mkdir -p $LOGROTATEROOTPATH/parablusys
		mkdir -p $LOGROTATEROOTPATH/parablusys/bin

		#cp $DEFAULT_FILE_PATH/logrotate/rotate_mongodb.sh  $LOGROTATEROOTPATH/parablusys/bin/
		cp $DEFAULT_FILE_PATH/logrotate/mongodb.logrotate $LOGROTATE_D_PATH/mongodb

#		cp $DEFAULT_FILE_PATH/logrotate/rotate_mongodb_backup.sh  $LOGROTATEROOTPATH/parablusys/bin/
#	        cp $DEFAULT_FILE_PATH/logrotate/mongodb-backup.logrotate $LOGROTATE_D_PATH/mongodb-backup

		chown -R root:root $LOGROTATEROOTPATH/parablusys/bin/*
		chmod -R 755 $LOGROTATEROOTPATH/parablusys/bin/*
	fi
}
#log file path change
function configure_mongo_log ()
{
	sed -i "s|/var/log/mongodb/mongod.log|$LOG_PATH/mongodb/mongod.log|" /etc/mongod.conf
	sed -i "s|/var/lib/mongodb|$DATA_PATH/mongodb|" /etc/mongod.conf
 
}


function configure_mongo_security ()
{
	sed -i "/authorization/d" /etc/mongod.conf
       sed -i "/security/d" /etc/mongod.conf
       echo "security:" >> /etc/mongod.conf
       echo " authorization: enabled" >> /etc/mongod.conf

}

# install mongodb
function install_mongodb ()
{
	if [ ! -e /etc/mongod.conf ]
	then
		#sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv 9DA31620334BD75D9DCB49F368818C72E52529D4 2> /dev/null
                #echo "deb [ arch=amd64 ] https://repo.mongodb.org/apt/ubuntu "$(lsb_release -sc)"/mongodb-org/4.0 multiverse" | sudo tee /etc/apt/sources.list.d/mongodb-org-4.0.list 2> /dev/nul
		#sudo apt-get -y --allow-unauthenticated update 2> /dev/null
		#sudo apt-get install -y mongodb-org=4.0.9 mongodb-org-server=4.0.9 mongodb-org-shell=4.0.9 mongodb-org-mongos=4.0.9 mongodb-org-tools=4.0.9  2> /dev/null
		wget http://archive.ubuntu.com/ubuntu/pool/main/o/openssl/libssl1.1_1.1.1f-1ubuntu2_amd64.deb
                sudo dpkg -i libssl1.1_1.1.1f-1ubuntu2_amd64.deb
		sleep 3s
                sudo apt install -y wget curl gnupg2 software-properties-common apt-transport-https ca-certificates lsb-release
                #sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv 9DA31620334BD75D9DCB49F368818C72E52529D4 2> /dev/null
                wget -qO - https://www.mongodb.org/static/pgp/server-5.0.asc | sudo apt-key add - 2> /dev/nul
                #echo "deb [ arch=amd64 ] https://repo.mongodb.org/apt/ubuntu "$(lsb_release -sc)"/mongodb-org/4.0 multiverse" | sudo tee /etc/apt/sources.list.d/mongodb-org-4.0.list 2> /dev/nul
                echo "deb [ arch=amd64,arm64 ] https://repo.mongodb.org/apt/ubuntu focal/mongodb-org/5.0 multiverse" | sudo tee /etc/apt/sources.list.d/mongodb-org-5.0.list
                sudo apt-get -y --allow-unauthenticated update 2> /dev/null
                sudo apt-get install -y mongodb-org=5.0.14 mongodb-org-server=5.0.14 mongodb-org-shell=5.0.14 mongodb-org-mongos=5.0.14 mongodb-org-tools=5.0.14  2> /dev/null
		sleep 10s
		service mongod start
	fi
}

#logrotate
function configure_mongo_logrotate ()
{
	echo "/var/log/mongodb/mongod.log {
       	 daily
       	 missingok
	 size 100M
	 rotate 4
         compress
         delaycompress
         notifempty
         create 640 tomcat parablu
         sharedscripts
	}" > $LOGROTATE_D_PATH/mongodb
}

function mongo_backup ()
{
	mkdir -p $LOGROTATEROOTPATH/parablusys/bin/scripts
	chown -R root:root $LOGROTATEROOTPATH/parablusys/bin/*
        chmod -R 755 $LOGROTATEROOTPATH/parablusys/bin/*
	hr=`awk -v min=0 -v max=13 'BEGIN{srand(); print int(min+rand()*(max-min+1))}'`
	min=`awk -v min=0 -v max=50 'BEGIN{srand(); print int(min+rand()*(max-min+1))}'`

#	cp -r mongo_full_backup.sh $LOGROTATEROOTPATH/parablusys/bin/scripts

	croncmd="/parablu-scripts/Installable/scripts/mongo_full_backup.sh >> $LOG_PATH/mongodb/full_backup.log 2>&1"
	cronjob="$min $hr * * * $croncmd"
	( crontab -l | grep -v -F "$croncmd" ; echo "$cronjob" ) | crontab -
}


function restart_mongodb () 
{
	service mongod restart
	sleep 3s
}

# check whether mongodb is installed in the system
function verify_mongodb ()
{

	if [ ! -e /usr/bin/mongod  ]
	then
		echo "Mongodb Installation failed. Try again after some time"
		exit 0
	else
		echo "Mongodb Successfully installed"
	fi

}

function rollback_mongodb ()
{
	echo "Deleting mongodb"
	service mongod stop
	sudo apt-get -y --allow-unauthenticated purge mongodb-org*
	rm -rf /var/log/mongodb
	rm -rf /var/lib/mongodb
	rm -rf /etc/mongod.conf
	rm -rf $LOGROTATE_D_PATH/mongodb
	rm -rf $LOG_PATH/mongodb
        rm -rf $ARCHIVE_PATH/mongodb
	rm -rf $ROOT_PATH/installed_version
	rm -rf $DATA_PATH/mongodb
	rm -rf $LOGROTATEROOTPATH/parablusys
        rm -rf $LOGROTATEROOTPATH/parablusys
        rm -rf $LOGROTATEROOTPATH/parablusys/bin
}

# external function which deploys the mongodb
function release_mongodb ()
{
	prerequisite_mongodb 2>&1 >> install.log
	install_mongodb 2>&1 >> install.log
	configure_mongo_log 2>&1 >> install.log
	configure_mongo_logrotate 2>&1 >> install.log
	restart_mongodb 2>&1 >> install.log
	verify_mongodb 2>&1 >> install.log
}

