/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility.parablu001.blacklistuser;

import com.parablu.utility.parablu001.blacklistuser.BlackListUser;
import com.parablu.utility.parablu001.blacklistuser.BlackListUserRepository;
import com.parablu.utility.parablu001.blacklistuser.BlackListUserService;
import com.parablu.utility.parablu001.user.User;
import com.parablu.utility.parablu001.user.UserRepository;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BlackListUserServiceImpl
implements BlackListUserService {
    @Autowired
    BlackListUserRepository blackListUserRepository;
    @Autowired
    UserRepository userRepository;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public String getAllBlackListUsers() {
        StringBuilder builder = new StringBuilder();
        boolean displayData = false;
        builder.append("******************************BlackList Users******************************");
        Set all404BlackListUsers = this.blackListUserRepository.getAll404BlackListUsers();
        Set all404ActiveBlackListUsers = this.filterByActiveUser(all404BlackListUsers);
        if (!CollectionUtils.isEmpty((Collection)all404ActiveBlackListUsers)) {
            builder.append("\nUsers with 404 :");
            for (BlackListUser blackListUser : all404ActiveBlackListUsers) {
                builder.append("\n" + blackListUser.getUserName() + "\n");
                System.out.println("#####$$$$404 users  " + blackListUser.getUserName());
                this.LOG.info("#####$$$$404 users  " + blackListUser.getUserName());
            }
            displayData = true;
        }
        if (!CollectionUtils.isEmpty((Collection)this.blackListUserRepository.getAll429BlackListUsers())) {
            Set all429BlackListUsers = this.blackListUserRepository.getAll429BlackListUsers();
            Set all429ActiveBlackListUsers = this.filterByActiveUser(all429BlackListUsers);
            builder.append("\nUsers with 429 :");
            for (BlackListUser blackListUser : all429ActiveBlackListUsers) {
                builder.append("\n" + blackListUser.getUserName() + "\n");
                System.out.println("#####$$$$429 users  " + blackListUser.getUserName());
                this.LOG.info("#####$$$$429 users  " + blackListUser.getUserName());
            }
            displayData = true;
        }
        if (!CollectionUtils.isEmpty((Collection)this.blackListUserRepository.getAll503BlackListUsers())) {
            Set all503BlackListUsers = this.blackListUserRepository.getAll503BlackListUsers();
            Set all503ActiveBlackListUsers = this.filterByActiveUser(all503BlackListUsers);
            builder.append("\nUsers with 503 :");
            for (BlackListUser blackListUser : all503ActiveBlackListUsers) {
                builder.append("\n" + blackListUser.getUserName() + "\n");
                System.out.println("#####$$$$503 users  " + blackListUser.getUserName());
                this.LOG.info("#####$$$$503 users  " + blackListUser.getUserName());
            }
            displayData = true;
        }
        builder.append("******************************BlackList Users******************************");
        if (!displayData) {
            builder = new StringBuilder("");
        }
        return builder.toString();
    }

    private Set<BlackListUser> filterByActiveUser(Set<BlackListUser> allBlackListUsers) {
        HashSet<BlackListUser> all404ActiveBlackListUsers = new HashSet<BlackListUser>();
        if (!CollectionUtils.isEmpty(allBlackListUsers)) {
            System.out.println("all404BlackListUsers ..." + allBlackListUsers.size());
            for (BlackListUser blackListUser : allBlackListUsers) {
                User user = this.userRepository.findByUserNameLowerCase(blackListUser.getUserName().toLowerCase());
                if (user == null || !user.isActive()) continue;
                all404ActiveBlackListUsers.add(blackListUser);
            }
        }
        return all404ActiveBlackListUsers;
    }
}

