
#!/bin/bash
#                                                                                       #
# SCRIPT: ubuntu_service.sh		                                                #
# DATE:   27-Oct-2016                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems								#
# DEVELOPER: Vaibhav K
# PURPOSE: Contains all the utility functions for Ubuntu platform                       #
# PLATFORM: Ubuntu                                                                      #

# Adding tomcat and www-data users to parablu group
PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh

function add_system_users()
{
	# for tomcat-user
	useradd tomcat
	# for parablu group
	addgroup parablu
	#link parablu to tomcat
	adduser tomcat parablu
	#link www-data to parablu
	adduser www-data parablu
}

# Install openssh-server, bash-completion, zip, ufw, telnet, traceroute, sysstat 
function install_common_packages () 
{
	#system Update/Upgrade
#	apt-get -y --allow-unauthenticated update 
#	apt-get -y upgrade 
#	echo 'Y' | apt-get -f install

	#common packages for ubunut server
	apt-get -y install openssh-server 
	apt-get -y install bash-completion 
	apt-get -y install zip 
	apt-get -y install ufw 
	apt-get -y install telnet 
	apt-get -y install iptables
	apt-get -y install haveged

	allow_network_firewall 
	apt-get -y install telnet 
	apt-get -y install traceroute 
	apt-get -y install sysstat 
}

#Enable network port
function allow_network_firewall ()
{
	echo 'y' | ufw enable                                             
      	ufw allow ssh
      	ufw allow https
#      	ufw allow http  
#      	ufw allow 5984
}

#install jre
function install_jre ()
{
	echo "JRE is installed using deb package"
	#Java
#	apt-get -y install software-properties-common 
#	apt-get -y install python3-software-properties 
#	add-apt-repository -y ppa:openjdk-r/ppa 
#	apt-get -y --allow-unauthenticated update 
#	apt-get -y install openjdk-8-jre 
	cp ../installables/local_policy.jar /usr/lib/jvm/java-1.8.0-openjdk-amd64/jre/lib/security
	cp ../installables/US_export_policy.jar /usr/lib/jvm/java-1.8.0-openjdk-amd64/jre/lib/security
	echo 'Y'| apt-get -f install
	sudo dpkg --purge --force-depends ca-certificates-java
	echo 'Y'| apt-get -f install
	sudo apt-get -y install ca-certificates-java
}

function install_rar ()
{
                cur_dir=`pwd`
                cd $DEFAULT_FILE_PATH
                #wget rarlab.com/rar/rarlinux-x64-5.1.1.tar.gz
                tar -xzvf ../installables/rarlinux-x64-5.1.1.tar.gz
                cd rar
                sudo make install
                cd $cur_dir

}

function create_ssh_user ()
{
        if [ "$SSH_USERNAME" == "root" ];then
                echo "Skipping SSH User Creation"
        else

                tput clear
                echo "                                 =========================CREATING SSH USER $SSH_USERNAME==================== "
                adduser $SSH_USERNAME
                usermod -aG sudo $SSH_USERNAME
                chage -m 0 -M 99999 -I -1 -E -1 $SSH_USERNAME

#                echo $SSH_USERNAME Created
        fi

##Setting Timezone
timedatectl set-timezone Asia/Kolkata
sleep 5s
service cron restart
}

function enable_backblaze ()
{

present_dir=`pwd`

        cd utilities/BACKBLAZE_INSTALLABLE
        bash backblaze_install.sh
        cd $present_dir

}

function enable_msjob ()
{
tput clear
                echo "                                 =========================MSJOB PROJECT==================== "
read -p "Do you want to enable NEW MICROSOFT ONE DRIVE FOR BACKUP: [ y/n]" confirmmsjob

#### INVALID CHECK

	while [[ "$confirmmsjob" != "N" ]] && [[ "$confirmmsjob" != "y" ]] && [[ "$confirmmsjob" != "Y" ]] && [[ "$confirmmsjob" != "n" ]]; do
        	echo ""
                echo "INVALID INPUT"
                echo ""
                read -p "Do you want to enable NEW MICROSOFT ONE DRIVE FOR BACKUP: [ y/n]" confirmmsjob
                echo ""
        done


if [[ $confirmmsjob = y ]] || [[ $confirmmsjob = Y ]]; then

	read -p "Enter Number of MICROSOFT ONE DRIVE BACKUP USERS:" msjobusers
	EXCLUDE_MSJOB="false"
	sleep 1s
	sed -i "s|ODBUSER_PLACEHOLDER|$msjobusers|" ../installables/js/msjob_policy.js	
	sed -i "/EXCLUDE_MSJOB/d" $PARABLU_COMPONENT_SCRIPT_PATH
	echo "EXCLUDE_MSJOB=\"false\"" >> $PARABLU_COMPONENT_SCRIPT_PATH

	
	####MS EXCHANGE
	read -p "Do you want to enable Exchange Backup: [ y/n]" confirmmsexchange

	#### INVALID CHECK

        while [[ "$confirmmsexchange" != "N" ]] && [[ "$confirmmsexchange" != "y" ]] && [[ "$confirmmsexchange" != "Y" ]] && [[ "$confirmmsexchange" != "n" ]]; do
                echo ""
                echo "INVALID INPUT"
                echo ""
                read -p "Do you want to enable Exchange Backup: [ y/n]" confirmmsexchange
                echo ""
        done

	if [[ $confirmmsexchange = y ]] || [[ $confirmmsexchange = y ]]; then

		EXCHANGEBACKUP="true"
	else

		EXCHANGEBACKUP="false"
	fi

fi
if [[ $confirmmsjob = n ]] || [[ $confirmmsjob = N ]]; then
        EXCLUDE_MSJOB="true"
        sed -i "/EXCLUDE_MSJOB/d" $PARABLU_COMPONENT_SCRIPT_PATH
        echo "EXCLUDE_MSJOB=\"true\"" >> $PARABLU_COMPONENT_SCRIPT_PATH
fi
}
