#!/bin/bash
# DEVELOPER: Vaibhav K
PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh

source $PARABLU_CONFIG_SCRIPT_PATH


current_dir=`pwd`

croncmd="cd $current_dir && ./exec_summary.sh"
#croncmd1="cd $current_dir && ./new_executive_summary.sh"
croncmd2="cd $current_dir/health_check && ./health_check.sh"
croncmd3="cd $current_dir/health_check && ./statistics_collector.sh"
croncmd4="cd $current_dir/utilities && ./updateStorageMismatch.sh"
croncmd5="cd $current_dir/utilities && ./delete_azure_logs.sh"
croncmd6="cd $current_dir && ./job_disable.sh"
croncmd7="cd $current_dir && ./job_enable.sh"
croncmd9="cd $current_dir && ./restart_service_cron.sh >> /parablu/log/restart_cron.log 2>&1"
croncmd8="cd $current_dir && ./backblaze_serverupgrade.sh >> /parablu/bblaze.log 2>&1"
croncmd11="cd $current_dir/PULL_LOGS && ./pull_logs.sh >> /parablu/pull_logs.log 2>&1"
croncmd12="cd $current_dir && ./backblaze_scriptutil.sh >> /parablu/bblazeutils.log 2>&1"
croncmd10="sleep 60 && cd /parablu-scripts/Installable/scripts/ && echo 'y' | bash service-parablu.sh start >> /parablu/cronreboot.log 2>&1"
croncmd13="/var/lib/parablusys/bin/moveToArchive.sh >> /var/lib/parablusys/bin/moveToArchive.log 2>&1"
croncmd14=" /var/lib/parablusys/bin/archive_backup_v2.sh >> /var/lib/parablusys/bin/archive_backup_v2.log 2>&1"

cronjob="0 8 * * * $croncmd"
#cronjob1="15 8 * * * $croncmd1"
cronjob2="*/30 * * * * $croncmd2"
cronjob3="*/30 * * * * $croncmd3"
cronjob4="0 7 * * * $croncmd4"
cronjob5="0 */4 * * * $croncmd5"
cronjob6="#0 18 * * * $croncmd6"
cronjob7="#0 8 * * * $croncmd7"
cronjob9="0 2 * * * $croncmd9"
cronjob8="0 23 * * * $croncmd8"
cronjob11="0 */1 * * * $croncmd11"
cronjob12="0 */1 * * * $croncmd12"
cronjob10="@reboot $croncmd10"
cronjob13="5 23 * * * $croncmd13"
cronjob14="5 2 * * *  $croncmd14"

function enable_executive_summary ()
{

	if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then	
     		( crontab -l | grep -v -F "$croncmd" ; echo "$cronjob" ) | crontab -

#     		if [ "$PRODUCT_TYPE" == "1 2" ] || [ "$PRODUCT_TYPE" == "2" ]; then

 #    			( crontab -l | grep -v -F "$croncmd1" ; echo "$cronjob1" ) | crontab -
#	     	fi
	fi
}


function enable_watchdog ()
{

	( crontab -l | grep -v -F "$croncmd2" ; echo "$cronjob2" ) | crontab -

	if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "3" ]] || [[ "$SERVER_TYPE" == "3 1" ]]; then
		( crontab -l | grep -v -F "$croncmd3" ; echo "$cronjob3" ) | crontab -
	fi
}

function enable_pg_check ()
{
	if [[ "$SERVER_TYPE" == "3" ]]; then
	        ( crontab -l | grep -v -F "$croncmd4" ; echo "$cronjob4" ) | crontab -
	fi

}

function enable_storage_size_update ()
{


        if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "3" ]]; then
                ( crontab -l | grep -v -F "$croncmd4" ; echo "$cronjob4" ) | crontab -
        fi
}

function enable_azure_logs_cleanup ()
{

	( crontab -l | grep -v -F "$croncmd5" ; echo "$cronjob5" ) | crontab -

}

function job_disable_enable ()
{

        if [[ "$SERVER_TYPE" == "0" ]] || [[ "$SERVER_TYPE" == "1 2" ]] || [[ "$SERVER_TYPE" == "2" ]] || [[ "$SERVER_TYPE" == "3 1" ]]; then
                ( crontab -l | grep -v -F "$croncmd6" ; echo "$cronjob6" ) | crontab -
                ( crontab -l | grep -v -F "$croncmd7" ; echo "$cronjob7" ) | crontab -
        fi

}

function restart_service_enable ()
{
	( crontab -l | grep -v -F "$croncmd9" ; echo "$cronjob9" ) | crontab -

	( crontab -l | grep -v -F "$croncmd10" ; echo "$cronjob10" ) | crontab -
}

function enable_backblaze_patch_upgrade ()
{
	( crontab -l | grep -v -F "$croncmd8" ; echo "$cronjob8" ) | crontab -

}

function enable_pull_logs ()
{

        if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "3" ] || [ "$SERVER_TYPE" == "3 1" ] ; then
                ( crontab -l | grep -v -F "$croncmd11" ; echo "$cronjob11" ) | crontab -

        fi
}

function enable_bbscript_utils ()
{

	if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "3" ]; then

		( crontab -l | grep -v -F "$croncmd12" ; echo "$cronjob12" ) | crontab -
	fi

}
function release_reports ()
{
	enable_executive_summary
	enable_watchdog
#	enable_storage_size_update
	enable_azure_logs_cleanup
#	enable_pg_check
	job_disable_enable
	restart_service_enable
	enable_backblaze_patch_upgrade
	enable_pull_logs
	enable_bbscript_utils

}

release_reports
