/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.solr.BaseDistributedSearchTestCase;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.Diagnostics;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.KeeperException;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDistribZkTestBase
extends BaseDistributedSearchTestCase {
    private static final String REMOVE_VERSION_FIELD = "remove.version.field";
    private static final String ENABLE_UPDATE_LOG = "enable.update.log";
    private static final String ZK_HOST = "zkHost";
    private static final String ZOOKEEPER_FORCE_SYNC = "zookeeper.forceSync";
    protected static final String DEFAULT_COLLECTION = "collection1";
    protected volatile ZkTestServer zkServer;
    private AtomicInteger homeCount = new AtomicInteger();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @BeforeClass
    public static void beforeThisClass() throws Exception {
    }

    @Override
    public void distribSetUp() throws Exception {
        super.distribSetUp();
        String zkDir = this.testDir.getAbsolutePath() + File.separator + "zookeeper/server1/data";
        this.zkServer = new ZkTestServer(zkDir);
        this.zkServer.run();
        System.setProperty(ZK_HOST, this.zkServer.getZkAddress());
        System.setProperty(ENABLE_UPDATE_LOG, "true");
        System.setProperty(REMOVE_VERSION_FIELD, "true");
        System.setProperty(ZOOKEEPER_FORCE_SYNC, "false");
        System.setProperty("solr.tests.allow_reading_files_still_open_for_write", "true");
        String schema = this.getCloudSchemaFile();
        if (schema == null) {
            schema = "schema.xml";
        }
        this.zkServer.buildZooKeeper(this.getCloudSolrConfig(), schema);
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
    }

    protected String getCloudSolrConfig() {
        return "solrconfig-tlog.xml";
    }

    protected String getCloudSchemaFile() {
        return AbstractDistribZkTestBase.getSchemaFile();
    }

    @Override
    protected void createServers(int numShards) throws Exception {
        File controlHome = new File(new File(this.getSolrHome()).getParentFile(), "control" + this.homeCount.incrementAndGet());
        FileUtils.copyDirectory((File)new File(this.getSolrHome()), (File)controlHome);
        this.setupJettySolrHome(controlHome);
        this.controlJetty = this.createJetty(controlHome, null);
        this.controlJetty.start();
        this.controlClient = this.createNewSolrClient(this.controlJetty.getLocalPort());
        AbstractDistribZkTestBase.assertTrue((boolean)((CollectionAdminResponse)CollectionAdminRequest.createCollection((String)"control_collection", (int)1, (int)1).setCreateNodeSet(this.controlJetty.getNodeName()).process(this.controlClient)).isSuccess());
        ZkStateReader zkStateReader = ((JettySolrRunner)this.jettys.get(0)).getCoreContainer().getZkController().getZkStateReader();
        AbstractDistribZkTestBase.waitForRecoveriesToFinish("control_collection", zkStateReader, false, true, 15L);
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= numShards; ++i) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            File jettyHome = new File(new File(this.getSolrHome()).getParentFile(), "jetty" + this.homeCount.incrementAndGet());
            this.setupJettySolrHome(jettyHome);
            JettySolrRunner j = this.createJetty(jettyHome, null, "shard" + (i + 2));
            j.start();
            this.jettys.add(j);
            this.clients.add(this.createNewSolrClient(j.getLocalPort()));
            sb.append(this.buildUrl(j.getLocalPort()));
        }
        this.shards = sb.toString();
    }

    protected void waitForRecoveriesToFinish(String collection, ZkStateReader zkStateReader, boolean verbose) throws Exception {
        this.waitForRecoveriesToFinish(collection, zkStateReader, verbose, true);
    }

    protected void waitForRecoveriesToFinish(String collection, ZkStateReader zkStateReader, boolean verbose, boolean failOnTimeout) throws Exception {
        AbstractDistribZkTestBase.waitForRecoveriesToFinish(collection, zkStateReader, verbose, failOnTimeout, 330L);
    }

    public static void waitForRecoveriesToFinish(String collection, ZkStateReader zkStateReader, boolean verbose, boolean failOnTimeout, long timeoutSeconds) throws Exception {
        log.info("Wait for recoveries to finish - collection: " + collection + " failOnTimeout:" + failOnTimeout + " timeout (sec):" + timeoutSeconds);
        try {
            zkStateReader.waitForState(collection, timeoutSeconds, TimeUnit.SECONDS, (liveNodes, docCollection) -> {
                if (docCollection == null) {
                    return false;
                }
                boolean sawLiveRecovering = false;
                AbstractDistribZkTestBase.assertNotNull((String)("Could not find collection:" + collection), (Object)docCollection);
                Map slices = docCollection.getSlicesMap();
                AbstractDistribZkTestBase.assertNotNull((String)("Could not find collection:" + collection), (Object)slices);
                for (Map.Entry entry : slices.entrySet()) {
                    Slice slice = (Slice)entry.getValue();
                    if (slice.getState() == Slice.State.CONSTRUCTION) {
                        if (verbose) {
                            System.out.println("Found a slice in construction state; will wait.");
                        }
                        sawLiveRecovering = true;
                    }
                    Map shards = slice.getReplicasMap();
                    for (Map.Entry shard : shards.entrySet()) {
                        Replica.State state;
                        if (verbose) {
                            System.out.println("replica:" + ((Replica)shard.getValue()).getName() + " rstate:" + ((Replica)shard.getValue()).getStr("state") + " live:" + liveNodes.contains(((Replica)shard.getValue()).getNodeName()));
                        }
                        if ((state = ((Replica)shard.getValue()).getState()) != Replica.State.RECOVERING && state != Replica.State.DOWN && state != Replica.State.RECOVERY_FAILED || !liveNodes.contains(((Replica)shard.getValue()).getStr("node_name"))) continue;
                        return false;
                    }
                }
                if (!sawLiveRecovering) {
                    if (!sawLiveRecovering) {
                        if (verbose) {
                            System.out.println("no one is recoverying");
                        }
                    } else {
                        if (verbose) {
                            System.out.println("Gave up waiting for recovery to finish..");
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            });
        }
        catch (InterruptedException | TimeoutException e) {
            Diagnostics.logThreadDumps((String)"Gave up waiting for recovery to finish.  THREAD DUMP:");
            zkStateReader.getZkClient().printLayoutToStdOut();
            AbstractDistribZkTestBase.fail((String)("There are still nodes recoverying - waited for " + timeoutSeconds + " seconds"));
        }
        log.info("Recoveries finished - collection: " + collection);
    }

    public static void waitForCollectionToDisappear(String collection, ZkStateReader zkStateReader, boolean verbose, boolean failOnTimeout, int timeoutSeconds) throws Exception {
        log.info("Wait for collection to disappear - collection: " + collection + " failOnTimeout:" + failOnTimeout + " timeout (sec):" + timeoutSeconds);
        zkStateReader.waitForState(collection, (long)timeoutSeconds, TimeUnit.SECONDS, (liveNodes, docCollection) -> docCollection == null);
        log.info("Collection has disappeared - collection: " + collection);
    }

    static void waitForNewLeader(CloudSolrClient cloudClient, String shardName, Replica oldLeader, TimeOut timeOut) throws Exception {
        Slice slice;
        log.info("Will wait for a node to become leader for {} secs", (Object)timeOut.timeLeft(TimeUnit.SECONDS));
        ZkStateReader zkStateReader = cloudClient.getZkStateReader();
        zkStateReader.forceUpdateCollection(DEFAULT_COLLECTION);
        while (true) {
            ClusterState clusterState;
            DocCollection coll;
            if ((slice = (coll = (clusterState = zkStateReader.getClusterState()).getCollection(DEFAULT_COLLECTION)).getSlice(shardName)).getLeader() != null && !slice.getLeader().equals((Object)oldLeader) && slice.getLeader().getState() == Replica.State.ACTIVE) break;
            if (timeOut.hasTimedOut()) {
                Diagnostics.logThreadDumps((String)"Could not find new leader in specified timeout");
                zkStateReader.getZkClient().printLayoutToStdOut();
                AbstractDistribZkTestBase.fail((String)("Could not find new leader even after waiting for " + timeOut.timeElapsed(TimeUnit.MILLISECONDS) + "ms"));
            }
            Thread.sleep(100L);
        }
        log.info("Old leader {}, new leader {}. New leader got elected in {} ms", new Object[]{oldLeader, slice.getLeader(), timeOut.timeElapsed(TimeUnit.MILLISECONDS)});
        zkStateReader.waitForState(DEFAULT_COLLECTION, timeOut.timeLeft(TimeUnit.SECONDS), TimeUnit.SECONDS, (liveNodes, docCollection) -> {
            if (docCollection == null) {
                return false;
            }
            Slice slice = docCollection.getSlice(shardName);
            if (slice != null && slice.getLeader() != null && !slice.getLeader().equals((Object)oldLeader) && slice.getLeader().getState() == Replica.State.ACTIVE) {
                log.info("Old leader {}, new leader {}. New leader got elected in {} ms", new Object[]{oldLeader, slice.getLeader(), timeOut.timeElapsed(TimeUnit.MILLISECONDS)});
                return true;
            }
            return false;
        });
    }

    public static void verifyReplicaStatus(ZkStateReader reader, String collection, String shard, String coreNodeName, Replica.State expectedState) throws InterruptedException, TimeoutException {
        reader.waitForState(collection, 15000L, TimeUnit.MILLISECONDS, (liveNodes, collectionState) -> collectionState != null && collectionState.getSlice(shard) != null && collectionState.getSlice(shard).getReplicasMap().get(coreNodeName) != null && ((Replica)collectionState.getSlice(shard).getReplicasMap().get(coreNodeName)).getState() == expectedState);
    }

    protected static void assertAllActive(String collection, ZkStateReader zkStateReader) throws KeeperException, InterruptedException {
        zkStateReader.forceUpdateCollection(collection);
        ClusterState clusterState = zkStateReader.getClusterState();
        DocCollection docCollection = clusterState.getCollectionOrNull(collection);
        if (docCollection == null || docCollection.getSlices() == null) {
            throw new IllegalArgumentException("Cannot find collection:" + collection);
        }
        Map slices = docCollection.getSlicesMap();
        for (Map.Entry entry : slices.entrySet()) {
            Slice slice = (Slice)entry.getValue();
            if (slice.getState() != Slice.State.ACTIVE) {
                AbstractDistribZkTestBase.fail((String)("Not all shards are ACTIVE - found a shard " + slice.getName() + " that is: " + slice.getState()));
            }
            Map shards = slice.getReplicasMap();
            for (Map.Entry shard : shards.entrySet()) {
                Replica replica = (Replica)shard.getValue();
                if (replica.getState() == Replica.State.ACTIVE) continue;
                AbstractDistribZkTestBase.fail((String)("Not all replicas are ACTIVE - found a replica " + replica.getName() + " that is: " + replica.getState()));
            }
        }
    }

    @Override
    public void distribTearDown() throws Exception {
        AbstractDistribZkTestBase.resetExceptionIgnores();
        try {
            this.zkServer.shutdown();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception shutting down Zk Test Server.", e);
        }
        finally {
            try {
                super.distribTearDown();
            }
            finally {
                System.clearProperty(ZK_HOST);
                System.clearProperty("collection");
                System.clearProperty(ENABLE_UPDATE_LOG);
                System.clearProperty(REMOVE_VERSION_FIELD);
                System.clearProperty("solr.directoryFactory");
                System.clearProperty("solr.test.sys.prop1");
                System.clearProperty("solr.test.sys.prop2");
                System.clearProperty(ZOOKEEPER_FORCE_SYNC);
                System.clearProperty("solr.tests.allow_reading_files_still_open_for_write");
            }
        }
    }

    protected void printLayout() throws Exception {
        SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkHost(), 45000);
        zkClient.printLayoutToStdOut();
        zkClient.close();
    }

    protected void restartZk(int pauseMillis) throws Exception {
        log.info("Restarting ZK with a pause of {}ms in between", (Object)pauseMillis);
        this.zkServer.shutdown();
        Thread.sleep(pauseMillis);
        this.zkServer = new ZkTestServer(this.zkServer.getZkDir(), this.zkServer.getPort());
        this.zkServer.run(false);
    }
}

