#!/bin/bash
#                                                                                       #
# SCRIPT: bluvault_service.sh		                                                #
# DATE:   27-Oct-2016                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems								#
# PURPOSE: Contains all the utility functions for bluvault Installation                 #
# PLATFORM: Ubuntu                                                                      #

TOMCAT_SERVICE_SCRIPT_PATH=./tomcat_service.sh
APACHE_SERVICE_SCRIPT_PATH=./apache_service.sh
PHP_SERVICE_SCRIPT_PATH=./php_service.sh
MEMCACHED_SERVICE_SCRIPT_PATH=./memcached_service.sh
UBUNTU_SERVICE_SCRIPT_PATH=./ubuntu_service.sh
PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh
PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh
PORTAL_SERVICE_SCRIPT_PATH=./portal_service.sh
source $PORTAL_SERVICE_SCRIPT_PATH
source $PARABLU_COMPONENT_SCRIPT_PATH
source $UBUNTU_SERVICE_SCRIPT_PATH
source $TOMCAT_SERVICE_SCRIPT_PATH
source $APACHE_SERVICE_SCRIPT_PATH
source $PHP_SERVICE_SCRIPT_PATH
source $MEMCACHED_SERVICE_SCRIPT_PATH
source $PARABLU_CONFIG_SCRIPT_PATH

#deploy war files to tomcat
function deploy_bluvault_war_to_tomcat ()
{
# this will create 2 directories for backup wars and deploy wars
#mkdir -p $BACKUP_OLD
#mkdir -p $BACKUP_NEW

	if [[ $FILE_LOCATION == "jenkins" ]]; then
		wget -P $FILE_PATH $JENKINS_URL/$BLUVAULT_URL_PATH
		wget -P $FILE_PATH $JENKINS_URL/$SUPPORT_URL_PATH
		wget -P $FILE_PATH $JENKINS_URL/$PARAMAIL_URL_PATH
	elif [[ $FILE_LOCATION == "dns" ]]; then
		wget --user $DNS_USERNAME --password $DNS_PASS -O $FILE_PATH/$BLUVAULT_WAR $DNS_URL/$BLUVAULT_WAR
		wget --user $DNS_USERNAME --password $DNS_PASS -O $FILE_PATH/$SUPPORT_WAR $DNS_URL/$SUPPORT_WAR
		wget --user $DNS_USERNAME --password $DNS_PASS -O $FILE_PATH/$PARAMAIL_WAR $DNS_URL/$PARAMAIL_WAR		
	elif [[ $FILE_LOCATION == "local" ]]; then
		echo "Files are already unzipped from patch"
	else
		echo "Enter the config file and start the script again."
		exit
	fi

	#backing-up old deploy
	#mkdir -p $BACKUP_OLD
	if [ -e $TOMCAT_PCB1_PATH/webapps/$BLUVAULT ] && [ -e $TOMCAT_PCB1_PATH/webapps/$SUPPORT ] && [ -e $TOMCAT_PCB1_PATH/webapps/$PARAMAIL ]; then
		cp -r $TOMCAT_PCB1_PATH/webapps/$BLUVAULT  $BACKUP_OLD
		cp -r $TOMCAT_PCB1_PATH/webapps/$SUPPORT  $BACKUP_OLD
		cp -r $TOMCAT_PCB1_PATH/webapps/$PARAMAIL  $BACKUP_OLD
	fi

	#moving the new downloaded war_file
	unzip -oqq $FILE_PATH/$BLUVAULT_WAR -d $TOMCAT_PCB1_PATH/webapps/$BLUVAULT
	unzip -oqq $FILE_PATH/$SUPPORT_WAR -d $TOMCAT_PCB1_PATH/webapps/$SUPPORT
	unzip -oqq $FILE_PATH/$PARAMAIL_WAR -d $TOMCAT_PCB1_PATH/webapps/$PARAMAIL
	sleep 3
}


function deploy_bluvault_job_war_to_tomcat ()
{

	if [[ $FILE_LOCATION == "jenkins" ]]; then
		wget -P $FILE_PATH $JENKINS_URL/$BLUVAULT_JOB_URL_PATH
	elif [[ $FILE_LOCATION == "dns" ]]; then
		wget --user $DNS_USERNAME --password $DNS_PASS -O $FILE_PATH/$BLUVAULT_JOB_WAR $DNS_URL/$BLUVAULT_JOB_WAR		
	elif [[ $FILE_LOCATION == "local" ]]; then
		echo "Files are already unzipped from patch"
	else
		echo "Enter the config file and start the script again."
		exit
	fi

	#backing-up old deploy
	if [ -e $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB ]; then
		cp -r $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB  $BACKUP_OLD
	fi

	#moving the new downloaded war_file
	unzip -oqq $FILE_PATH/$BLUVAULT_JOB_WAR -d $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB
	
}



function configure_bluvault_war_in_tomcat ()
{
	echo "Executing PCB changes....,"
	PROPERTIES_FILE=WEB-INF/classes/pb-credential.properties
	CLOUD_PROPERTY_FILE=WEB-INF/classes/pb-cloudproperty.properties
	CLOUD_AZURE_PROPERTY_FILE=WEB-INF/classes/pb-cloudproperty-azure.properties
	chmod -R 777 $TOMCAT_PCB1_PATH/webapps/$BLUVAULT
	chmod -R 777 $TOMCAT_PCB1_PATH/webapps/$SUPPORT
	chmod -R 777 $TOMCAT_PCB1_PATH/webapps/$PARAMAIL
	
	sed -i 's|/mnt|/parablu|' $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$CLOUD_AZURE_PROPERTY_FILE
        sed -i 's|/mnt|/parablu|' $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
	sed -i 's|/mnt|/parablu|' $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$CLOUD_PROPERTY_FILE
	sed -i "/db_port/d" $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	sed -i "/db_host/d" $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	sed -i "/db_port1/d" $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	sed -i "/db_host1/d" $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	sed -i "/db_port2/d" $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	sed -i "/db_host2/d" $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	sed -i "/db_port3/d" $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	sed -i "/db_host3/d" $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE

	if [ "`grep -o 'db_port' $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	then
		echo "db_port=$MONGODB_PORT" >> $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	fi

	if [ "`grep -o 'db_host' $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	then
		echo "db_host=$DB_IP" >> $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	fi

	#DB1 and PORT1
	if [ "`grep -o 'db_port1' $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	then
		echo "db_port1=$MONGODB1_PORT" >> $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	fi

	if [ "`grep -o 'db_host1' $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	then
		echo "db_host1=$DB1_IP" >> $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	fi

	#DB2 and PORT2
	if [ "`grep -o 'db_port2' $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	then
		echo "db_port2=$MONGODB2_PORT" >> $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	fi

	if [ "`grep -o 'db_host2' $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	then
		echo "db_host2=$DB2_IP" >> $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	fi
	#DB3 and PORT3
	if [ "`grep -o 'db_host3' $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	then
		echo "db_port3=$MONGODB3_PORT" >> $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	fi

	if [ "`grep -o 'db_host3' $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE | wc -l`" -le 0 ]
	then
		echo "db_host3=$DB3_IP" >> $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$PROPERTIES_FILE
	fi

	#Cloud-prop
	sed -i "/paracloudUrl=/d" $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$CLOUD_PROPERTY_FILE
	if [ "`grep -o 'paracloudUrl' $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$CLOUD_PROPERTY_FILE | wc -l`" -le 0 ]
	then
		echo "paracloudUrl=$BLUVAULT1_URL" >> $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$CLOUD_PROPERTY_FILE
	fi

	sed -i "/solrUrl=/d" $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$CLOUD_PROPERTY_FILE
	if [ "`grep -o 'solrUrl' $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$CLOUD_PROPERTY_FILE | wc -l`" -le 0 ]
	then
		echo "solrUrl=http://$SOLR_URL/ParacloudSearch/search/" >> $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$CLOUD_PROPERTY_FILE
	fi

	#Support
	sed -i "/db_port/d" $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
	sed -i "/db_host/d" $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
	sed -i "/db_port1/d" $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
	sed -i "/db_host1/d" $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
	sed -i "/db_port2/d" $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
	sed -i "/db_host2/d" $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
	sed -i "/db_port3/d" $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
	sed -i "/db_host3/d" $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
	sed -i "/paracloudUrl=/d"  $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE

	 if [ "`grep -o 'db_port' $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
                echo "db_port=$MONGODB_PORT" >> $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
        fi

        if [ "`grep -o 'db_host' $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
                echo "db_host=$DB_IP" >> $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
        fi

        #DB1 and PORT1
        if [ "`grep -o 'db_port1' $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
                echo "db_port1=$MONGODB1_PORT" >> $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
        fi

        if [ "`grep -o 'db_host1' $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
                echo "db_host1=$DB1_IP" >> $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
        fi
        #DB2 and PORT2
        if [ "`grep -o 'db_port2' $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
                echo "db_port2=$MONGODB2_PORT" >> $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
        fi

        if [ "`grep -o 'db_host2' $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
                echo "db_host2=$DB2_IP" >> $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
        fi

	 
	if [ "`grep -o 'db_port3' $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
		echo "db_port3=$MONGODB3_PORT" >> $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
	fi

	if [ "`grep -o 'db_host3' $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
        	echo "db_host3=$DB3_IP" >> $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
	fi

	if [ "`grep -o 'paracloudUrl' $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
        	echo "paracloudUrl=$BLUVAULT1_URL" >> $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$PROPERTIES_FILE
	fi

	sed -i "/db_port/d" $TOMCAT_PCB1_PATH/webapps/$PARAMAIL/$PROPERTIES_FILE
	sed -i "/db_host/d" $TOMCAT_PCB1_PATH/webapps/$PARAMAIL/$PROPERTIES_FILE
	sed -i "/paracloudUrl/d" $TOMCAT_PCB1_PATH/webapps/$PARAMAIL/$PROPERTIES_FILE
	
 	echo "db_port=$MONGODB_PORT" >> $TOMCAT_PCB1_PATH/webapps/$PARAMAIL/$PROPERTIES_FILE

        echo "db_host=$DB_IP" >> $TOMCAT_PCB1_PATH/webapps/$PARAMAIL/$PROPERTIES_FILE
	
	if [ "`grep -o 'paracloudUrl' $TOMCAT_PCB1_PATH/webapps/$PARAMAIL/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
       	 	echo "paracloudUrl=$BLUVAULT1_URL" >> $TOMCAT_PCB1_PATH/webapps/$PARAMAIL/$PROPERTIES_FILE
	fi


}

#configure the pcb job property values
function configure_bluvault_job_war_in_tomcat ()
{
	echo "Executing PCB Job changes...."
	##########paths

	PROPERTIES_FILE=WEB-INF/classes/pb-credential.properties
	CLOUD_PROPERTY_FILE=WEB-INF/classes/pb-cloudproperty.properties
	#######starting Changes
	chmod -R 777 $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB

	sed -i 's|/mnt|/parablu|' $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB/$CLOUD_PROPERTY_FILE
	sed -i "/paracloudUrl=/d" $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB/$PROPERTIES_FILE
	sed -i "/db_port=/d" $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB/$PROPERTIES_FILE
	sed -i "/db_host=/d" $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB/$PROPERTIES_FILE

	if [ "`grep -o 'paracloudUrl' $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
 		echo "paracloudUrl=https://$BLUVAULT_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB/$PROPERTIES_FILE
	fi

	if [ "`grep -o 'db_port' $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
       	 	echo "db_port=$MONGODB_PORT" >> $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB/$PROPERTIES_FILE
	fi

	if [ "`grep -o 'db_host' $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
        	echo "db_host=$DB_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB/$PROPERTIES_FILE
	fi
}

#deploy job repo to tomcat
function deploy_bluvault_job_repo_to_tomcat ()
{
	if [ ! -e $TOMCAT_JOB1_PATH/conf/server.xml ] 
	then
		cp $TOMCAT_PATH/conf/server.xml $TOMCAT_JOB1_PATH/conf/
	fi
	if [ ! -e $TOMCAT_JOB1_PATH/conf/web.xml ] 
	then
		cp $TOMCAT_PATH/conf/web.xml $TOMCAT_JOB1_PATH/conf/
	fi

	if [[ $FILE_LOCATION == "jenkins" ]]; then
                wget -P $TOMCAT_JOB1_PATH/$REPO_NAME/ $JENKINS_URL/$JAR_URL_PATH
	elif [[ $FILE_LOCATION == "dns" ]]; then
                wget --user $DNS_USERNAME --password $DNS_PASS -O $TOMCAT_JOB1_PATH/$REPO_NAME/$JAR_NAME $DNS_URL/$JAR_NAME
    	elif [[ $FILE_LOCATION == "local" ]]; then
             #will be included in file path once repo is part of patch, so currently downloading from DNS  
              cp $FILE_PATH/$JAR_NAME $TOMCAT_JOB1_PATH/$REPO_NAME/$JAR_NAME
            # wget --user $DNS_USERNAME --password $DNS_PASS -O $TOMCAT_JOB1_PATH/$REPO_NAME/$JAR_NAME $DNS_URL/$JAR_NAME
	fi

	 if [ -e $TOMCAT_JOB1_PATH/$REPO_NAME ]; then
		 mkdir -p $BACKUP_OLD/REPO_JOB_PG
		 cp -r $TOMCAT_JOB1_PATH/$REPO_NAME  $BACKUP_OLD/REPO_JOB_PG
             #    rm $TOMCAT_JOB1_PATH/$REPO_NAME/*.jar
        fi

	if [ ! -e $TOMCAT_JOB1_PATH/$REPO_NAME/$JAR_NAME ]
        then
	         echo "Invalid Repo Jar Name"
	         
        fi

	unzip -oqq $TOMCAT_JOB1_PATH/$REPO_NAME/$JAR_NAME -d $TOMCAT_JOB1_PATH/$REPO_NAME/

	if [[ -d $TOMCAT_JOB1_PATH/$REPO_NAME/$REPO_JAR_FOLDER_NAME ]]; then
		mv $TOMCAT_JOB1_PATH/$REPO_NAME/$REPO_JAR_FOLDER_NAME/* $TOMCAT_JOB1_PATH/$REPO_NAME/
		rm -rf $TOMCAT_JOB1_PATH/$REPO_NAME/$REPO_JAR_FOLDER_NAME
		rm -rf $TOMCAT_JOB1_PATH/$REPO_NAME/$JAR_NAME
	fi

	chown -R tomcat:tomcat $TOMCAT_JOB1_PATH
	chmod a+x $TOMCAT_JOB1_PATH/conf/server.xml 
	chmod a+x $TOMCAT_JOB1_PATH/conf/web.xml

	sed -i "s/port=\"8005\"/port=\"$JOB_PORT3\"/" $TOMCAT_JOB1_PATH/conf/server.xml
	sed -i "s/port=\"8080\"/port=\"$JOB_PORT1\"/" $TOMCAT_JOB1_PATH/conf/server.xml

        if [ "`grep -o 'disableUploadTimeout="false" autodeploy="false"' $TOMCAT_PG1_PATH/conf/server.xml | wc -l`" -le 0 ]
        then
		sed -i "s/connectionTimeout=\"20000\"/connectionTimeout=\"20000\" disableUploadTimeout=\"false\" autodeploy=\"false\"/" $TOMCAT_JOB1_PATH/conf/server.xml
	fi
	sed -i "s/pathname=\"conf/tomcat-users.xml\"/removeAbandoned=\"true\" logAbandoned=\"true\" removeAbandonedTimeout=\"420\"/" $TOMCAT_PCB1_PATH/conf/server.xml
	sed -i "s/port=\"8009\"/port=\"$JOB_PORT2\"/" $TOMCAT_JOB1_PATH/conf/server.xml
}

# Deploy repo to tomcat
function deploy_bluvault_repo_to_tomcat () 
{
	
	#copy the config file for the path
	if [ ! -e $TOMCAT_PCB1_PATH/conf/server.xml ] 
	then
		cp $TOMCAT_PATH/conf/server.xml $TOMCAT_PCB1_PATH/conf/
	fi
	if [ ! -e $TOMCAT_PCB1_PATH/conf/web.xml ] 
	then
		cp $TOMCAT_PATH/conf/web.xml $TOMCAT_PCB1_PATH/conf/
	fi

	if [[ $FILE_LOCATION == "jenkins" ]]; then
		 wget -P $TOMCAT_PCB1_PATH/$REPO_NAME/ $JENKINS_URL/$JAR_URL_PATH
	elif [[ $FILE_LOCATION == "dns" ]]; then
		 wget --user $DNS_USERNAME --password $DNS_PASS -O $TOMCAT_PCB1_PATH/$REPO_NAME/$JAR_NAME $DNS_URL/$JAR_NAME
	elif [[ $FILE_LOCATION == "local" ]]; then
	       #will be included in file path once repo is part of patch, so currently downloading from DNS	
               cp $FILE_PATH/$JAR_NAME $TOMCAT_PCB1_PATH/$REPO_NAME/$JAR_NAME
#               wget --user $DNS_USERNAME --password $DNS_PASS -O $TOMCAT_PCB1_PATH/$REPO_NAME/$JAR_NAME $DNS_URL/$JAR_NAME
	fi


 	if [ -e $TOMCAT_PCB1_PATH/$REPO_NAME ]; then
		 mkdir -p $BACKUP_OLD/REPO_PG
		 cp -r $TOMCAT_PCB1_PATH/$REPO_NAME  $BACKUP_OLD/REPO_PG
          #       rm $TOMCAT_PCB1_PATH/$REPO_NAME/*.jar
        fi
        if [ ! -e $TOMCAT_PCB1_PATH/$REPO_NAME/$JAR_NAME ]
	then
	         echo "Invalid Repo Jar Name"
	         
	fi

	unzip -oqq $TOMCAT_PCB1_PATH/$REPO_NAME/$JAR_NAME -d $TOMCAT_PCB1_PATH/$REPO_NAME/
	
	sleep 2
	if [[ -d $TOMCAT_PCB1_PATH/$REPO_NAME/$REPO_JAR_FOLDER_NAME ]]; then
		mv $TOMCAT_PCB1_PATH/$REPO_NAME/$REPO_JAR_FOLDER_NAME/* $TOMCAT_PCB1_PATH/$REPO_NAME/
		rm -rf $TOMCAT_PCB1_PATH/$REPO_NAME/$REPO_JAR_FOLDER_NAME
		rm -rf $TOMCAT_PCB1_PATH/$REPO_NAME/$JAR_NAME
	fi
	
	#mod / own 
	chown -R tomcat:tomcat $TOMCAT_PCB1_PATH
	
	chmod a+x $TOMCAT_PCB1_PATH/conf/server.xml 
	chmod a+x $TOMCAT_PCB1_PATH/conf/web.xml

	sed -i "s/port=\"8005\"/port=\"$PORT3\"/" $TOMCAT_PCB1_PATH/conf/server.xml
	sed -i "s/port=\"8080\"/port=\"$PORT1\"/" $TOMCAT_PCB1_PATH/conf/server.xml
        if [ "`grep -o 'connectionTimeout="20000"' $TOMCAT_PCB1_PATH/conf/server.xml | wc -l`" -le 0 ]
        then
		sed -i "s/connectionTimeout=\"20000\"/connectionTimeout=\"20000\" disableUploadTimeout=\"false\" autodeploy=\"false\"/" $TOMCAT_PCB1_PATH/conf/server.xml
 	fi
	sed -i "s/pathname=\"conf/tomcat-users.xml\"/removeAbandoned=\"true\" logAbandoned=\"true\" removeAbandonedTimeout=\"420\"/" $TOMCAT_PCB1_PATH/conf/server.xml
	sed -i "s/port=\"8009\"/port=\"$PORT2\"/" $TOMCAT_PCB1_PATH/conf/server.xml
}

# Configure to run tomcat as service
function configure_bluvault_tomcat_service()
{
	#copy the tomcat-bluvault1 service script into /etc/init.d
	if [ ! -e /etc/init.d/tomcat-pcb1 ] 
	then
		cp $DEFAULT_FILE_PATH/tomcat-pcb1 /etc/init.d/
		chmod a+x /etc/init.d/tomcat-pcb1
		sed -i -e 's/\r//g' /etc/init.d/tomcat-pcb1
	fi

	#copy the tomcat-job1 service script into /etc/init.d
	if [ ! -e /etc/init.d/tomcat-job1 ] 
	then
		cp $DEFAULT_FILE_PATH/tomcat-job1 /etc/init.d/
		chmod a+x /etc/init.d/tomcat-job1
		sed -i -e 's/\r//g' /etc/init.d/tomcat-job1
	fi
}

function verify_bluvault_components ()
{
	if [ ! -e $LOGROTATE_D_PATH/tomcat-job1  ] || [ ! -e $LOGROTATE_D_PATH/tomcat-pcb1  ] 
	then
		echo "bluvault Installation failed. Try again after some time"
		exit 0
	else
		echo "bluvault Successfully installed"
	fi	
}


#create required folder structure
function create_bluVault_folder_structure ()
{
	
	mkdir -p $TOMCAT_PCB1_PATH
	mkdir -p $TOMCAT_PCB1_PATH/conf 
	mkdir -p $TOMCAT_PCB1_PATH/logs 
	mkdir -p $TOMCAT_PCB1_PATH/temp 
	mkdir -p $TOMCAT_PCB1_PATH/webapps 
	mkdir -p $TOMCAT_PCB1_PATH/work
	mkdir -p $TOMCAT_PCB1_PATH/$REPO_NAME


	mkdir -p $TOMCAT_JOB1_PATH
	mkdir -p $TOMCAT_JOB1_PATH/conf
	mkdir -p $TOMCAT_JOB1_PATH/logs
	mkdir -p $TOMCAT_JOB1_PATH/temp
	mkdir -p $TOMCAT_JOB1_PATH/webapps
	mkdir -p $TOMCAT_JOB1_PATH/work
	mkdir -p $TOMCAT_JOB1_PATH/$REPO_NAME

	mkdir -p $UI_PATH/portal
	mkdir -p $UI_PATH/share

	mkdir -p $ROOT_PATH/$CLOUD_NAME
	mkdir -p $ROOT_PATH/$CLOUD_NAME/upload
	mkdir -p $ROOT_PATH/$CLOUD_NAME/f
	mkdir -p $ROOT_PATH/$CLOUD_NAME/t
	mkdir -p $ROOT_PATH/$CLOUD_NAME/backup
	mkdir -p $ROOT_PATH/$CLOUD_NAME/sync-upload
	mkdir -p $ROOT_PATH/support
	mkdir -p $LOG_PATH
        mkdir -p $LOG_PATH/tomcat-job1
	mkdir -p $LOG_PATH/tomcat-pcb1
	mkdir -p $ARCHIVE_PATH/tomcat-job1
	mkdir -p $ARCHIVE_PATH/tomcat-pcb1
	mkdir -p $ROOT_PATH/backup
	mkdir -p $ROOT_PATH/sync
	mkdir -p $ROOT_PATH/bkpOverview
	mkdir -p $PORTAL_LOG_FOLDER
	mkdir -p $LOGROTATEROOTPATH/parablusys
	mkdir -p $LOGROTATEROOTPATH/parablusys/bin

	cp $DEFAULT_FILE_PATH/logrotate/rotate_job1.sh  $LOGROTATEROOTPATH/parablusys/bin/
	cp $DEFAULT_FILE_PATH/logrotate/rotate_pcb1.sh $LOGROTATEROOTPATH/parablusys/bin/
	cp $DEFAULT_FILE_PATH/logrotate/tomcat-pcb1.logrotate $LOGROTATE_D_PATH/tomcat-pcb1
	cp $DEFAULT_FILE_PATH/logrotate/tomcat-job1.logrotate $LOGROTATE_D_PATH/tomcat-job1

	chmod -R 775 $ROOT_PATH/support
	chown -R tomcat:parablu $ROOT_PATH/support
	chmod -R 775 $ROOT_PATH/$CLOUD_NAME
	chown -R tomcat:parablu $ROOT_PATH/$CLOUD_NAME
	chmod -R 775 $ROOT_PATH/bkpOverview
	chown -R tomcat:parablu $ROOT_PATH/bkpOverview
	chmod -R 777 $PORTAL_LOG_FOLDER
	chown -R tomcat:parablu $ROOT_PATH/sync
	chown -R tomcat:parablu $ROOT_PATH/backup
	chown -R root:root $LOGROTATEROOTPATH/parablusys/bin/*
	chmod -R 777 $LOGROTATEROOTPATH/parablusys/bin/*
	chmod -R 775 $LOG_PATH
	chown -R tomcat:tomcat $LOG_PATH/tomcat-job1
	chown -R tomcat:tomcat $LOG_PATH/tomcat-pcb1

	mkdir -p $CLIENT_ROOT_PATH/parablusys
	mkdir -p $CLIENT_ROOT_PATH/parablusys/bin
	mkdir -p $CLIENT_ROOT_PATH/parablusys/upgrade
	mkdir -p $CLIENT_ROOT_PATH/parablusys/clients
	mkdir -p $CLIENT_ROOT_PATH/parablusys/conf
	mkdir -p $CLIENT_ROOT_PATH/parablusys/private
	touch $CLIENT_ROOT_PATH/parablusys/conf/google.config.php
	touch $CLIENT_ROOT_PATH/parablusys/conf/mail.config.php
	touch $CLIENT_ROOT_PATH/parablusys/conf/odc.config.php

	chmod 777 $CLIENT_ROOT_PATH/parablusys/conf/*
}

# stop bluvault
function stop_bluvault_components ()
{
	service memcached stop
	service tomcat-pcb1 stop
	service tomcat-job1 stop
	service apache2 stop
}

# start bluvault
function start_bluvault_components ()
{
	service memcached start
	service tomcat-pcb1 start
	service tomcat-job1 start
	service apache2 start
}


# restarting bluvault
function restart_bluvault_components ()
{
	service memcached restart
	service tomcat-pcb1 restart
	service tomcat-job1 restart
	service apache2 restart
}

# Restarting all the components into init.d
function configure_bluvault_components_start_service ()
{
	echo "service memcached restart
		service tomcat-pcb1 restart
		service tomcat-job1 restart
		service apache2 restart" > /etc/init.d/bluvault_autorun.sh

	chmod a+x /etc/init.d/bluvault_autorun.sh

 	update-rc.d bluvault_autorun.sh defaults
}

function configure_bluvault_in_apache()
{
	sed -i "85iJkMount /$BLUVAULT/* balancer" /etc/apache2/mods-enabled/jk.conf
        sed -i "86iJkMount /$PARACLOUD_SEARCH/* balancer" /etc/apache2/mods-enabled/jk.conf
        sed -i "87iJkMount /$PARAMAIL/* balancer" /etc/apache2/mods-enabled/jk.conf
}

function configure_agent ()
{

	if [[ $FILE_LOCATION == "jenkins" ]]; then
		wget -P $FILE_PATH $JENKINS_URL/$BIN_SCRIPTS_URL_PATH
	elif [[ $FILE_LOCATION == "dns" ]]; then
		#wget --user $DNS_USERNAME --password $DNS_PASS -O $FILE_PATH/$BIN_SCRIPTS_NAME $DNS_URL/$BIN_SCRIPTS_NAME
		wget --user $DNS_USERNAME --password $DNS_PASS -O $FILE_PATH/$WINDOWS_EPA $DNS_URL/$WINDOWS_EPA
		wget --user $DNS_USERNAME --password $DNS_PASS -O $FILE_PATH/$MAC_EPA $DNS_URL/$MAC_EPA
	fi
	mkdir -p $CLIENT_ROOT_PATH/parablusys/clients/

	cp -r $FILE_PATH/$WINDOWS_EPA $CLIENT_ROOT_PATH/parablusys/clients/
	cp -r $FILE_PATH/$MAC_EPA $CLIENT_ROOT_PATH/parablusys/clients/

	# cp $FILE_PATH/scripts.zip  $CLIENT_ROOT_PATH/parablusys/bin/
	#unzip -oqq $FILE_PATH/scripts.zip -d $CLIENT_ROOT_PATH/parablusys/bin/
	#chmod a+x $CLIENT_ROOT_PATH/parablusys/bin/*
	chmod 777 $CLIENT_ROOT_PATH/parablusys/bin/
}

function configure_log4j ()
{
	LOG_PROPERTIES_FILE=WEB-INF/classes/log4j.properties
	sed -i 's|DEBUG|INFO|' $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$LOG_PROPERTIES_FILE
	sed -i 's|/mnt|/parablu|' $TOMCAT_PCB1_PATH/webapps/$BLUVAULT/$LOG_PROPERTIES_FILE
	sed -i 's|DEBUG|INFO|' $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$LOG_PROPERTIES_FILE
	sed -i 's|/mnt|/parablu|' $TOMCAT_PCB1_PATH/webapps/$SUPPORT/$LOG_PROPERTIES_FILE
	sed -i 's|DEBUG|INFO|' $TOMCAT_PCB1_PATH/webapps/$PARAMAIL/$LOG_PROPERTIES_FILE
	sed -i 's|/mnt|/parablu|' $TOMCAT_PCB1_PATH/webapps/$PARAMAIL/$LOG_PROPERTIES_FILE
	sed -i 's|DEBUG|INFO|' $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB/$LOG_PROPERTIES_FILE
        sed -i 's|/mnt|/parablu|' $TOMCAT_JOB1_PATH/webapps/$BLUVAULT_JOB/$LOG_PROPERTIES_FILE
}

#deploy components
function deploy_bluvault_components ()
{
	release_tomcat
	release_apache
	release_php
	release_memcached
	configure_bluvault_tomcat_service
	create_bluVault_folder_structure
	stop_bluvault_components
	deploy_bluvault_repo_to_tomcat
	deploy_bluvault_job_repo_to_tomcat
	deploy_bluvault_war_to_tomcat
	deploy_bluvault_job_war_to_tomcat
}


#Config components
function config_bluvault_components ()
{
	configure_bluvault_war_in_tomcat
	configure_bluvault_job_war_in_tomcat
	configure_bluvault_components_start_service
	configure_bluvault_in_apache
	configure_agent
	configure_log4j
}

# external function to install bluvault components
function release_bluvault () 
{
	deploy_bluvault_components 2>&1 >> install.log
	config_bluvault_components 2>&1 >> install.log
	release_portal 2>&1 >> install.log
	verify_bluvault_components 2>&1 >> install.log 
	start_bluvault_components 2>&1 >> install.log
}

function rollback_bluvault ()
{
        rm -rf $ROOT_PATH/$CLOUD_NAME
	rm -rf $ROOT_PATH/support
	rm -rf $ROOT_PATH/backup
	rm -rf $ROOT_PATH/sync
	rm -rf $ROOT_PATH/bkpOverview
	rm -rf $LOG_PATH/tomcat-job1
        rm -rf $LOG_PATH/tomcat-pcb1
        rm -rf $ARCHIVE_PATH/tomcat-job1
        rm -rf $ARCHIVE_PATH/tomcat-pcb1
        rm -rf $CLIENT_ROOT_PATH/parablusys

	rollback_portal
        echo "Uninstalling Tomcat "
        uninstall_tomcat
        echo "Uninstalling Apache"
        uninstall_apache
        echo "Uninstalling Php"
        uninstall_php
        echo "Uninstalling Memcached"
        uninstall_memcached
}

