
#!/bin/bash
#                                                                                       #
# SCRIPT: ubuntu_service.sh		                                                #
# DATE:   27-Oct-2016                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems								#
# PURPOSE: Contains all the utility functions for Ubuntu platform                       #
# PLATFORM: Ubuntu                                                                      #

# Adding tomcat and www-data users to parablu group
function add_system_users()
{
	# for tomcat-user
	useradd tomcat
	# for parablu group
	addgroup parablu
	#link parablu to tomcat
	adduser tomcat parablu
	#link www-data to parablu
	adduser www-data parablu
}

# Install openssh-server, bash-completion, zip, ufw, telnet, traceroute, sysstat 
function install_common_packages () 
{
	#system Update/Upgrade
	apt-get -y update 
	apt-get -y upgrade 

	#common packages for ubunut server
	apt-get -y install openssh-server 
	apt-get -y install bash-completion 
	apt-get -y install zip 
	apt-get -y install ufw 
	apt-get -y install telnet 

	allow_network_firewall 
	apt-get -y install telnet 
	apt-get -y install traceroute 
	apt-get -y install sysstat 
}

#Enable network port
function allow_network_firewall ()
{
	echo 'y' | ufw enable                                             
      	ufw allow ssh
      	ufw allow https
      	ufw allow http  
      	ufw allow 5984
}

#install jre
function install_jre ()
{
	#Java
	apt-get -y install software-properties-common 
	apt-get -y install python3-software-properties 
	add-apt-repository -y ppa:openjdk-r/ppa 
	apt-get -y update 
	apt-get -y install openjdk-8-jre 
}
